/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.reaktivity.command.log.internal.LoggableStream;
import org.reaktivity.command.log.internal.Logger;
import org.reaktivity.command.log.internal.labels.LabelManager;
import org.reaktivity.command.log.internal.layouts.StreamsLayout;
import org.reaktivity.reaktor.ReaktorConfiguration;

public final class LogStreamsCommand
implements Runnable {
    private static final Pattern STREAMS_PATTERN = Pattern.compile("data(\\d+)");
    private static final long MAX_PARK_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long MIN_PARK_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final int MAX_YIELDS = 30;
    private static final int MAX_SPINS = 20;
    private final Path directory;
    private final LabelManager labels;
    private final boolean verbose;
    private final boolean continuous;
    private final long affinity;
    private final Logger out;
    private final Long2LongHashMap budgets;
    private final Long2LongHashMap timestamps;
    private long nextTimestamp = Long.MAX_VALUE;

    LogStreamsCommand(ReaktorConfiguration config, Logger out, boolean verbose, boolean continuous, long affinity) {
        this.directory = config.directory();
        this.labels = new LabelManager(this.directory);
        this.verbose = verbose;
        this.continuous = continuous;
        this.affinity = affinity;
        this.out = out;
        this.budgets = new Long2LongHashMap(-1L);
        this.timestamps = new Long2LongHashMap(-1L);
    }

    private boolean isStreamsFile(Path path) {
        int depth = path.getNameCount() - this.directory.getNameCount();
        if (depth != 1 || !Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        Matcher matcher = STREAMS_PATTERN.matcher(path.getName(path.getNameCount() - 1).toString());
        return matcher.matches() && (1L << Integer.parseInt(matcher.group(1)) & this.affinity) != 0L;
    }

    private LoggableStream newLoggable(Path path) {
        String filename = path.getFileName().toString();
        Matcher matcher = STREAMS_PATTERN.matcher(filename);
        matcher.matches();
        int index = Integer.parseInt(matcher.group(1));
        StreamsLayout layout = new StreamsLayout.Builder().path(path).readonly(true).build();
        return new LoggableStream(index, this.labels, this.budgets, layout, this.out, this.verbose, this.timestamps, this::nextTimestamp);
    }

    private void onDiscovered(Path path) {
        if (this.verbose) {
            this.out.printf("Discovered: %s\n", path);
        }
    }

    @Override
    public void run() {
        try (Stream<Path> files = Files.walk(this.directory, 3, new FileVisitOption[0]);){
            int workCount;
            LoggableStream[] loggables = (LoggableStream[])files.filter(this::isStreamsFile).peek(this::onDiscovered).map(this::newLoggable).toArray(LoggableStream[]::new);
            BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(20L, 30L, MIN_PARK_NS, MAX_PARK_NS);
            int exitWorkCount = this.continuous ? -1 : 0;
            do {
                workCount = 0;
                for (int i = 0; i < loggables.length; ++i) {
                    workCount += loggables[i].process();
                }
                idleStrategy.idle(workCount);
            } while (workCount != exitWorkCount);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    private boolean nextTimestamp(long timestamp) {
        if (timestamp != this.nextTimestamp) {
            this.nextTimestamp = Math.min(timestamp, this.nextTimestamp);
            return false;
        }
        this.nextTimestamp = Long.MAX_VALUE;
        return true;
    }
}

