/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.util.concurrent.atomic.AtomicInteger;
import org.agrona.DirectBuffer;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.command.log.internal.Logger;
import org.reaktivity.command.log.internal.layouts.RoutesLayout;
import org.reaktivity.command.log.internal.types.OctetsFW;
import org.reaktivity.command.log.internal.types.control.RouteFW;
import org.reaktivity.command.log.internal.types.control.TlsRouteExFW;
import org.reaktivity.command.log.internal.types.state.RouteTableFW;

public final class LoggableRoutes
implements AutoCloseable {
    private final RouteTableFW routeTableRO = new RouteTableFW();
    private final RouteFW routeRO = new RouteFW();
    private final RoutesLayout routes;
    private final Logger out;
    private final IdleStrategy idleStrategy;
    private final UnsafeBuffer routesSnapshot;
    private final LongHashSet loggedRoutes;

    LoggableRoutes(RoutesLayout routes, Logger logger, IdleStrategy idleStrategy) {
        this.routes = routes;
        this.out = logger;
        this.idleStrategy = idleStrategy;
        this.routesSnapshot = new UnsafeBuffer(new byte[routes.routesBuffer().capacity()]);
        this.loggedRoutes = new LongHashSet(-1);
    }

    int process() {
        DirectBuffer routesBuffer = this.routes.routesBuffer();
        routesBuffer.getBytes(0, this.routesSnapshot, 0, routesBuffer.capacity());
        RouteTableFW routeTableSnapshot = this.routeTableRO.wrap(this.routesSnapshot, 0, this.routesSnapshot.capacity());
        int modCountSnapshot = routeTableSnapshot.modificationCount();
        RouteTableFW routeTable = this.routeTableRO.wrap(routesBuffer, 0, routesBuffer.capacity());
        int modCount = routeTable.modificationCount();
        if (modCount == modCountSnapshot) {
            return this.logRoutes(routeTableSnapshot, new LongHashSet(-1), new AtomicInteger(0));
        }
        this.idleStrategy.idle();
        return this.process();
    }

    private int logRoutes(RouteTableFW routeTable, LongHashSet thisIterationRoutes, AtomicInteger workCnt) {
        routeTable.entries().forEach(e -> {
            OctetsFW octets = e.route();
            RouteFW route = this.routeRO.wrap(octets.buffer(), octets.offset(), octets.limit());
            long correlationId = route.correlationId();
            String nukleusName = route.nukleus().asString();
            String role = route.role().toString();
            String localAddress = route.localAddress().asString();
            String remoteAddress = route.remoteAddress().asString();
            long authorization = route.authorization();
            thisIterationRoutes.add(correlationId);
            if (!this.loggedRoutes.contains(correlationId)) {
                workCnt.incrementAndGet();
                String extension = this.extension(route);
                this.out.printf("{\"$nukleus\":\"%s\", \"$id\":%d, \"role\":\"%s\", \"authorization\":%d, \"localAddress\":\"%s\", \"remoteAddress\":\"%s\"%s}\n", nukleusName, correlationId, role, authorization, localAddress, remoteAddress, extension == null ? "" : String.format(", \"extension\": %s", extension));
                this.loggedRoutes.add(correlationId);
                workCnt.incrementAndGet();
            }
        });
        LongHashSet removedRoutes = this.loggedRoutes.difference(thisIterationRoutes);
        if (removedRoutes != null) {
            removedRoutes.stream().forEach(correlationId -> {
                this.out.printf("Unrouted %d\n", correlationId);
                this.loggedRoutes.remove(correlationId);
            });
        }
        return workCnt.get();
    }

    private String extension(RouteFW route) {
        String nukleusName = route.nukleus().asString();
        String extension = null;
        if ("tls".equals(nukleusName)) {
            TlsRouteExFW ext = new TlsRouteExFW();
            int index = route.extension().offset();
            ext.wrap(route.extension().buffer(), index, index + route.extension().sizeof());
            String applicationProtocol = ext.applicationProtocol().asString();
            String hostname = ext.hostname().asString();
            String store = ext.store().asString();
            extension = String.format("{\"store\":%s,\"hostname\":%s,\"applicationProtocol\":%s}", store != null ? String.format("\"%s\"", store) : null, hostname != null ? String.format("\"%s\"", hostname) : null, applicationProtocol != null ? String.format("\"%s\"", applicationProtocol) : null);
        }
        return extension;
    }

    @Override
    public void close() throws Exception {
        this.routes.close();
    }
}

