/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.labels;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.agrona.LangUtil;

public final class LabelManager {
    private final List<String> labels = new CopyOnWriteArrayList<String>();
    private final Map<String, Integer> labelIds = new ConcurrentHashMap<String, Integer>();
    private final Path labelsPath;
    private long sizeInBytes;

    public LabelManager(Path directory) {
        this.labelsPath = directory.resolve("labels");
        this.sizeInBytes = -1L;
    }

    public String lookupLabel(int labelId) {
        if (labelId < 1 || labelId > this.labels.size()) {
            this.checkSnapshot();
        }
        return labelId >= 1 && labelId <= this.labels.size() ? this.labels.get(labelId - 1) : "??";
    }

    private void checkSnapshot() {
        block14: {
            try {
                if (this.sizeInBytes != -1L && this.sizeInBytes >= Files.size(this.labelsPath)) break block14;
                Files.createDirectories(this.labelsPath.getParent(), new FileAttribute[0]);
                try (FileChannel channel = FileChannel.open(this.labelsPath, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                    this.labels.clear();
                    this.labelIds.clear();
                    try (BufferedReader in = new BufferedReader(Channels.newReader((ReadableByteChannel)channel, StandardCharsets.UTF_8.name()));){
                        String label = in.readLine();
                        while (label != null) {
                            this.labels.add(label);
                            this.labelIds.put(label, this.labels.size());
                            label = in.readLine();
                        }
                        this.sizeInBytes = channel.position();
                    }
                }
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked(ex);
            }
        }
    }
}

