/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.layouts;

import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.command.log.internal.layouts.Layout;

public final class MetricsLayout
extends Layout {
    private static final int METRICS_VERSION = 1;
    private static final int FIELD_OFFSET_VERSION = 0;
    private static final int FIELD_SIZE_VERSION = 4;
    private static final int FIELD_OFFSET_LABELS_BUFFER_LENGTH = 4;
    private static final int FIELD_SIZE_COUNTER_LABELS_BUFFER_LENGTH = 4;
    private static final int FIELD_OFFSET_VALUES_BUFFER_LENGTH = 8;
    private static final int FIELD_SIZE_COUNTER_VALUES_BUFFER_LENGTH = 4;
    private static final int END_OF_META_DATA_OFFSET = BitUtil.align(12, 64);
    private final AtomicBuffer labelsBuffer = new UnsafeBuffer(new byte[0]);
    private final AtomicBuffer valuesBuffer = new UnsafeBuffer(new byte[0]);

    public AtomicBuffer labelsBuffer() {
        return this.labelsBuffer;
    }

    public AtomicBuffer valuesBuffer() {
        return this.valuesBuffer;
    }

    @Override
    public void close() {
        IoUtil.unmap(this.labelsBuffer.byteBuffer());
        IoUtil.unmap(this.valuesBuffer.byteBuffer());
    }

    public static final class Builder
    extends Layout.Builder<MetricsLayout> {
        private final MetricsLayout layout = new MetricsLayout();
        private Path path;
        private int labelsBufferCapacity;
        private int valuesBufferCapacity;
        private boolean readonly;

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Path controlPath() {
            return this.path;
        }

        public Builder labelsBufferCapacity(int labelsBufferCapacity) {
            this.labelsBufferCapacity = labelsBufferCapacity;
            return this;
        }

        public Builder valuesBufferCapacity(int valuesBufferCapacity) {
            this.valuesBufferCapacity = valuesBufferCapacity;
            return this;
        }

        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        @Override
        public MetricsLayout build() {
            File metricsFile = this.path.toFile();
            if (!this.readonly) {
                int labelsBufferLength = this.labelsBufferCapacity;
                int valuesBufferLength = this.valuesBufferCapacity;
                CloseHelper.close(IoUtil.createEmptyFile(metricsFile, END_OF_META_DATA_OFFSET + labelsBufferLength + valuesBufferLength));
                MappedByteBuffer metadata = IoUtil.mapExistingFile(metricsFile, "metadata", 0L, END_OF_META_DATA_OFFSET);
                metadata.putInt(0, 1);
                metadata.putInt(4, this.labelsBufferCapacity);
                metadata.putInt(8, this.valuesBufferCapacity);
                IoUtil.unmap(metadata);
            } else {
                MappedByteBuffer metadata = IoUtil.mapExistingFile(metricsFile, "metadata", 0L, END_OF_META_DATA_OFFSET);
                assert (1 == metadata.getInt(0));
                this.labelsBufferCapacity = metadata.getInt(4);
                this.valuesBufferCapacity = metadata.getInt(8);
                IoUtil.unmap(metadata);
            }
            int labelsBufferOffset = END_OF_META_DATA_OFFSET;
            int labelsBufferLength = this.labelsBufferCapacity;
            this.layout.labelsBuffer.wrap(IoUtil.mapExistingFile(metricsFile, "labels", labelsBufferOffset, labelsBufferLength));
            int valuesBufferOffset = labelsBufferOffset + labelsBufferLength;
            int valuesBufferLength = this.valuesBufferCapacity;
            this.layout.valuesBuffer.wrap(IoUtil.mapExistingFile(metricsFile, "values", valuesBufferOffset, valuesBufferLength));
            return this.layout;
        }
    }
}

