/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.layouts;

import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.command.log.internal.layouts.Layout;

public final class RoutesLayout
extends Layout {
    private final DirectBuffer routesBuffer;

    private RoutesLayout(DirectBuffer routesBuffer) {
        this.routesBuffer = routesBuffer;
    }

    @Override
    public void close() {
        IoUtil.unmap(this.routesBuffer.byteBuffer());
    }

    public DirectBuffer routesBuffer() {
        return this.routesBuffer;
    }

    public static final class Builder
    extends Layout.Builder<RoutesLayout> {
        private Path path;

        public Builder routesPath(Path path) {
            this.path = path;
            return this;
        }

        @Override
        public RoutesLayout build() {
            File routes = this.path.toFile();
            MappedByteBuffer mappedRoutes = IoUtil.mapExistingFile(routes, "routes");
            UnsafeBuffer routesBuffer = new UnsafeBuffer(mappedRoutes);
            return new RoutesLayout(routesBuffer);
        }
    }
}

