/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.layouts;

import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.reaktivity.command.log.internal.layouts.Layout;
import org.reaktivity.command.log.internal.spy.OneToOneRingBufferSpy;
import org.reaktivity.command.log.internal.spy.RingBufferSpy;

public final class StreamsLayout
extends Layout {
    private final RingBufferSpy streamsBuffer;

    private StreamsLayout(RingBufferSpy streamsBuffer) {
        this.streamsBuffer = streamsBuffer;
    }

    public RingBufferSpy streamsBuffer() {
        return this.streamsBuffer;
    }

    @Override
    public void close() {
        IoUtil.unmap(this.streamsBuffer.buffer().byteBuffer());
    }

    public static final class Builder
    extends Layout.Builder<StreamsLayout> {
        private long streamsCapacity;
        private Path path;
        private boolean readonly;

        public Builder streamsCapacity(long streamsCapacity) {
            this.streamsCapacity = streamsCapacity;
            return this;
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        @Override
        public StreamsLayout build() {
            File layoutFile = this.path.toFile();
            if (!this.readonly) {
                IoUtil.createEmptyFile(layoutFile, this.streamsCapacity + (long)RingBufferDescriptor.TRAILER_LENGTH);
            }
            MappedByteBuffer mappedStreams = IoUtil.mapExistingFile(layoutFile, "streams");
            UnsafeBuffer atomicStreams = new UnsafeBuffer(mappedStreams);
            return new StreamsLayout(new OneToOneRingBufferSpy(atomicStreams));
        }
    }
}

