/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types;

import java.nio.ByteOrder;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;

public final class ListFW<T extends Flyweight>
extends Flyweight {
    private static final int FIELD_SIZE_LENGTH = 4;
    private final ByteOrder byteOrder;
    private final T itemRO;

    public ListFW(T itemRO) {
        this.itemRO = (Flyweight)Objects.requireNonNull(itemRO);
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public ListFW(T itemRO, ByteOrder byteOrder) {
        this.itemRO = (Flyweight)Objects.requireNonNull(itemRO);
        this.byteOrder = byteOrder;
    }

    @Override
    public int limit() {
        return this.offset() + 4 + this.length0();
    }

    @Override
    public ListFW<T> tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit) || offset + 4 > maxLimit) {
            return null;
        }
        if (this.length0() < 0) {
            throw new IllegalArgumentException(String.format("Invalid list at offset %d: size < 0", offset));
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public ListFW<T> wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        ListFW.checkLimit(offset + 4, maxLimit);
        if (this.length0() < 0) {
            throw new IllegalArgumentException(String.format("Invalid list at offset %d: size < 0", offset));
        }
        ListFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public ListFW<T> forEach(Consumer<? super T> consumer) {
        int offset = this.offset() + 4;
        while (offset < this.limit()) {
            ((Flyweight)this.itemRO).wrap(this.buffer(), offset, this.limit());
            consumer.accept(this.itemRO);
            offset = ((Flyweight)this.itemRO).limit();
        }
        return this;
    }

    public boolean anyMatch(Predicate<? super T> predicate) {
        int offset = this.offset() + 4;
        while (offset < this.limit()) {
            ((Flyweight)this.itemRO).wrap(this.buffer(), offset, this.maxLimit());
            if (predicate.test(this.itemRO)) {
                return true;
            }
            offset = ((Flyweight)this.itemRO).limit();
        }
        return false;
    }

    public T matchFirst(Predicate<? super T> predicate) {
        int offset = this.offset() + 4;
        while (offset < this.limit()) {
            ((Flyweight)this.itemRO).wrap(this.buffer(), offset, this.maxLimit());
            if (predicate.test(this.itemRO)) {
                return this.itemRO;
            }
            offset = ((Flyweight)this.itemRO).limit();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.length0() == 0;
    }

    public String toString() {
        return String.format("ARRAY containing %d bytes of data", this.length0());
    }

    private int length0() {
        return this.buffer().getInt(this.offset(), this.byteOrder);
    }

    public static final class Builder<B extends Flyweight.Builder<T>, T extends Flyweight>
    extends Flyweight.Builder<ListFW<T>> {
        private final ByteOrder byteOrder;
        private final B itemRW;

        public Builder(B itemRW, T itemRO) {
            super(new ListFW<T>(itemRO));
            this.byteOrder = ByteOrder.nativeOrder();
            this.itemRW = itemRW;
        }

        public Builder(B itemRW, T itemRO, ByteOrder byteOrder) {
            super(new ListFW<T>(itemRO));
            this.byteOrder = byteOrder;
            this.itemRW = itemRW;
        }

        public Builder<B, T> wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            int newLimit = offset + 4;
            Flyweight.checkLimit(newLimit, maxLimit);
            super.limit(newLimit);
            return this;
        }

        public Builder<B, T> item(Consumer<B> mutator) {
            ((Flyweight.Builder)this.itemRW).wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(this.itemRW);
            this.limit(((Flyweight)((Flyweight.Builder)this.itemRW).build()).limit());
            return this;
        }

        @Override
        public ListFW<T> build() {
            int sizeInBytes = this.limit() - this.offset() - 4;
            this.buffer().putInt(this.offset(), sizeInBytes, this.byteOrder);
            return (ListFW)super.build();
        }
    }
}

