/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.control;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.StringFW;

public final class TlsRouteExFW
extends Flyweight {
    public static final int FIELD_OFFSET_STORE = 0;
    public static final int FIELD_OFFSET_HOSTNAME = 0;
    public static final int FIELD_OFFSET_APPLICATION_PROTOCOL = 0;
    private final StringFW storeRO = new StringFW();
    private final StringFW hostnameRO = new StringFW();
    private final StringFW applicationProtocolRO = new StringFW();

    public StringFW store() {
        return this.storeRO;
    }

    public StringFW hostname() {
        return this.hostnameRO;
    }

    public StringFW applicationProtocol() {
        return this.applicationProtocolRO;
    }

    @Override
    public TlsRouteExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.storeRO.wrap(buffer, offset + 0, maxLimit);
        this.hostnameRO.wrap(buffer, this.storeRO.limit() + 0, maxLimit);
        this.applicationProtocolRO.wrap(buffer, this.hostnameRO.limit() + 0, maxLimit);
        TlsRouteExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public TlsRouteExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.storeRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.hostnameRO.tryWrap(buffer, this.storeRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.applicationProtocolRO.tryWrap(buffer, this.hostnameRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.applicationProtocolRO.limit();
    }

    public String toString() {
        return String.format("TLS_ROUTE_EX [store=%s, hostname=%s, applicationProtocol=%s]", this.storeRO.asString(), this.hostnameRO.asString(), this.applicationProtocolRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<TlsRouteExFW> {
        private static final int INDEX_STORE = 0;
        private static final int INDEX_HOSTNAME = 1;
        private static final int INDEX_APPLICATION_PROTOCOL = 2;
        private static final int FIELD_COUNT = 3;
        private final StringFW.Builder storeRW = new StringFW.Builder();
        private final StringFW.Builder hostnameRW = new StringFW.Builder();
        private final StringFW.Builder applicationProtocolRW = new StringFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new TlsRouteExFW());
        }

        private StringFW.Builder store() {
            assert (this.lastFieldSet == -1);
            return this.storeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder store(String value) {
            StringFW.Builder storeRW = this.store();
            storeRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(storeRW.build().limit());
            return this;
        }

        public Builder store(StringFW value) {
            StringFW.Builder storeRW = this.store();
            storeRW.set(value);
            this.lastFieldSet = 0;
            this.limit(storeRW.build().limit());
            return this;
        }

        public Builder store(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder storeRW = this.store();
            storeRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(storeRW.build().limit());
            return this;
        }

        private StringFW.Builder hostname() {
            assert (this.lastFieldSet == 0);
            return this.hostnameRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder hostname(String value) {
            StringFW.Builder hostnameRW = this.hostname();
            hostnameRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(hostnameRW.build().limit());
            return this;
        }

        public Builder hostname(StringFW value) {
            StringFW.Builder hostnameRW = this.hostname();
            hostnameRW.set(value);
            this.lastFieldSet = 1;
            this.limit(hostnameRW.build().limit());
            return this;
        }

        public Builder hostname(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder hostnameRW = this.hostname();
            hostnameRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(hostnameRW.build().limit());
            return this;
        }

        private StringFW.Builder applicationProtocol() {
            assert (this.lastFieldSet == 1);
            return this.applicationProtocolRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder applicationProtocol(String value) {
            StringFW.Builder applicationProtocolRW = this.applicationProtocol();
            applicationProtocolRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(applicationProtocolRW.build().limit());
            return this;
        }

        public Builder applicationProtocol(StringFW value) {
            StringFW.Builder applicationProtocolRW = this.applicationProtocol();
            applicationProtocolRW.set(value);
            this.lastFieldSet = 2;
            this.limit(applicationProtocolRW.build().limit());
            return this;
        }

        public Builder applicationProtocol(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder applicationProtocolRW = this.applicationProtocol();
            applicationProtocolRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(applicationProtocolRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public TlsRouteExFW build() {
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (TlsRouteExFW)super.build();
        }
    }
}

