/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.TcpAddressFW;

public final class TcpBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_LOCAL_ADDRESS = 0;
    public static final int FIELD_OFFSET_LOCAL_PORT = 0;
    private static final int FIELD_SIZE_LOCAL_PORT = 2;
    public static final int FIELD_OFFSET_REMOTE_ADDRESS = 2;
    public static final int FIELD_OFFSET_REMOTE_PORT = 0;
    private static final int FIELD_SIZE_REMOTE_PORT = 2;
    private final TcpAddressFW localAddressRO = new TcpAddressFW();
    private final TcpAddressFW remoteAddressRO = new TcpAddressFW();

    public TcpAddressFW localAddress() {
        return this.localAddressRO;
    }

    public int localPort() {
        return this.buffer().getShort(this.localAddressRO.limit() + 0) & 0xFFFF;
    }

    public TcpAddressFW remoteAddress() {
        return this.remoteAddressRO;
    }

    public int remotePort() {
        return this.buffer().getShort(this.remoteAddressRO.limit() + 0) & 0xFFFF;
    }

    @Override
    public TcpBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.localAddressRO.wrap(buffer, offset + 0, maxLimit);
        this.remoteAddressRO.wrap(buffer, this.localAddressRO.limit() + 2, maxLimit);
        TcpBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public TcpBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.localAddressRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.remoteAddressRO.tryWrap(buffer, this.localAddressRO.limit() + 2, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.remoteAddressRO.limit() + 0 + 2;
    }

    public String toString() {
        return String.format("TCP_BEGIN_EX [localAddress=%s, localPort=%d, remoteAddress=%s, remotePort=%d]", this.localAddress(), this.localPort(), this.remoteAddress(), this.remotePort());
    }

    public static final class Builder
    extends Flyweight.Builder<TcpBeginExFW> {
        private static final int INDEX_LOCAL_ADDRESS = 0;
        private static final int INDEX_LOCAL_PORT = 1;
        private static final int INDEX_REMOTE_ADDRESS = 2;
        private static final int INDEX_REMOTE_PORT = 3;
        private static final int FIELD_COUNT = 4;
        private final TcpAddressFW.Builder localAddressRW = new TcpAddressFW.Builder();
        private final TcpAddressFW.Builder remoteAddressRW = new TcpAddressFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new TcpBeginExFW());
        }

        public Builder localAddress(Consumer<TcpAddressFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            TcpAddressFW.Builder localAddressRW = this.localAddressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(localAddressRW);
            this.limit(((TcpAddressFW)localAddressRW.build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder localPort(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"localPort\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"localPort\"", value));
            }
            if (this.lastFieldSet < 0) {
                this.localAddress(b -> {});
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 2;
            TcpBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF));
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder remoteAddress(Consumer<TcpAddressFW.Builder> mutator) {
            assert (this.lastFieldSet == 1);
            TcpAddressFW.Builder remoteAddressRW = this.remoteAddressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(remoteAddressRW);
            this.limit(((TcpAddressFW)remoteAddressRW.build()).limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder remotePort(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"remotePort\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"remotePort\"", value));
            }
            if (this.lastFieldSet < 2) {
                this.remoteAddress(b -> {});
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 2;
            TcpBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF));
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public TcpBeginExFW build() {
            assert (this.lastFieldSet == 3);
            this.lastFieldSet = -1;
            return (TcpBeginExFW)super.build();
        }
    }
}

