/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class Configuration {
    private static final ConfigurationDef EMPTY_DEFINITION = new ConfigurationDef("");
    private final ConfigurationDef definition;
    private final BiFunction<String, String, String> getProperty;
    private final BiFunction<String, String, String> getPropertyDefault;

    public Configuration() {
        this.definition = EMPTY_DEFINITION;
        this.getProperty = System::getProperty;
        this.getPropertyDefault = (p, d) -> d;
    }

    public Configuration(Properties properties) {
        Objects.requireNonNull(properties, "properties");
        this.definition = EMPTY_DEFINITION;
        this.getProperty = properties::getProperty;
        this.getPropertyDefault = (p, d) -> d;
    }

    protected Configuration(Configuration config) {
        this(EMPTY_DEFINITION, config);
    }

    protected Configuration(ConfigurationDef definition, Configuration config) {
        this.definition = definition;
        this.getProperty = config.getProperty;
        this.getPropertyDefault = config.getPropertyDefault;
    }

    protected Configuration(ConfigurationDef definition, Properties properties) {
        Objects.requireNonNull(properties, "properties");
        this.definition = definition;
        this.getProperty = properties::getProperty;
        this.getPropertyDefault = (p, d) -> d;
    }

    protected Configuration(Configuration config, Properties defaultOverrides) {
        this(EMPTY_DEFINITION, config, defaultOverrides);
    }

    protected Configuration(ConfigurationDef definition, Configuration config, Properties defaultOverrides) {
        this.definition = definition;
        this.getProperty = config.getProperty;
        this.getPropertyDefault = defaultOverrides::getProperty;
    }

    @Deprecated
    public Path directory() {
        return Paths.get(this.getProperty("reaktor.directory", "."), new String[0]);
    }

    public void properties(BiConsumer<String, Object> valueAction, BiConsumer<String, Object> defaultAction) {
        for (PropertyDef key : this.definition.properties.values()) {
            Object value = key.value(this);
            if (value != null) {
                valueAction.accept(key.name, value);
                continue;
            }
            Object defaultValue = key.defaultValue(this);
            defaultAction.accept(key.name, defaultValue);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.properties((s, o) -> sb.append(String.format("%s = %s (override)\n", s, o)), (s, o) -> sb.append(String.format("%s = %s (default)\n", s, o)));
        return sb.toString();
    }

    String getProperty(String key, String defaultValue) {
        return this.getProperty.apply(key, this.getPropertyDefault.apply(key, defaultValue));
    }

    @FunctionalInterface
    static interface ToCharFunction<T> {
        public char applyAsChar(T var1);
    }

    @FunctionalInterface
    static interface ToFloatFunction<T> {
        public float applyAsFloat(T var1);
    }

    @FunctionalInterface
    static interface ToShortFunction<T> {
        public short applyAsShort(T var1);
    }

    @FunctionalInterface
    static interface ToByteFunction<T> {
        public byte applyAsByte(T var1);
    }

    private static final class ObjectPropertyDef<T>
    extends PropertyDef<T> {
        private final Function<String, T> decodeValue;
        private final Function<Configuration, T> defaultValue;

        private ObjectPropertyDef(Class<T> kind, String name, Function<String, T> decodeValue, T defaultValue) {
            this(kind, name, decodeValue, c -> defaultValue);
        }

        private ObjectPropertyDef(Class<T> kind, String name, Function<String, T> decodeValue, Function<Configuration, T> defaultValue) {
            super(kind, name);
            this.decodeValue = decodeValue;
            this.defaultValue = defaultValue;
        }

        @Override
        public T value(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? (T)this.decodeValue.apply(value) : null;
        }

        @Override
        public T defaultValue(Configuration config) {
            String value = (String)config.getPropertyDefault.apply(this.name, null);
            return value != null ? this.decodeValue.apply(value) : this.defaultValue.apply(config);
        }
    }

    public static final class CharPropertyDef
    extends PropertyDef<Character> {
        private final ToCharFunction<Configuration> defaultValue;

        private CharPropertyDef(String name, char defaultValue) {
            this(name, (Configuration c) -> defaultValue);
        }

        private CharPropertyDef(String name, ToCharFunction<Configuration> defaultValue) {
            super(Character.class, name);
            this.defaultValue = defaultValue;
        }

        public char getAsChar(Configuration config) {
            return ((Character)this.get(config)).charValue();
        }

        @Override
        public Character value(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? CharPropertyDef.parseCharacter(value) : null;
        }

        @Override
        public Character defaultValue(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return Character.valueOf(value != null ? CharPropertyDef.parseCharacter(value).charValue() : this.defaultValue.applyAsChar(config));
        }

        private static Character parseCharacter(String value) {
            if (value.length() != 1) {
                throw new IllegalArgumentException(String.format("invalid char: %s", value));
            }
            return Character.valueOf(value.charAt(0));
        }
    }

    public static final class DoublePropertyDef
    extends PropertyDef<Double> {
        private final ToDoubleFunction<Configuration> defaultValue;

        private DoublePropertyDef(String name, double defaultValue) {
            this(name, (Configuration c) -> defaultValue);
        }

        private DoublePropertyDef(String name, ToDoubleFunction<Configuration> defaultValue) {
            super(Double.class, name);
            this.defaultValue = defaultValue;
        }

        public double getAsDouble(Configuration config) {
            return (Double)this.get(config);
        }

        @Override
        public Double value(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? Double.valueOf(Double.parseDouble(value)) : null;
        }

        @Override
        public Double defaultValue(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? Double.parseDouble(value) : this.defaultValue.applyAsDouble(config);
        }
    }

    public static final class FloatPropertyDef
    extends PropertyDef<Float> {
        private final ToFloatFunction<Configuration> defaultValue;

        private FloatPropertyDef(String name, float defaultValue) {
            this(name, (Configuration c) -> defaultValue);
        }

        private FloatPropertyDef(String name, ToFloatFunction<Configuration> defaultValue) {
            super(Float.class, name);
            this.defaultValue = defaultValue;
        }

        public float getAsFloat(Configuration config) {
            return ((Float)this.get(config)).floatValue();
        }

        @Override
        public Float value(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? Float.valueOf(Float.parseFloat(value)) : null;
        }

        @Override
        public Float defaultValue(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return Float.valueOf(value != null ? Float.parseFloat(value) : this.defaultValue.applyAsFloat(config));
        }
    }

    public static final class LongPropertyDef
    extends PropertyDef<Long> {
        private final ToLongFunction<Configuration> defaultValue;

        private LongPropertyDef(String name, long defaultValue) {
            this(name, (Configuration c) -> defaultValue);
        }

        private LongPropertyDef(String name, ToLongFunction<Configuration> defaultValue) {
            super(Long.class, name);
            this.defaultValue = defaultValue;
        }

        public long getAsLong(Configuration config) {
            return (Long)this.get(config);
        }

        @Override
        public Long value(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? Long.decode(value) : null;
        }

        @Override
        public Long defaultValue(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? Long.decode(value).longValue() : this.defaultValue.applyAsLong(config);
        }
    }

    public static final class IntPropertyDef
    extends PropertyDef<Integer> {
        private final ToIntFunction<Configuration> defaultValue;

        private IntPropertyDef(String name, int defaultValue) {
            this(name, (Configuration c) -> defaultValue);
        }

        private IntPropertyDef(String name, ToIntFunction<Configuration> defaultValue) {
            super(Integer.class, name);
            this.defaultValue = defaultValue;
        }

        public int getAsInt(Configuration config) {
            return (Integer)this.get(config);
        }

        @Override
        public Integer value(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? Integer.decode(value) : null;
        }

        @Override
        public Integer defaultValue(Configuration config) {
            String value = (String)config.getPropertyDefault.apply(this.name, null);
            return value != null ? Integer.decode(value).intValue() : this.defaultValue.applyAsInt(config);
        }
    }

    public static final class ShortPropertyDef
    extends PropertyDef<Short> {
        private final ToShortFunction<Configuration> defaultValue;

        private ShortPropertyDef(String name, short defaultValue) {
            this(name, (Configuration c) -> defaultValue);
        }

        private ShortPropertyDef(String name, ToShortFunction<Configuration> defaultValue) {
            super(Short.class, name);
            this.defaultValue = defaultValue;
        }

        public short getAsShort(Configuration config) {
            return (Short)this.get(config);
        }

        @Override
        public Short value(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? Short.decode(value) : null;
        }

        @Override
        public Short defaultValue(Configuration config) {
            String value = (String)config.getPropertyDefault.apply(this.name, null);
            return value != null ? Short.decode(value).shortValue() : this.defaultValue.applyAsShort(config);
        }
    }

    public static final class BytePropertyDef
    extends PropertyDef<Byte> {
        private final ToByteFunction<Configuration> defaultValue;

        private BytePropertyDef(String name, byte defaultValue) {
            this(name, (Configuration c) -> defaultValue);
        }

        private BytePropertyDef(String name, ToByteFunction<Configuration> defaultValue) {
            super(Byte.class, name);
            this.defaultValue = defaultValue;
        }

        public byte getAsByte(Configuration config) {
            return (Byte)this.get(config);
        }

        @Override
        public Byte value(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? Byte.decode(value) : null;
        }

        @Override
        public Byte defaultValue(Configuration config) {
            String value = (String)config.getPropertyDefault.apply(this.name, null);
            return value != null ? Byte.decode(value).byteValue() : this.defaultValue.applyAsByte(config);
        }
    }

    public static final class BooleanPropertyDef
    extends PropertyDef<Boolean> {
        private final Predicate<Configuration> defaultValue;

        private BooleanPropertyDef(String name, boolean defaultValue) {
            this(name, (Configuration c) -> defaultValue);
        }

        private BooleanPropertyDef(String name, Predicate<Configuration> defaultValue) {
            super(Boolean.class, name);
            this.defaultValue = defaultValue;
        }

        public boolean getAsBoolean(Configuration config) {
            return (Boolean)this.get(config);
        }

        @Override
        public Boolean value(Configuration config) {
            String value = (String)config.getProperty.apply(this.name, null);
            return value != null ? Boolean.valueOf(Boolean.parseBoolean(value)) : null;
        }

        @Override
        public Boolean defaultValue(Configuration config) {
            String value = (String)config.getPropertyDefault.apply(this.name, null);
            return value != null ? Boolean.parseBoolean(value) : this.defaultValue.test(config);
        }
    }

    public static abstract class PropertyDef<T> {
        protected final Class<T> kind;
        protected final String name;

        public PropertyDef(Class<T> kind, String name) {
            this.kind = kind;
            this.name = name;
        }

        public final Class<T> kind() {
            return this.kind;
        }

        public final String name() {
            return this.name;
        }

        public final T get(Configuration config) {
            T value = this.value(config);
            if (value == null) {
                value = this.defaultValue(config);
            }
            return value;
        }

        public abstract T value(Configuration var1);

        public abstract T defaultValue(Configuration var1);
    }

    public static final class ConfigurationDef {
        private final String format;
        private final Map<String, PropertyDef<?>> properties;

        public ConfigurationDef(String prefix) {
            this.format = String.format("%s.%%s", prefix);
            this.properties = new TreeMap();
        }

        public Collection<PropertyDef<?>> properties() {
            return this.properties.values();
        }

        public BooleanPropertyDef property(String name, boolean defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            BooleanPropertyDef property = new BooleanPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public BooleanPropertyDef property(String name, Predicate<Configuration> defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            BooleanPropertyDef property = new BooleanPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public BytePropertyDef property(String name, byte defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            BytePropertyDef property = new BytePropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public BytePropertyDef property(String name, ToByteFunction<Configuration> defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            BytePropertyDef property = new BytePropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public ShortPropertyDef property(String name, short defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            ShortPropertyDef property = new ShortPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public ShortPropertyDef property(String name, ToShortFunction<Configuration> defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            ShortPropertyDef property = new ShortPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public IntPropertyDef property(String name, int defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            IntPropertyDef property = new IntPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public IntPropertyDef property(String name, ToIntFunction<Configuration> defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            IntPropertyDef property = new IntPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public LongPropertyDef property(String name, long defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            LongPropertyDef property = new LongPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public LongPropertyDef property(String name, ToLongFunction<Configuration> defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            LongPropertyDef property = new LongPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public FloatPropertyDef property(String name, float defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            FloatPropertyDef property = new FloatPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public FloatPropertyDef property(String name, ToFloatFunction<Configuration> defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            FloatPropertyDef property = new FloatPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public DoublePropertyDef property(String name, double defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            DoublePropertyDef property = new DoublePropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public DoublePropertyDef property(String name, ToDoubleFunction<Configuration> defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            DoublePropertyDef property = new DoublePropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public CharPropertyDef property(String name, char defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            CharPropertyDef property = new CharPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public CharPropertyDef property(String name, ToCharFunction<Configuration> defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            CharPropertyDef property = new CharPropertyDef(qualifiedName, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        public PropertyDef<String> property(String name) {
            return this.property(String.class, name, Function.identity(), c -> null);
        }

        public PropertyDef<String> property(String name, String defaultValue) {
            return this.property(String.class, name, Function.identity(), c -> defaultValue);
        }

        public PropertyDef<String> property(String name, Function<Configuration, String> defaultValue) {
            return this.property(String.class, name, Function.identity(), defaultValue);
        }

        public <T> PropertyDef<T> property(Class<T> kind, String name, Function<String, T> decodeValue, Function<Configuration, T> defaultValue) {
            String qualifiedName = this.qualifiedName(name);
            ObjectPropertyDef property = new ObjectPropertyDef(kind, qualifiedName, decodeValue, defaultValue);
            this.properties.put(qualifiedName, property);
            return property;
        }

        private String qualifiedName(String name) {
            String qualifiedName = String.format(this.format, name);
            if (this.properties.containsKey(qualifiedName)) {
                throw new IllegalArgumentException(String.format("duplicate property name: %s", name));
            }
            return qualifiedName;
        }
    }
}

