/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.buffer;

import java.nio.ByteBuffer;
import java.util.function.LongSupplier;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.buffer.BufferPool;

public final class CountingBufferPool
implements BufferPool {
    private final BufferPool bufferPool;
    private final LongSupplier acquires;
    private final LongSupplier releases;

    public CountingBufferPool(BufferPool bufferPool, LongSupplier acquires, LongSupplier releases) {
        this.bufferPool = bufferPool;
        this.acquires = acquires;
        this.releases = releases;
    }

    @Override
    public int slotCapacity() {
        return this.bufferPool.slotCapacity();
    }

    @Override
    public int acquire(long streamId) {
        int slot = this.bufferPool.acquire(streamId);
        if (slot != -1) {
            this.acquires.getAsLong();
        }
        return slot;
    }

    @Override
    public MutableDirectBuffer buffer(int slot) {
        return this.bufferPool.buffer(slot);
    }

    @Override
    public ByteBuffer byteBuffer(int slot) {
        return this.bufferPool.byteBuffer(slot);
    }

    @Override
    public MutableDirectBuffer buffer(int slot, int offset) {
        return this.bufferPool.buffer(slot, offset);
    }

    @Override
    public void release(int slot) {
        this.bufferPool.release(slot);
        if (slot != -1) {
            this.releases.getAsLong();
        }
    }

    @Override
    public BufferPool duplicate() {
        return new CountingBufferPool(this.bufferPool.duplicate(), this.acquires, this.releases);
    }

    @Override
    public int acquiredSlots() {
        return this.bufferPool.acquiredSlots();
    }
}

