/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.reaktivity.nukleus.Configuration;
import org.reaktivity.nukleus.Controller;
import org.reaktivity.reaktor.ReaktorBuilder;
import org.reaktivity.reaktor.ReaktorConfiguration;
import org.reaktivity.reaktor.internal.agent.ControllerAgent;
import org.reaktivity.reaktor.internal.agent.ElektronAgent;

public final class Reaktor
implements AutoCloseable {
    private final Set<Configuration> configs;
    private final ExecutorService executor;
    private final AgentRunner[] runners;
    private final ControllerAgent controllerAgent;
    private final List<ElektronAgent> elektronAgents;

    Reaktor(ReaktorConfiguration config, ErrorHandler errorHandler, Set<Configuration> configs, ExecutorService executor, Agent[] agents) {
        this.configs = configs;
        this.executor = executor;
        AgentRunner[] runners = new AgentRunner[]{};
        for (Agent agent2 : agents) {
            BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(config.maxSpins(), config.maxYields(), config.minParkNanos(), config.maxParkNanos());
            runners = ArrayUtil.add(runners, new AgentRunner(idleStrategy, errorHandler, null, agent2));
        }
        this.runners = runners;
        this.controllerAgent = Arrays.stream(agents).filter(agent -> agent instanceof ControllerAgent).map(ControllerAgent.class::cast).findFirst().orElse(null);
        this.elektronAgents = Arrays.stream(agents).filter(agent -> agent instanceof ElektronAgent).map(ElektronAgent.class::cast).collect(Collectors.toList());
    }

    public void properties(BiConsumer<String, Object> valueAction, BiConsumer<String, Object> defaultAction) {
        this.configs.forEach(c -> c.properties(valueAction, defaultAction));
    }

    public <T extends Controller> T controller(Class<T> kind) {
        return this.controllerAgent != null ? (T)this.controllerAgent.controller(kind) : null;
    }

    public Stream<Controller> controllers() {
        return this.controllerAgent != null ? this.controllerAgent.controllers() : null;
    }

    public long counter(String name) {
        return this.elektronAgents.stream().mapToLong(agent -> agent.counter(name)).sum();
    }

    public Reaktor start() {
        for (AgentRunner runner : this.runners) {
            AgentRunner.startOnThread(runner);
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (AgentRunner runner : this.runners) {
            try {
                CloseHelper.close(runner);
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        this.executor.shutdownNow();
        if (!errors.isEmpty()) {
            Throwable t = (Throwable)errors.get(0);
            errors.stream().filter(x -> x != t).forEach(x -> t.addSuppressed((Throwable)x));
            LangUtil.rethrowUnchecked(t);
        }
    }

    public static ReaktorBuilder builder() {
        return new ReaktorBuilder();
    }
}

