/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.reaktivity.nukleus.Configuration;

public class ReaktorConfiguration
extends Configuration {
    public static final Configuration.PropertyDef<String> REAKTOR_DIRECTORY;
    public static final Configuration.IntPropertyDef REAKTOR_STREAMS_BUFFER_CAPACITY;
    public static final Configuration.IntPropertyDef REAKTOR_COMMAND_BUFFER_CAPACITY;
    public static final Configuration.IntPropertyDef REAKTOR_RESPONSE_BUFFER_CAPACITY;
    public static final Configuration.IntPropertyDef REAKTOR_COUNTERS_BUFFER_CAPACITY;
    public static final Configuration.IntPropertyDef REAKTOR_BUFFER_POOL_CAPACITY;
    public static final Configuration.IntPropertyDef REAKTOR_BUFFER_SLOT_CAPACITY;
    public static final Configuration.IntPropertyDef REAKTOR_ROUTES_BUFFER_CAPACITY;
    public static final Configuration.BooleanPropertyDef REAKTOR_TIMESTAMPS;
    public static final Configuration.IntPropertyDef REAKTOR_MAXIMUM_MESSAGES_PER_READ;
    public static final Configuration.IntPropertyDef REAKTOR_TASK_PARALLELISM;
    public static final Configuration.LongPropertyDef REAKTOR_BACKOFF_MAX_SPINS;
    public static final Configuration.LongPropertyDef REAKTOR_BACKOFF_MAX_YIELDS;
    public static final Configuration.LongPropertyDef REAKTOR_BACKOFF_MIN_PARK_NANOS;
    public static final Configuration.LongPropertyDef REAKTOR_BACKOFF_MAX_PARK_NANOS;
    public static final Configuration.BooleanPropertyDef REAKTOR_DRAIN_ON_CLOSE;
    private static final Configuration.ConfigurationDef REAKTOR_CONFIG;

    public ReaktorConfiguration(Configuration config) {
        super(REAKTOR_CONFIG, config);
    }

    public ReaktorConfiguration(Properties properties) {
        super(REAKTOR_CONFIG, properties);
    }

    public ReaktorConfiguration(Configuration config, Properties defaultOverrides) {
        super(REAKTOR_CONFIG, config, defaultOverrides);
    }

    public ReaktorConfiguration() {
        super(REAKTOR_CONFIG, new Configuration());
    }

    @Override
    public final Path directory() {
        return Paths.get(REAKTOR_DIRECTORY.get(this), new String[0]);
    }

    public int bufferPoolCapacity() {
        return REAKTOR_BUFFER_POOL_CAPACITY.getAsInt(this);
    }

    public int bufferSlotCapacity() {
        return REAKTOR_BUFFER_SLOT_CAPACITY.getAsInt(this);
    }

    public int maximumStreamsCount() {
        return this.bufferPoolCapacity() / this.bufferSlotCapacity();
    }

    public int maximumMessagesPerRead() {
        return REAKTOR_MAXIMUM_MESSAGES_PER_READ.getAsInt(this);
    }

    public int taskParallelism() {
        return REAKTOR_TASK_PARALLELISM.getAsInt(this);
    }

    public int streamsBufferCapacity() {
        return REAKTOR_STREAMS_BUFFER_CAPACITY.getAsInt(this);
    }

    public int commandBufferCapacity() {
        return (Integer)REAKTOR_COMMAND_BUFFER_CAPACITY.get(this);
    }

    public int responseBufferCapacity() {
        return REAKTOR_RESPONSE_BUFFER_CAPACITY.getAsInt(this);
    }

    public int routesBufferCapacity() {
        return (Integer)REAKTOR_ROUTES_BUFFER_CAPACITY.get(this);
    }

    public int counterValuesBufferCapacity() {
        return REAKTOR_COUNTERS_BUFFER_CAPACITY.getAsInt(this);
    }

    public int counterLabelsBufferCapacity() {
        return REAKTOR_COUNTERS_BUFFER_CAPACITY.getAsInt(this) * 2;
    }

    public boolean timestamps() {
        return REAKTOR_TIMESTAMPS.getAsBoolean(this);
    }

    public long maxSpins() {
        return REAKTOR_BACKOFF_MAX_SPINS.getAsLong(this);
    }

    public long maxYields() {
        return REAKTOR_BACKOFF_MAX_YIELDS.getAsLong(this);
    }

    public long minParkNanos() {
        return REAKTOR_BACKOFF_MIN_PARK_NANOS.getAsLong(this);
    }

    public long maxParkNanos() {
        return REAKTOR_BACKOFF_MAX_PARK_NANOS.getAsLong(this);
    }

    public boolean drainOnClose() {
        return REAKTOR_DRAIN_ON_CLOSE.getAsBoolean(this);
    }

    private static int defaultBufferPoolCapacity(Configuration config) {
        return (Integer)REAKTOR_BUFFER_SLOT_CAPACITY.get(config) * 64;
    }

    static {
        Configuration.ConfigurationDef config = new Configuration.ConfigurationDef("reaktor");
        REAKTOR_DIRECTORY = config.property("directory", ".");
        REAKTOR_STREAMS_BUFFER_CAPACITY = config.property("streams.buffer.capacity", 0x100000);
        REAKTOR_COMMAND_BUFFER_CAPACITY = config.property("command.buffer.capacity", 0x100000);
        REAKTOR_RESPONSE_BUFFER_CAPACITY = config.property("response.buffer.capacity", 0x100000);
        REAKTOR_COUNTERS_BUFFER_CAPACITY = config.property("counters.buffer.capacity", 0x100000);
        REAKTOR_BUFFER_POOL_CAPACITY = config.property("buffer.pool.capacity", ReaktorConfiguration::defaultBufferPoolCapacity);
        REAKTOR_BUFFER_SLOT_CAPACITY = config.property("buffer.slot.capacity", 65536);
        REAKTOR_ROUTES_BUFFER_CAPACITY = config.property("routes.buffer.capacity", 0x100000);
        REAKTOR_TIMESTAMPS = config.property("timestamps", true);
        REAKTOR_MAXIMUM_MESSAGES_PER_READ = config.property("maximum.messages.per.read", Integer.MAX_VALUE);
        REAKTOR_TASK_PARALLELISM = config.property("task.parallelism", 1);
        REAKTOR_BACKOFF_MAX_SPINS = config.property("backoff.idle.strategy.max.spins", 64L);
        REAKTOR_BACKOFF_MAX_YIELDS = config.property("backoff.idle.strategy.max.yields", 64L);
        REAKTOR_BACKOFF_MIN_PARK_NANOS = config.property("backoff.idle.strategy.min.park.period", TimeUnit.NANOSECONDS.toNanos(64L));
        REAKTOR_BACKOFF_MAX_PARK_NANOS = config.property("backoff.idle.strategy.max.park.period", TimeUnit.MILLISECONDS.toNanos(1L));
        REAKTOR_DRAIN_ON_CLOSE = config.property("drain.on.close", false);
        REAKTOR_CONFIG = config;
    }
}

