/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.agent;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Stream;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;
import org.reaktivity.nukleus.Controller;

public class ControllerAgent
implements Agent {
    private final Map<Class<? extends Controller>, Controller> controllersByKind = new HashMap<Class<? extends Controller>, Controller>();
    private volatile Controller[] controllers = new Controller[0];

    @Override
    public String roleName() {
        return "reaktor/controller";
    }

    @Override
    public int doWork() throws Exception {
        int workDone = 0;
        for (Controller controller : this.controllers) {
            workDone += controller.process();
        }
        return workDone;
    }

    @Override
    public void onClose() {
        LinkedList<Throwable> errors = new LinkedList<Throwable>();
        for (Controller controller : this.controllers) {
            try {
                CloseHelper.close(controller);
            }
            catch (Throwable ex) {
                errors.add(ex);
            }
        }
        if (!errors.isEmpty()) {
            Throwable ex = (Throwable)errors.remove(0);
            errors.forEach(ex::addSuppressed);
            LangUtil.rethrowUnchecked(ex);
        }
    }

    public void assign(Controller controller) {
        this.controllersByKind.put(controller.kind(), controller);
        this.controllers = ArrayUtil.add(this.controllers, controller);
    }

    public <T extends Controller> T controller(Class<T> kind) {
        return (T)((Controller)kind.cast(this.controllersByKind.get(kind)));
    }

    public Stream<Controller> controllers() {
        return this.controllersByKind.values().stream();
    }

    public boolean isEmpty() {
        return this.controllersByKind.isEmpty();
    }
}

