/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.buffer;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.agrona.BitUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Hashing;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.buffer.BufferPool;

public class DefaultBufferPool
implements BufferPool {
    private final MutableDirectBuffer slotBuffer = new UnsafeBuffer(new byte[0]);
    private final int slotCapacity;
    private final int bitsPerSlot;
    private final int mask;
    private final MutableDirectBuffer slabBuffer;
    private final ByteBuffer slotByteBuffer;
    private final BitSet used;
    private final int[] availableSlots;

    public DefaultBufferPool(int totalCapacity, int slotCapacity) {
        if (!DefaultBufferPool.isZeroOrPowerOfTwo(totalCapacity)) {
            throw new IllegalArgumentException("totalCapacity is not a power of 2");
        }
        if (!DefaultBufferPool.isZeroOrPowerOfTwo(slotCapacity)) {
            throw new IllegalArgumentException("slotCapacity is not a power of 2");
        }
        if (slotCapacity > totalCapacity) {
            throw new IllegalArgumentException("slotCapacity exceeds totalCapacity");
        }
        this.slotCapacity = slotCapacity;
        this.bitsPerSlot = Integer.numberOfTrailingZeros(slotCapacity);
        int totalSlots = slotCapacity != 0 ? totalCapacity / slotCapacity : 0;
        this.mask = totalSlots - 1;
        this.slabBuffer = new UnsafeBuffer(ByteBuffer.allocate(totalCapacity));
        this.slotByteBuffer = this.slabBuffer.byteBuffer().duplicate();
        this.used = new BitSet(totalSlots);
        this.availableSlots = new int[]{totalSlots};
    }

    @Override
    public int acquiredSlots() {
        return this.used.cardinality();
    }

    @Override
    public int slotCapacity() {
        return this.slotCapacity;
    }

    @Override
    public int acquire(long streamId) {
        if (this.availableSlots[0] == 0) {
            return -1;
        }
        int slot = Hashing.hash(streamId, this.mask);
        while (this.used.get(slot)) {
            ++slot;
            slot &= this.mask;
        }
        this.used.set(slot);
        this.availableSlots[0] = this.availableSlots[0] - 1;
        return slot;
    }

    @Override
    public MutableDirectBuffer buffer(int slot) {
        assert (this.used.get(slot));
        this.slotBuffer.wrap(this.slabBuffer, slot << this.bitsPerSlot, this.slotCapacity);
        return this.slotBuffer;
    }

    @Override
    public ByteBuffer byteBuffer(int slot) {
        assert (this.used.get(slot));
        int slotOffset = slot << this.bitsPerSlot;
        this.slotByteBuffer.clear();
        this.slotByteBuffer.position(slotOffset);
        this.slotByteBuffer.limit(slotOffset + this.slotCapacity);
        return this.slotByteBuffer;
    }

    @Override
    public MutableDirectBuffer buffer(int slot, int offset) {
        assert (this.used.get(slot));
        long slotAddressOffset = this.slabBuffer.addressOffset() + (long)(slot << this.bitsPerSlot);
        this.slotBuffer.wrap(slotAddressOffset + (long)offset, this.slotCapacity);
        return this.slotBuffer;
    }

    @Override
    public void release(int slot) {
        assert (this.used.get(slot));
        this.used.clear(slot);
        this.availableSlots[0] = this.availableSlots[0] + 1;
    }

    @Override
    public BufferPool duplicate() {
        return new DefaultBufferPool(this);
    }

    private DefaultBufferPool(DefaultBufferPool that) {
        this.availableSlots = that.availableSlots;
        this.bitsPerSlot = that.bitsPerSlot;
        this.mask = that.mask;
        this.slabBuffer = that.slabBuffer;
        this.slotCapacity = that.slotCapacity;
        this.used = that.used;
        this.slotByteBuffer = that.slotByteBuffer.duplicate();
    }

    private static boolean isZeroOrPowerOfTwo(int value) {
        return value == 0 || BitUtil.isPowerOfTwo(value);
    }
}

