/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.layouts;

import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.reaktor.internal.layouts.Layout;

public final class RoutesLayout
extends Layout {
    private final AtomicBuffer routesBuffer;

    private RoutesLayout(AtomicBuffer routesBuffer) {
        this.routesBuffer = routesBuffer;
    }

    @Override
    public void close() {
        IoUtil.unmap(this.routesBuffer().byteBuffer());
    }

    public AtomicBuffer routesBuffer() {
        return this.routesBuffer;
    }

    public static final class Builder
    extends Layout.Builder<RoutesLayout> {
        private Path path;
        private int capacity;
        private boolean readonly;

        public Builder routesPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder routesBufferCapacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        @Override
        public RoutesLayout build() {
            File routes = this.path.toFile();
            if (!this.readonly) {
                CloseHelper.close(IoUtil.createEmptyFile(routes, this.capacity));
            }
            MappedByteBuffer mappedRoutes = IoUtil.mapExistingFile(routes, "routes");
            UnsafeBuffer routesBuffer = new UnsafeBuffer(mappedRoutes);
            return new RoutesLayout(routesBuffer);
        }
    }
}

