/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.router;

import java.util.function.IntUnaryOperator;
import org.agrona.collections.Long2LongHashMap;

public class GroupBudgetManager {
    private static final IntUnaryOperator NOOP_CLAIM = IntUnaryOperator.identity();
    private static final IntUnaryOperator NOOP_RELEASE = groupId -> Integer.MAX_VALUE;
    private final Long2LongHashMap budgets = new Long2LongHashMap(0L);

    public IntUnaryOperator claim(long groupId) {
        return groupId == 0L ? NOOP_CLAIM : bytes -> this.doClaim(groupId, bytes);
    }

    public IntUnaryOperator release(long groupId) {
        return groupId == 0L ? NOOP_RELEASE : bytes -> this.doRelease(groupId, bytes);
    }

    private int doClaim(long groupId, long bytes) {
        long budget = this.budgets.get(groupId);
        long claimed = Math.min(budget, bytes);
        this.budgets.computeIfPresent(groupId, (k, v) -> budget - claimed);
        return (int)claimed;
    }

    private int doRelease(long groupId, long bytes) {
        long budget = this.budgets.get(groupId);
        long newBudget = budget + bytes;
        this.budgets.computeIfPresent(groupId, (k, v) -> newBudget);
        return (int)newBudget;
    }
}

