/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.router;

import java.util.function.LongFunction;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.reaktivity.nukleus.function.MessageConsumer;
import org.reaktivity.nukleus.function.MessageFunction;
import org.reaktivity.nukleus.function.MessagePredicate;
import org.reaktivity.nukleus.route.RouteManager;
import org.reaktivity.reaktor.internal.router.RouteId;
import org.reaktivity.reaktor.internal.router.StreamId;
import org.reaktivity.reaktor.internal.types.OctetsFW;
import org.reaktivity.reaktor.internal.types.control.RouteFW;
import org.reaktivity.reaktor.internal.types.state.RouteEntryFW;
import org.reaktivity.reaktor.internal.types.state.RouteTableFW;

public final class Resolver
implements RouteManager {
    private final RouteFW routeRO = new RouteFW();
    private final RouteTableFW routeTableRO = new RouteTableFW();
    private final Int2ObjectHashMap<MessageConsumer>[] throttles;
    private final Supplier<DirectBuffer> routesBufferRef;
    private final LongFunction<MessageConsumer> supplyReceiver;

    public Resolver(Supplier<DirectBuffer> routesBufferRef, Int2ObjectHashMap<MessageConsumer>[] throttles, LongFunction<MessageConsumer> supplyReceiver) {
        this.throttles = throttles;
        this.routesBufferRef = routesBufferRef;
        this.supplyReceiver = supplyReceiver;
    }

    @Override
    public MessageConsumer supplyReceiver(long streamId) {
        return this.supplyReceiver.apply(streamId);
    }

    @Override
    public void setThrottle(long streamId, MessageConsumer throttle) {
        this.throttles[StreamId.throttleIndex(streamId)].put(StreamId.instanceId(streamId), throttle);
    }

    @Override
    public <R> R resolveExternal(long authorization, MessagePredicate filter, MessageFunction<R> mapper) {
        DirectBuffer routesBuffer = this.routesBufferRef.get();
        RouteTableFW routeTable = this.routeTableRO.wrap(routesBuffer, 0, routesBuffer.capacity());
        RouteEntryFW routeEntry = routeTable.entries().matchFirst(re -> {
            OctetsFW entry = re.route();
            RouteFW candidate = this.routeRO.wrap(entry.buffer(), entry.offset(), entry.limit());
            return (authorization & candidate.authorization()) == candidate.authorization() && filter.test(candidate.typeId(), candidate.buffer(), candidate.offset(), candidate.sizeof());
        });
        R result = null;
        if (routeEntry != null) {
            OctetsFW entry = routeEntry.route();
            RouteFW route = this.routeRO.wrap(entry.buffer(), entry.offset(), entry.limit());
            result = mapper.apply(route.typeId(), route.buffer(), route.offset(), route.sizeof());
        }
        return result;
    }

    @Override
    public <R> R resolve(long routeId, long authorization, MessagePredicate filter, MessageFunction<R> mapper) {
        DirectBuffer routesBuffer = this.routesBufferRef.get();
        RouteTableFW routeTable = this.routeTableRO.wrap(routesBuffer, 0, routesBuffer.capacity());
        RouteEntryFW routeEntry = routeTable.entries().matchFirst(re -> {
            OctetsFW entry = re.route();
            RouteFW candidate = this.routeRO.wrap(entry.buffer(), entry.offset(), entry.limit());
            return RouteId.remoteId(routeId) == RouteId.localId(candidate.correlationId()) && (authorization & candidate.authorization()) == candidate.authorization() && filter.test(candidate.typeId(), candidate.buffer(), candidate.offset(), candidate.sizeof());
        });
        R result = null;
        if (routeEntry != null) {
            OctetsFW entry = routeEntry.route();
            RouteFW route = this.routeRO.wrap(entry.buffer(), entry.offset(), entry.limit());
            result = mapper.apply(route.typeId(), route.buffer(), route.offset(), route.sizeof());
        }
        return result;
    }

    @Override
    public void forEach(MessageConsumer consumer) {
        DirectBuffer routesBuffer = this.routesBufferRef.get();
        RouteTableFW routeTable = this.routeTableRO.wrap(routesBuffer, 0, routesBuffer.capacity());
        routeTable.entries().forEach((? super T re) -> {
            OctetsFW entry = re.route();
            RouteFW route = this.routeRO.wrap(entry.buffer(), entry.offset(), entry.limit());
            consumer.accept(route.typeId(), route.buffer(), route.offset(), route.sizeof());
        });
    }
}

