/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.router;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.function.MessagePredicate;
import org.reaktivity.nukleus.route.RouteKind;
import org.reaktivity.reaktor.ReaktorConfiguration;
import org.reaktivity.reaktor.internal.LabelManager;
import org.reaktivity.reaktor.internal.layouts.RoutesLayout;
import org.reaktivity.reaktor.internal.router.RouteId;
import org.reaktivity.reaktor.internal.types.OctetsFW;
import org.reaktivity.reaktor.internal.types.control.Role;
import org.reaktivity.reaktor.internal.types.control.RouteFW;
import org.reaktivity.reaktor.internal.types.control.UnrouteFW;
import org.reaktivity.reaktor.internal.types.state.RouteTableFW;

public final class Router {
    private final RoutesLayout.Builder routesRW = new RoutesLayout.Builder();
    private final RouteFW routeRO = new RouteFW();
    private final RouteTableFW routeTableRO = new RouteTableFW();
    private final RouteFW.Builder routeRW = new RouteFW.Builder();
    private final RouteTableFW.Builder routeTableRW = new RouteTableFW.Builder();
    private final ToIntFunction<String> supplyLabelId = labels::supplyLabelId;
    private final MutableDirectBuffer routeBuf;
    private final RoutesLayout routes;
    private final Map<String, RouteKind> localAddressKinds = new HashMap<String, RouteKind>();
    private volatile DirectBuffer readonlyRoutesBuffer;
    private int conditionId;

    public Router(ReaktorConfiguration config, LabelManager labels, int maxControlCommandLength) {
        this.routeBuf = new UnsafeBuffer(ByteBuffer.allocateDirect(maxControlCommandLength));
        this.routes = this.routesRW.routesPath(config.directory().resolve("routes")).routesBufferCapacity(config.routesBufferCapacity()).readonly(false).build();
        this.readonlyRoutesBuffer = this.newCopyOfRoutesBuffer();
    }

    public DirectBuffer readonlyRoutesBuffer() {
        return this.readonlyRoutesBuffer;
    }

    public boolean doRoute(RouteFW route, MessagePredicate routeHandler) {
        RouteTableFW routeTable = this.routeTableRO.wrap(this.readonlyRoutesBuffer, 0, this.readonlyRoutesBuffer.capacity());
        boolean routed = routeHandler.test(route.typeId(), route.buffer(), route.offset(), route.sizeof());
        if (routed) {
            int modCount = routeTable.modificationCount();
            MutableDirectBuffer writeableRoutesBuffer = this.newCopyOfRoutesBuffer();
            this.routeTableRW.wrap(writeableRoutesBuffer, 0, writeableRoutesBuffer.capacity()).modificationCount(modCount).entries(es -> {
                routeTable.entries().forEach(old -> es.item(e -> e.route(old.route())));
                es.item(e -> e.route(route.buffer(), route.offset(), route.sizeof()));
            }).build();
            this.routes.routesBuffer().putBytes(0, writeableRoutesBuffer, 0, writeableRoutesBuffer.capacity());
            this.routes.routesBuffer().addIntOrdered(0, 1);
            this.readonlyRoutesBuffer = writeableRoutesBuffer;
        }
        return routed;
    }

    public boolean doUnroute(UnrouteFW unroute, MessagePredicate routeHandler) {
        RouteTableFW routeTable = this.routeTableRO.wrap(this.readonlyRoutesBuffer, 0, this.readonlyRoutesBuffer.capacity());
        int modCount = routeTable.modificationCount();
        int beforeSize = routeTable.sizeof();
        MutableDirectBuffer writeableRoutesBuffer = this.newCopyOfRoutesBuffer();
        RouteTableFW newRouteTable = this.routeTableRW.wrap(writeableRoutesBuffer, 0, writeableRoutesBuffer.capacity()).modificationCount(modCount).entries(res -> routeTable.entries().forEach(old -> {
            OctetsFW entry = old.route();
            RouteFW route = this.routeRO.wrap(entry.buffer(), entry.offset(), entry.limit());
            if (unroute.routeId() != route.correlationId() || !routeHandler.test(2, unroute.buffer(), unroute.offset(), unroute.sizeof())) {
                res.item(re -> re.route(route.buffer(), route.offset(), route.sizeof()));
            }
        })).build();
        int afterSize = newRouteTable.sizeof();
        this.readonlyRoutesBuffer = writeableRoutesBuffer;
        this.routes.routesBuffer().putBytes(0, writeableRoutesBuffer, 0, writeableRoutesBuffer.capacity());
        this.routes.routesBuffer().addIntOrdered(0, 1);
        return beforeSize > afterSize;
    }

    public RouteFW generateRouteId(RouteFW route) {
        Role role = route.role().get();
        String nukleus = route.nukleus().asString();
        String localAddress = route.localAddress().asString();
        String remoteAddress = route.remoteAddress().asString();
        long authorization = route.authorization();
        OctetsFW extension = route.extension();
        RouteKind routeKind = RouteKind.valueOf(role.ordinal());
        RouteKind existingRouteKind = this.localAddressKinds.putIfAbsent(localAddress, routeKind);
        if (existingRouteKind != null && existingRouteKind != routeKind) {
            throw new IllegalArgumentException("localAddress " + localAddress + " reused with different Role");
        }
        int localId = this.supplyLabelId.applyAsInt(localAddress);
        int remoteId = this.supplyLabelId.applyAsInt(remoteAddress);
        long newRouteId = RouteId.routeId(localId, remoteId, role, ++this.conditionId);
        return this.routeRW.wrap(this.routeBuf, 0, this.routeBuf.capacity()).correlationId(newRouteId).nukleus(nukleus).role(b -> b.set(role)).authorization(authorization).localAddress(localAddress).remoteAddress(remoteAddress).extension(b -> b.set(extension)).build();
    }

    private MutableDirectBuffer newCopyOfRoutesBuffer() {
        AtomicBuffer oldRoutesBuffer = this.routes.routesBuffer();
        UnsafeBuffer newRoutesBuffer = new UnsafeBuffer(new byte[oldRoutesBuffer.capacity()]);
        newRoutesBuffer.putBytes(0, oldRoutesBuffer, 0, oldRoutesBuffer.capacity());
        return newRoutesBuffer;
    }
}

