/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.reaktor.internal.types;

import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.reaktor.internal.types.Flyweight;

public final class String16FW
extends Flyweight {
    private static final int FIELD_SIZE_LENGTH = 2;
    private final ByteOrder byteOrder;
    private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);

    public String16FW() {
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public String16FW(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public int limit() {
        return this.offset() + 2 + Math.max(this.length0(), 0);
    }

    public DirectBuffer value() {
        return this.length0() == -1 ? null : this.valueRO;
    }

    public String asString() {
        if (this.maxLimit() == this.offset() || this.length0() == -1) {
            return null;
        }
        return this.buffer().getStringWithoutLengthUtf8(this.offset() + 2, this.length0());
    }

    @Override
    public String16FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit) || offset + 2 > this.maxLimit() || this.limit() > maxLimit) {
            return null;
        }
        int length0 = this.length0();
        if (length0 != -1) {
            this.valueRO.wrap(buffer, offset + 2, length0);
        }
        return this;
    }

    @Override
    public String16FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        String16FW.checkLimit(offset + 2, maxLimit);
        String16FW.checkLimit(this.limit(), maxLimit);
        int length0 = this.length0();
        if (length0 != -1) {
            this.valueRO.wrap(buffer, offset + 2, length0);
        }
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : String.format("\"%s\"", this.asString());
    }

    private int length0() {
        int length = this.buffer().getShort(this.offset(), this.byteOrder) & 0xFFFF;
        return length == 65535 ? -1 : length;
    }

    public static final class Builder
    extends Flyweight.Builder<String16FW> {
        private boolean valueSet;
        private final ByteOrder byteOrder;

        public Builder() {
            super(new String16FW());
            this.byteOrder = ByteOrder.nativeOrder();
        }

        public Builder(ByteOrder byteOrder) {
            super(new String16FW(byteOrder));
            this.byteOrder = byteOrder;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 2, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            this.valueSet = false;
            return this;
        }

        public Builder set(String16FW value) {
            if (value == null) {
                int newLimit = this.offset() + 2;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putShort(this.offset(), (short)-1, this.byteOrder);
                this.limit(newLimit);
            } else {
                int newLimit = this.offset() + value.sizeof();
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putShort(this.offset(), (short)value.length0(), this.byteOrder);
                this.buffer().putBytes(this.offset() + 2, value.buffer(), value.offset() + 2, value.length0());
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        public Builder set(DirectBuffer srcBuffer, int srcOffset, int length) {
            Builder.checkLength(length);
            int offset = this.offset();
            int newLimit = offset + length + 2;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(offset, (short)length, this.byteOrder);
            this.buffer().putBytes(offset + 2, srcBuffer, srcOffset, length);
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        public Builder set(String value, Charset charset) {
            if (value == null) {
                int newLimit = this.offset() + 2;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putShort(this.offset(), (short)-1, this.byteOrder);
                this.limit(newLimit);
            } else {
                byte[] charBytes = value.getBytes(charset);
                Builder.checkLength(charBytes.length);
                int newLimit = this.offset() + 2 + charBytes.length;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putShort(this.offset(), (short)charBytes.length, this.byteOrder);
                this.buffer().putBytes(this.offset() + 2, charBytes);
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        private static void checkLength(int length) {
            int maxLength = 65534;
            if (length > 65534) {
                String msg = String.format("length=%d is beyond maximum length=%d", length, 65534);
                throw new IllegalArgumentException(msg);
            }
        }

        @Override
        public String16FW build() {
            if (!this.valueSet) {
                this.set(null, StandardCharsets.UTF_8);
            }
            return (String16FW)super.build();
        }
    }
}

