// TODO: license
package org.reaktivity.command.log.internal.types.control;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.OctetsFW;
import org.reaktivity.command.log.internal.types.StringFW;

public final class RouteFW extends Flyweight {
  public static final int FIELD_OFFSET_CORRELATION_ID = 0;

  private static final int FIELD_SIZE_CORRELATION_ID = BitUtil.SIZE_OF_LONG;

  public static final int FIELD_OFFSET_NUKLEUS = FIELD_OFFSET_CORRELATION_ID + FIELD_SIZE_CORRELATION_ID;

  public static final int FIELD_OFFSET_ROLE = 0;

  public static final int FIELD_OFFSET_AUTHORIZATION = 0;

  private static final int FIELD_SIZE_AUTHORIZATION = BitUtil.SIZE_OF_LONG;

  public static final int FIELD_OFFSET_LOCAL_ADDRESS = FIELD_OFFSET_AUTHORIZATION + FIELD_SIZE_AUTHORIZATION;

  public static final int FIELD_OFFSET_REMOTE_ADDRESS = 0;

  public static final int FIELD_OFFSET_EXTENSION = 0;

  public static final int TYPE_ID = 0x00000001;

  private final StringFW nukleusRO = new StringFW();

  private final RoleFW roleRO = new RoleFW();

  private final StringFW localAddressRO = new StringFW();

  private final StringFW remoteAddressRO = new StringFW();

  private final OctetsFW extensionRO = new OctetsFW();

  public long correlationId() {
    return buffer().getLong(offset() + FIELD_OFFSET_CORRELATION_ID);
  }

  public StringFW nukleus() {
    return nukleusRO;
  }

  public RoleFW role() {
    return roleRO;
  }

  public long authorization() {
    return buffer().getLong(roleRO.limit() + FIELD_OFFSET_AUTHORIZATION);
  }

  public StringFW localAddress() {
    return localAddressRO;
  }

  public StringFW remoteAddress() {
    return remoteAddressRO;
  }

  public OctetsFW extension() {
    return extensionRO;
  }

  public int typeId() {
    return TYPE_ID;
  }

  @Override
  public RouteFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    nukleusRO.wrap(buffer, offset + FIELD_OFFSET_NUKLEUS, maxLimit);
    roleRO.wrap(buffer, nukleusRO.limit() + FIELD_OFFSET_ROLE, maxLimit);
    localAddressRO.wrap(buffer, roleRO.limit() + FIELD_OFFSET_LOCAL_ADDRESS, maxLimit);
    remoteAddressRO.wrap(buffer, localAddressRO.limit() + FIELD_OFFSET_REMOTE_ADDRESS, maxLimit);
    extensionRO.wrap(buffer, remoteAddressRO.limit() + FIELD_OFFSET_EXTENSION, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public RouteFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == nukleusRO.tryWrap(buffer, offset + FIELD_OFFSET_NUKLEUS, maxLimit)) {
      return null;
    }
    if (null == roleRO.tryWrap(buffer, nukleusRO.limit() + FIELD_OFFSET_ROLE, maxLimit)) {
      return null;
    }
    if (null == localAddressRO.tryWrap(buffer, roleRO.limit() + FIELD_OFFSET_LOCAL_ADDRESS, maxLimit)) {
      return null;
    }
    if (null == remoteAddressRO.tryWrap(buffer, localAddressRO.limit() + FIELD_OFFSET_REMOTE_ADDRESS, maxLimit)) {
      return null;
    }
    if (null == extensionRO.tryWrap(buffer, remoteAddressRO.limit() + FIELD_OFFSET_EXTENSION, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return extensionRO.limit();
  }

  @Override
  public String toString() {
    return String.format("ROUTE [correlationId=%d, nukleus=%s, role=%s, authorization=%d, localAddress=%s, remoteAddress=%s, extension=%s]", correlationId(), nukleusRO.asString(), role(), authorization(), localAddressRO.asString(), remoteAddressRO.asString(), extension());
  }

  public static final class Builder extends Flyweight.Builder<RouteFW> {
    private static final int INDEX_CORRELATION_ID = 0;

    private static final int INDEX_NUKLEUS = 1;

    private static final int INDEX_ROLE = 2;

    private static final int INDEX_AUTHORIZATION = 3;

    private static final long DEFAULT_AUTHORIZATION = 0;

    private static final int INDEX_LOCAL_ADDRESS = 4;

    private static final int INDEX_REMOTE_ADDRESS = 5;

    private static final int INDEX_EXTENSION = 6;

    private static final int FIELD_COUNT = 7;

    private final StringFW.Builder nukleusRW = new StringFW.Builder();

    private final RoleFW.Builder roleRW = new RoleFW.Builder();

    private final StringFW.Builder localAddressRW = new StringFW.Builder();

    private final StringFW.Builder remoteAddressRW = new StringFW.Builder();

    private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new RouteFW());
    }

    public Builder correlationId(long value) {
      assert lastFieldSet == INDEX_CORRELATION_ID - 1;
      int newLimit = limit() + FIELD_SIZE_CORRELATION_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_CORRELATION_ID;
      limit(newLimit);
      return this;
    }

    private StringFW.Builder nukleus() {
      assert lastFieldSet == INDEX_NUKLEUS - 1;
      return nukleusRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder nukleus(String value) {
      StringFW.Builder nukleusRW = nukleus();
      nukleusRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder nukleus(StringFW value) {
      StringFW.Builder nukleusRW = nukleus();
      nukleusRW.set(value);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder nukleus(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder nukleusRW = nukleus();
      nukleusRW.set(buffer, offset, length);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder role(Consumer<RoleFW.Builder> mutator) {
      assert lastFieldSet == INDEX_ROLE - 1;
      RoleFW.Builder roleRW = this.roleRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(roleRW);
      limit(roleRW.build().limit());
      lastFieldSet = INDEX_ROLE;
      return this;
    }

    public Builder authorization(long value) {
      if (lastFieldSet < INDEX_ROLE) {
        role(b -> { });
      }
      assert lastFieldSet == INDEX_AUTHORIZATION - 1;
      int newLimit = limit() + FIELD_SIZE_AUTHORIZATION;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_AUTHORIZATION;
      limit(newLimit);
      return this;
    }

    private StringFW.Builder localAddress() {
      if (lastFieldSet < INDEX_AUTHORIZATION) {
        authorization(DEFAULT_AUTHORIZATION);
      }
      assert lastFieldSet == INDEX_LOCAL_ADDRESS - 1;
      return localAddressRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder localAddress(String value) {
      StringFW.Builder localAddressRW = localAddress();
      localAddressRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_LOCAL_ADDRESS;
      limit(localAddressRW.build().limit());
      return this;
    }

    public Builder localAddress(StringFW value) {
      StringFW.Builder localAddressRW = localAddress();
      localAddressRW.set(value);
      lastFieldSet = INDEX_LOCAL_ADDRESS;
      limit(localAddressRW.build().limit());
      return this;
    }

    public Builder localAddress(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder localAddressRW = localAddress();
      localAddressRW.set(buffer, offset, length);
      lastFieldSet = INDEX_LOCAL_ADDRESS;
      limit(localAddressRW.build().limit());
      return this;
    }

    private StringFW.Builder remoteAddress() {
      assert lastFieldSet == INDEX_REMOTE_ADDRESS - 1;
      return remoteAddressRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder remoteAddress(String value) {
      StringFW.Builder remoteAddressRW = remoteAddress();
      remoteAddressRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_REMOTE_ADDRESS;
      limit(remoteAddressRW.build().limit());
      return this;
    }

    public Builder remoteAddress(StringFW value) {
      StringFW.Builder remoteAddressRW = remoteAddress();
      remoteAddressRW.set(value);
      lastFieldSet = INDEX_REMOTE_ADDRESS;
      limit(remoteAddressRW.build().limit());
      return this;
    }

    public Builder remoteAddress(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder remoteAddressRW = remoteAddress();
      remoteAddressRW.set(buffer, offset, length);
      lastFieldSet = INDEX_REMOTE_ADDRESS;
      limit(remoteAddressRW.build().limit());
      return this;
    }

    private OctetsFW.Builder extension() {
      assert lastFieldSet == INDEX_EXTENSION - 1;
      return extensionRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder extension(OctetsFW value) {
      OctetsFW.Builder extensionRW = extension();
      extensionRW.set(value);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    public Builder extension(Consumer<OctetsFW.Builder> mutator) {
      OctetsFW.Builder extensionRW = extension();
      mutator.accept(extensionRW);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    public Builder extension(DirectBuffer buffer, int offset, int length) {
      OctetsFW.Builder extensionRW = extension();
      extensionRW.set(buffer, offset, length);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public RouteFW build() {
      if (lastFieldSet < INDEX_EXTENSION) {
        extension(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
