// TODO: license
package org.reaktivity.command.log.internal.types.control;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.StringFW;

public final class TlsRouteExFW extends Flyweight {
  public static final int FIELD_OFFSET_STORE = 0;

  public static final int FIELD_OFFSET_HOSTNAME = 0;

  public static final int FIELD_OFFSET_PROTOCOL = 0;

  private final StringFW storeRO = new StringFW();

  private final StringFW hostnameRO = new StringFW();

  private final StringFW protocolRO = new StringFW();

  public StringFW store() {
    return storeRO;
  }

  public StringFW hostname() {
    return hostnameRO;
  }

  public StringFW protocol() {
    return protocolRO;
  }

  @Override
  public TlsRouteExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    storeRO.wrap(buffer, offset + FIELD_OFFSET_STORE, maxLimit);
    hostnameRO.wrap(buffer, storeRO.limit() + FIELD_OFFSET_HOSTNAME, maxLimit);
    protocolRO.wrap(buffer, hostnameRO.limit() + FIELD_OFFSET_PROTOCOL, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public TlsRouteExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == storeRO.tryWrap(buffer, offset + FIELD_OFFSET_STORE, maxLimit)) {
      return null;
    }
    if (null == hostnameRO.tryWrap(buffer, storeRO.limit() + FIELD_OFFSET_HOSTNAME, maxLimit)) {
      return null;
    }
    if (null == protocolRO.tryWrap(buffer, hostnameRO.limit() + FIELD_OFFSET_PROTOCOL, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return protocolRO.limit();
  }

  @Override
  public String toString() {
    return String.format("TLS_ROUTE_EX [store=%s, hostname=%s, protocol=%s]", storeRO.asString(), hostnameRO.asString(), protocolRO.asString());
  }

  public static final class Builder extends Flyweight.Builder<TlsRouteExFW> {
    private static final int INDEX_STORE = 0;

    private static final int INDEX_HOSTNAME = 1;

    private static final int INDEX_PROTOCOL = 2;

    private static final int FIELD_COUNT = 3;

    private final StringFW.Builder storeRW = new StringFW.Builder();

    private final StringFW.Builder hostnameRW = new StringFW.Builder();

    private final StringFW.Builder protocolRW = new StringFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new TlsRouteExFW());
    }

    private StringFW.Builder store() {
      assert lastFieldSet == INDEX_STORE - 1;
      return storeRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder store(String value) {
      StringFW.Builder storeRW = store();
      storeRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_STORE;
      limit(storeRW.build().limit());
      return this;
    }

    public Builder store(StringFW value) {
      StringFW.Builder storeRW = store();
      storeRW.set(value);
      lastFieldSet = INDEX_STORE;
      limit(storeRW.build().limit());
      return this;
    }

    public Builder store(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder storeRW = store();
      storeRW.set(buffer, offset, length);
      lastFieldSet = INDEX_STORE;
      limit(storeRW.build().limit());
      return this;
    }

    private StringFW.Builder hostname() {
      assert lastFieldSet == INDEX_HOSTNAME - 1;
      return hostnameRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder hostname(String value) {
      StringFW.Builder hostnameRW = hostname();
      hostnameRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_HOSTNAME;
      limit(hostnameRW.build().limit());
      return this;
    }

    public Builder hostname(StringFW value) {
      StringFW.Builder hostnameRW = hostname();
      hostnameRW.set(value);
      lastFieldSet = INDEX_HOSTNAME;
      limit(hostnameRW.build().limit());
      return this;
    }

    public Builder hostname(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder hostnameRW = hostname();
      hostnameRW.set(buffer, offset, length);
      lastFieldSet = INDEX_HOSTNAME;
      limit(hostnameRW.build().limit());
      return this;
    }

    private StringFW.Builder protocol() {
      assert lastFieldSet == INDEX_PROTOCOL - 1;
      return protocolRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder protocol(String value) {
      StringFW.Builder protocolRW = protocol();
      protocolRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_PROTOCOL;
      limit(protocolRW.build().limit());
      return this;
    }

    public Builder protocol(StringFW value) {
      StringFW.Builder protocolRW = protocol();
      protocolRW.set(value);
      lastFieldSet = INDEX_PROTOCOL;
      limit(protocolRW.build().limit());
      return this;
    }

    public Builder protocol(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder protocolRW = protocol();
      protocolRW.set(buffer, offset, length);
      lastFieldSet = INDEX_PROTOCOL;
      limit(protocolRW.build().limit());
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public TlsRouteExFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
