// TODO: license
package org.reaktivity.command.log.internal.types.control;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;

public final class UnroutedFW extends Flyweight {
  public static final int FIELD_OFFSET_CORRELATION_ID = 0;

  private static final int FIELD_SIZE_CORRELATION_ID = BitUtil.SIZE_OF_LONG;

  public static final int TYPE_ID = 0x40000002;

  public long correlationId() {
    return buffer().getLong(offset() + FIELD_OFFSET_CORRELATION_ID);
  }

  public int typeId() {
    return TYPE_ID;
  }

  @Override
  public UnroutedFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public UnroutedFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return offset() + FIELD_OFFSET_CORRELATION_ID + FIELD_SIZE_CORRELATION_ID;
  }

  @Override
  public String toString() {
    return String.format("UNROUTED [correlationId=%d]", correlationId());
  }

  public static final class Builder extends Flyweight.Builder<UnroutedFW> {
    private static final int INDEX_CORRELATION_ID = 0;

    private static final int FIELD_COUNT = 1;

    private int lastFieldSet = -1;

    public Builder() {
      super(new UnroutedFW());
    }

    public Builder correlationId(long value) {
      assert lastFieldSet == INDEX_CORRELATION_ID - 1;
      int newLimit = limit() + FIELD_SIZE_CORRELATION_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_CORRELATION_ID;
      limit(newLimit);
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public UnroutedFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
