// TODO: license
package org.reaktivity.command.log.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.ArrayFW;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.HttpHeaderFW;

public final class HttpBeginExFW extends Flyweight {
  public static final int FIELD_OFFSET_TYPE_ID = 0;

  private static final int FIELD_SIZE_TYPE_ID = BitUtil.SIZE_OF_INT;

  public static final int FIELD_OFFSET_HEADERS = FIELD_OFFSET_TYPE_ID + FIELD_SIZE_TYPE_ID;

  private final ArrayFW<HttpHeaderFW> headersRO = new ArrayFW<HttpHeaderFW>(new HttpHeaderFW());

  public int typeId() {
    return buffer().getInt(offset() + FIELD_OFFSET_TYPE_ID);
  }

  public ArrayFW<HttpHeaderFW> headers() {
    return headersRO;
  }

  @Override
  public HttpBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    headersRO.wrap(buffer, offset + FIELD_OFFSET_HEADERS, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public HttpBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == headersRO.tryWrap(buffer, offset + FIELD_OFFSET_HEADERS, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return headersRO.limit();
  }

  @Override
  public String toString() {
    return String.format("HTTP_BEGIN_EX [typeId=%d, headers=%s]", typeId(), headers());
  }

  public static final class Builder extends Flyweight.Builder<HttpBeginExFW> {
    private static final int INDEX_TYPE_ID = 0;

    private static final int INDEX_HEADERS = 1;

    private static final int FIELD_COUNT = 2;

    private final ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> headersRW = new ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());

    private int lastFieldSet = -1;

    public Builder() {
      super(new HttpBeginExFW());
    }

    public Builder typeId(int value) {
      assert lastFieldSet == INDEX_TYPE_ID - 1;
      int newLimit = limit() + FIELD_SIZE_TYPE_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), value);
      lastFieldSet = INDEX_TYPE_ID;
      limit(newLimit);
      return this;
    }

    public Builder headers(Consumer<ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
      assert lastFieldSet == INDEX_HEADERS - 1;
      ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> headersRW = this.headersRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(headersRW);
      limit(headersRW.build().limit());
      lastFieldSet = INDEX_HEADERS;
      return this;
    }

    public Builder headersItem(Consumer<HttpHeaderFW.Builder> mutator) {
      assert lastFieldSet >= INDEX_HEADERS - 1;
      if (lastFieldSet < INDEX_HEADERS) {
        headersRW.wrap(buffer(), limit(), maxLimit());
      }
      headersRW.item(mutator);
      limit(headersRW.build().limit());
      lastFieldSet = INDEX_HEADERS;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public HttpBeginExFW build() {
      if (lastFieldSet < INDEX_HEADERS) {
        headers(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
