// TODO: license
package org.reaktivity.command.log.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.ArrayFW;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.HttpHeaderFW;

public final class HttpEndExFW extends Flyweight {
  public static final int FIELD_OFFSET_TYPE_ID = 0;

  private static final int FIELD_SIZE_TYPE_ID = BitUtil.SIZE_OF_INT;

  public static final int FIELD_OFFSET_TRAILERS = FIELD_OFFSET_TYPE_ID + FIELD_SIZE_TYPE_ID;

  private final ArrayFW<HttpHeaderFW> trailersRO = new ArrayFW<HttpHeaderFW>(new HttpHeaderFW());

  public int typeId() {
    return buffer().getInt(offset() + FIELD_OFFSET_TYPE_ID);
  }

  public ArrayFW<HttpHeaderFW> trailers() {
    return trailersRO;
  }

  @Override
  public HttpEndExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    trailersRO.wrap(buffer, offset + FIELD_OFFSET_TRAILERS, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public HttpEndExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == trailersRO.tryWrap(buffer, offset + FIELD_OFFSET_TRAILERS, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return trailersRO.limit();
  }

  @Override
  public String toString() {
    return String.format("HTTP_END_EX [typeId=%d, trailers=%s]", typeId(), trailers());
  }

  public static final class Builder extends Flyweight.Builder<HttpEndExFW> {
    private static final int INDEX_TYPE_ID = 0;

    private static final int INDEX_TRAILERS = 1;

    private static final int FIELD_COUNT = 2;

    private final ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> trailersRW = new ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());

    private int lastFieldSet = -1;

    public Builder() {
      super(new HttpEndExFW());
    }

    public Builder typeId(int value) {
      assert lastFieldSet == INDEX_TYPE_ID - 1;
      int newLimit = limit() + FIELD_SIZE_TYPE_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), value);
      lastFieldSet = INDEX_TYPE_ID;
      limit(newLimit);
      return this;
    }

    public Builder trailers(Consumer<ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
      assert lastFieldSet == INDEX_TRAILERS - 1;
      ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> trailersRW = this.trailersRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(trailersRW);
      limit(trailersRW.build().limit());
      lastFieldSet = INDEX_TRAILERS;
      return this;
    }

    public Builder trailersItem(Consumer<HttpHeaderFW.Builder> mutator) {
      assert lastFieldSet >= INDEX_TRAILERS - 1;
      if (lastFieldSet < INDEX_TRAILERS) {
        trailersRW.wrap(buffer(), limit(), maxLimit());
      }
      trailersRW.item(mutator);
      limit(trailersRW.build().limit());
      lastFieldSet = INDEX_TRAILERS;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public HttpEndExFW build() {
      if (lastFieldSet < INDEX_TRAILERS) {
        trailers(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
