// TODO: license
package org.reaktivity.command.log.internal.types.stream;

import java.nio.charset.StandardCharsets;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.StringFW;

public final class TlsBeginExFW extends Flyweight {
  public static final int FIELD_OFFSET_TYPE_ID = 0;

  private static final int FIELD_SIZE_TYPE_ID = BitUtil.SIZE_OF_INT;

  public static final int FIELD_OFFSET_HOSTNAME = FIELD_OFFSET_TYPE_ID + FIELD_SIZE_TYPE_ID;

  public static final int FIELD_OFFSET_PROTOCOL = 0;

  private final StringFW hostnameRO = new StringFW();

  private final StringFW protocolRO = new StringFW();

  public int typeId() {
    return buffer().getInt(offset() + FIELD_OFFSET_TYPE_ID);
  }

  public StringFW hostname() {
    return hostnameRO;
  }

  public StringFW protocol() {
    return protocolRO;
  }

  @Override
  public TlsBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    hostnameRO.wrap(buffer, offset + FIELD_OFFSET_HOSTNAME, maxLimit);
    protocolRO.wrap(buffer, hostnameRO.limit() + FIELD_OFFSET_PROTOCOL, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public TlsBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == hostnameRO.tryWrap(buffer, offset + FIELD_OFFSET_HOSTNAME, maxLimit)) {
      return null;
    }
    if (null == protocolRO.tryWrap(buffer, hostnameRO.limit() + FIELD_OFFSET_PROTOCOL, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return protocolRO.limit();
  }

  @Override
  public String toString() {
    return String.format("TLS_BEGIN_EX [typeId=%d, hostname=%s, protocol=%s]", typeId(), hostnameRO.asString(), protocolRO.asString());
  }

  public static final class Builder extends Flyweight.Builder<TlsBeginExFW> {
    private static final int INDEX_TYPE_ID = 0;

    private static final int INDEX_HOSTNAME = 1;

    private static final int INDEX_PROTOCOL = 2;

    private static final int FIELD_COUNT = 3;

    private final StringFW.Builder hostnameRW = new StringFW.Builder();

    private final StringFW.Builder protocolRW = new StringFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new TlsBeginExFW());
    }

    public Builder typeId(int value) {
      assert lastFieldSet == INDEX_TYPE_ID - 1;
      int newLimit = limit() + FIELD_SIZE_TYPE_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), value);
      lastFieldSet = INDEX_TYPE_ID;
      limit(newLimit);
      return this;
    }

    private StringFW.Builder hostname() {
      assert lastFieldSet == INDEX_HOSTNAME - 1;
      return hostnameRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder hostname(String value) {
      StringFW.Builder hostnameRW = hostname();
      hostnameRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_HOSTNAME;
      limit(hostnameRW.build().limit());
      return this;
    }

    public Builder hostname(StringFW value) {
      StringFW.Builder hostnameRW = hostname();
      hostnameRW.set(value);
      lastFieldSet = INDEX_HOSTNAME;
      limit(hostnameRW.build().limit());
      return this;
    }

    public Builder hostname(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder hostnameRW = hostname();
      hostnameRW.set(buffer, offset, length);
      lastFieldSet = INDEX_HOSTNAME;
      limit(hostnameRW.build().limit());
      return this;
    }

    private StringFW.Builder protocol() {
      assert lastFieldSet == INDEX_PROTOCOL - 1;
      return protocolRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder protocol(String value) {
      StringFW.Builder protocolRW = protocol();
      protocolRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_PROTOCOL;
      limit(protocolRW.build().limit());
      return this;
    }

    public Builder protocol(StringFW value) {
      StringFW.Builder protocolRW = protocol();
      protocolRW.set(value);
      lastFieldSet = INDEX_PROTOCOL;
      limit(protocolRW.build().limit());
      return this;
    }

    public Builder protocol(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder protocolRW = protocol();
      protocolRW.set(buffer, offset, length);
      lastFieldSet = INDEX_PROTOCOL;
      limit(protocolRW.build().limit());
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public TlsBeginExFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
