/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.auth.jwt.internal;

import java.util.Base64;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;

public final class Functions {
    private static final String VALID_RS256_SIGNED_JWT = "eyJraWQiOiJrZXkyIiwiYWxnIjoiUlMyNTYifQ.eyJpc3MiOiJ0ZXN0IGlzc3VlciJ9.JYrWm0k-_u04FwVM_eY5NjpSYvYPi2AtQ5GY0nfOl2glXUSbMYc47t2GpOvMb59gmwSf7YaFn2LNVKdFGrIf8jElotgXhGHLAj2-Hww_AILjlj7Brwkw_tv4nvsx6oIHxHt5Md5z00SUrJPJHl5WIKk8KibQ8IHb_RU1G_pwhUHqItm-Ayt91IY-f4FBZc4yCVb9PXS7TPv9IwwJPkW14pZs9qjypejhTFc1okCm5tz9T0mPRNt_BoqBQJvTP571lRtyQ6bTcnN0aY8sreXY_jNxPXrTLgg6zooYWp1y_OW287BSVHKmAWBmtG-XoMbRaZbxEe07M29uDu0GZjZhQg";
    private static final String VALID_ES256_SIGNED_JWT = "eyJraWQiOiJrZXkxIiwiYWxnIjoiRVMyNTYifQ.eyJpc3MiOiJqd3QgdGVzdCJ9.PJ0yFl_eVoIMyLPYgDL_SUMk6fZ3RqafBbGpmW2bZMs-BHv3Sd-hWup6VWqItLnJgAUNHZJIztiwLfjl9hSWWw";
    private static final String EXPIRED_ES256_SIGNED_JWT = "eyJraWQiOiJrZXkxIiwiYWxnIjoiRVMyNTYifQ.eyJpc3MiOiJ0ZXN0IGlzc3VlciIsImV4cCI6MTQ5MzUzOTIwMH0.hWhi3Wmve1AQLQHUuN8PR9qElutw378ydEPtZWub2Qkh7Ei46mfW-zwaoloyj57cRS7G2R-GtkA6LjNKX0WSDA";
    private static final String UNREADY_ES256_SIGNED_JWT = "eyJraWQiOiJrZXkxIiwiYWxnIjoiRVMyNTYifQ.eyJpc3MiOiJ0ZXN0IGlzc3VlciIsIm5iZiI6MTgwOTA3MjAwMH0.IamaLKCC-m31Zrb513OM9funekwAqf7HVe0MW5xbFBP99MXME7r1GRao8c8XN-XvMelqwkPDVxJoUCGzBGcnSw";

    @Function
    public static String base64Encode(String value) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(value.getBytes());
    }

    @Function
    public static String append(String ... strings) {
        StringBuilder x = new StringBuilder();
        for (String s : strings) {
            x.append(s);
        }
        return x.toString();
    }

    @Function
    public static byte length8(String value) {
        int length = value.length();
        if (length > 255) {
            throw new IllegalArgumentException(String.format("Length of \"%s\" cannot be expressed as a single byte", value));
        }
        return (byte)length;
    }

    @Function
    public static String expiredSignedJwtES256() {
        return EXPIRED_ES256_SIGNED_JWT;
    }

    @Function
    public static String unreadySignedJwtES256() {
        return UNREADY_ES256_SIGNED_JWT;
    }

    @Function
    public static String validSignedJwtES256() {
        return VALID_ES256_SIGNED_JWT;
    }

    @Function
    public static String validSignedJwtRS256() {
        return VALID_RS256_SIGNED_JWT;
    }

    private Functions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(Functions.class);
        }

        public String getPrefixName() {
            return "jwt";
        }
    }
}

