/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.Controller;
import org.reaktivity.nukleus.ControllerSpi;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.OctetsFW;
import org.reaktivity.nukleus.oauth.internal.types.control.FreezeFW;
import org.reaktivity.nukleus.oauth.internal.types.control.Role;
import org.reaktivity.nukleus.oauth.internal.types.control.RouteFW;
import org.reaktivity.nukleus.oauth.internal.types.control.UnrouteFW;
import org.reaktivity.nukleus.oauth.internal.types.control.auth.ResolveFW;
import org.reaktivity.nukleus.oauth.internal.types.control.auth.UnresolveFW;
import org.reaktivity.nukleus.route.RouteKind;

public class OAuthController
implements Controller {
    private static final int MAX_SEND_LENGTH = 1024;
    private final ResolveFW.Builder resolveRW = new ResolveFW.Builder();
    private final UnresolveFW.Builder unresolveRW = new UnresolveFW.Builder();
    private final RouteFW.Builder routeRW = new RouteFW.Builder();
    private final UnrouteFW.Builder unrouteRW = new UnrouteFW.Builder();
    private final FreezeFW.Builder freezeRW = new FreezeFW.Builder();
    private final OctetsFW extensionRO = new OctetsFW().wrap((DirectBuffer)new UnsafeBuffer(new byte[0]), 0, 0);
    private final ControllerSpi controllerSpi;
    private final AtomicBuffer commandBuffer;

    public OAuthController(ControllerSpi controllerSpi) {
        this.controllerSpi = controllerSpi;
        this.commandBuffer = new UnsafeBuffer(ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder()));
    }

    public int process() {
        return this.controllerSpi.doProcess();
    }

    public void close() throws Exception {
        this.controllerSpi.doClose();
    }

    public Class<OAuthController> kind() {
        return OAuthController.class;
    }

    public String name() {
        return "oauth";
    }

    public CompletableFuture<Long> resolve(String realm, String ... roles) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        ResolveFW resolveRO = this.resolveRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).realm(realm).roles(b -> Arrays.asList(roles).forEach(s -> b.item(sb -> sb.set((String)s, StandardCharsets.UTF_8)))).build();
        return this.controllerSpi.doResolve(resolveRO.typeId(), resolveRO.buffer(), resolveRO.offset(), resolveRO.sizeof());
    }

    public CompletableFuture<Void> unresolve(long authorization) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        UnresolveFW unresolveRO = this.unresolveRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).authorization(authorization).build();
        return this.controllerSpi.doUnresolve(unresolveRO.typeId(), unresolveRO.buffer(), unresolveRO.offset(), unresolveRO.sizeof());
    }

    @Deprecated
    public CompletableFuture<Long> routeProxy(String localAddress, String remoteAddress, long authorization) {
        return this.route(RouteKind.PROXY, localAddress, remoteAddress, authorization);
    }

    public CompletableFuture<Long> route(RouteKind kind, String localAddress, String remoteAddress, long authorization) {
        return this.doRoute(kind, localAddress, remoteAddress, authorization, this.extensionRO);
    }

    public CompletableFuture<Void> unroute(long routeId) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        UnrouteFW unrouteRO = this.unrouteRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).routeId(routeId).build();
        return this.controllerSpi.doUnroute(unrouteRO.typeId(), unrouteRO.buffer(), unrouteRO.offset(), unrouteRO.sizeof());
    }

    public CompletableFuture<Void> freeze() {
        long correlationId = this.controllerSpi.nextCorrelationId();
        FreezeFW freeze = this.freezeRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).build();
        return this.controllerSpi.doFreeze(freeze.typeId(), freeze.buffer(), freeze.offset(), freeze.sizeof());
    }

    private CompletableFuture<Long> doRoute(RouteKind kind, String localAddress, String remoteAddress, long authorization, Flyweight extension) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        Role role = Role.valueOf(kind.ordinal());
        RouteFW routeRO = this.routeRW.wrap((MutableDirectBuffer)this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).role(b -> b.set(role)).authorization(authorization).localAddress(localAddress).remoteAddress(remoteAddress).extension(extension.buffer(), extension.offset(), extension.sizeof()).build();
        return this.controllerSpi.doRoute(routeRO.typeId(), routeRO.buffer(), routeRO.offset(), routeRO.sizeof());
    }
}

