/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.agrona.LangUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.JoseException;
import org.reaktivity.nukleus.internal.CopyOnWriteHashMap;

public class OAuthRealms {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String SCOPE_CLAIM = "scope";
    private static final Long NO_AUTHORIZATION = 0L;
    private static final int MAX_REALMS = 16;
    private static final long REALM_MASK = -281474976710656L;
    private final Map<String, OAuthRealm> realmsByName = new CopyOnWriteHashMap();
    private int nextRealmBit = 0;
    private final Map<String, JsonWebKey> keysByKid;

    public OAuthRealms() {
        this(Collections.emptyMap());
    }

    public OAuthRealms(Path keyFile) {
        this(OAuthRealms.parseKeyMap(keyFile));
    }

    public OAuthRealms(String keysAsJwkSet) {
        this(OAuthRealms.toKeyMap(keysAsJwkSet));
    }

    private OAuthRealms(Map<String, JsonWebKey> keysByKid) {
        this.keysByKid = keysByKid;
    }

    public long resolve(String realmName, String[] scopeNames) {
        long authorization = NO_AUTHORIZATION;
        if (this.nextRealmBit < 16) {
            OAuthRealm realm = this.realmsByName.computeIfAbsent(realmName, x$0 -> new OAuthRealm((String)x$0));
            authorization = realm.resolve(scopeNames);
        }
        return authorization;
    }

    public long resolve(String realmName) {
        return this.resolve(realmName, EMPTY_STRING_ARRAY);
    }

    public long lookup(JsonWebSignature verified) {
        OAuthRealm realm = this.realmsByName.get(verified.getKeyIdHeaderValue());
        long authorization = NO_AUTHORIZATION;
        if (realm != null) {
            try {
                JwtClaims claims = JwtClaims.parse((String)verified.getPayload());
                Object scopeClaim = claims.getClaimValue(SCOPE_CLAIM);
                String[] scopeNames = scopeClaim != null ? scopeClaim.toString().split("\\s+") : EMPTY_STRING_ARRAY;
                authorization = realm.lookup(scopeNames);
            }
            catch (InvalidJwtException | JoseException throwable) {
                // empty catch block
            }
        }
        return authorization;
    }

    public boolean unresolve(long authorization) {
        long realmId = authorization & 0xFFFF000000000000L;
        return Long.bitCount(realmId) <= 1 && this.realmsByName.entrySet().removeIf(e -> ((OAuthRealm)e.getValue()).realmId == realmId);
    }

    public JsonWebKey lookupKey(String kid) {
        return this.keysByKid.get(kid);
    }

    private static Map<String, JsonWebKey> parseKeyMap(Path keyFile) {
        Map<String, JsonWebKey> keysByKid = Collections.emptyMap();
        if (Files.exists(keyFile, new LinkOption[0])) {
            try {
                byte[] rawKeys = Files.readAllBytes(keyFile);
                String keysAsJwkSet = new String(rawKeys, StandardCharsets.UTF_8);
                keysByKid = OAuthRealms.toKeyMap(keysAsJwkSet);
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
        return keysByKid;
    }

    private static Map<String, JsonWebKey> toKeyMap(String keysAsJwkSet) {
        Map<String, JsonWebKey> keysByKid = Collections.emptyMap();
        try {
            JsonWebKeySet keys = new JsonWebKeySet(keysAsJwkSet);
            keysByKid = new LinkedHashMap<String, JsonWebKey>();
            for (JsonWebKey key : keys.getJsonWebKeys()) {
                String kid = key.getKeyId();
                if (kid == null) {
                    throw new IllegalArgumentException("Key without kid");
                }
                if (key.getAlgorithm() == null) {
                    throw new IllegalArgumentException("Key without alg");
                }
                JsonWebKey existingKey = keysByKid.putIfAbsent(kid, key);
                if (existingKey == null) continue;
                throw new IllegalArgumentException("Key with duplicate kid");
            }
            keysByKid = Collections.unmodifiableMap(keysByKid);
        }
        catch (JoseException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return keysByKid;
    }

    private final class OAuthRealm {
        private static final int MAX_SCOPES = 48;
        private final Map<String, Long> scopeBitsByName = new CopyOnWriteHashMap();
        private final long realmId;
        private final String realmName;
        private long nextScopeBit;

        private OAuthRealm(String realmName) {
            assert (OAuthRealms.this.nextRealmBit < 16);
            this.realmName = realmName;
            this.realmId = 1L << OAuthRealms.this.nextRealmBit++ << 48;
        }

        private long resolve(String[] scopeNames) {
            long authorization = NO_AUTHORIZATION;
            if (this.nextScopeBit + (long)scopeNames.length < 48L) {
                authorization = this.realmId;
                for (int i = 0; i < scopeNames.length; ++i) {
                    authorization |= this.scopeBitsByName.computeIfAbsent(scopeNames[i], this::assignScopeBit).longValue();
                }
            }
            return authorization;
        }

        private long lookup(String[] scopeNames) {
            long authorization = this.realmId;
            for (int i = 0; i < scopeNames.length; ++i) {
                authorization |= this.scopeBitsByName.getOrDefault(scopeNames[i], 0L).longValue();
            }
            return authorization;
        }

        private long assignScopeBit(String scopeName) {
            assert (this.nextScopeBit < 48L);
            return 1L << (int)this.nextScopeBit++;
        }

        public String toString() {
            return String.format("Realm name: %s\n\tRealm id: %s\n\tScope bits: %s", this.realmName, this.realmId, this.scopeBitsByName);
        }
    }
}

