/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;

public final class Varint64FW
extends Flyweight {
    private int size;

    @Override
    public int limit() {
        return this.offset() + this.size;
    }

    public long value() {
        long b;
        long value = 0L;
        int i = 0;
        int pos = this.offset();
        while (((b = (long)this.buffer().getByte(pos++)) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 65) continue;
            throw new IllegalArgumentException("varint64 value too long");
        }
        long unsigned = value | b << i;
        long result = (unsigned << 63 >> 63 ^ unsigned) >> 1;
        return result ^= unsigned & Long.MIN_VALUE;
    }

    @Override
    public Varint64FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit) || maxLimit - offset < 1) {
            return null;
        }
        this.size = this.length0();
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public Varint64FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        Varint64FW.checkLimit(offset + 1, maxLimit);
        this.size = this.length0();
        Varint64FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return Long.toString(this.value());
    }

    private int length0() {
        int mask;
        int pos;
        byte b = 0;
        int maxPos = Math.min(pos + 10, this.maxLimit());
        for (pos = this.offset(); pos < maxPos && ((long)(b = this.buffer().getByte(pos)) & 0x80L) != 0L; ++pos) {
        }
        int size = 1 + pos - this.offset();
        int n = mask = size < 10 ? 128 : 2;
        if ((b & mask) != 0 && size >= 10) {
            throw new IllegalArgumentException(String.format("(varint64 value at offset %d exceeds 64 bits", this.offset()));
        }
        return size;
    }

    public static final class Builder
    extends Flyweight.Builder<Varint64FW> {
        private boolean valueSet;

        public Builder() {
            super(new Varint64FW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 1, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            this.valueSet = false;
            return this;
        }

        public Builder set(long value) {
            long zigzagged = value << 1 ^ value >> 63;
            int pos = this.offset();
            int bits = 1 + Long.numberOfTrailingZeros(Long.highestOneBit(zigzagged));
            int size = bits / 7;
            if (size * 7 < bits) {
                ++size;
            }
            int newLimit = pos + size;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            while ((zigzagged & 0xFFFFFFFFFFFFFF80L) != 0L) {
                this.buffer().putByte(pos++, (byte)(zigzagged & 0x7FL | 0x80L));
                zigzagged >>>= 7;
            }
            this.buffer().putByte(pos, (byte)(zigzagged & 0x7FL));
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public Varint64FW build() {
            if (!this.valueSet) {
                throw new IllegalArgumentException("value not set");
            }
            return (Varint64FW)super.build();
        }
    }
}

