/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.reaktivity.nukleus.Elektron;
import org.reaktivity.nukleus.oauth.internal.OAuthConfiguration;
import org.reaktivity.nukleus.oauth.internal.stream.OAuthProxyFactoryBuilder;
import org.reaktivity.nukleus.route.RouteKind;
import org.reaktivity.nukleus.stream.StreamFactoryBuilder;

final class OAuthElektron
implements Elektron {
    private final Map<RouteKind, StreamFactoryBuilder> streamFactoryBuilders;

    OAuthElektron(OAuthConfiguration config, ToLongFunction<JsonWebSignature> lookupAuthorization, Function<String, JsonWebKey> lookupKey) {
        this.streamFactoryBuilders = Collections.singletonMap(RouteKind.PROXY, new OAuthProxyFactoryBuilder(config, lookupAuthorization, lookupKey));
    }

    public StreamFactoryBuilder streamFactoryBuilder(RouteKind kind) {
        return this.streamFactoryBuilders.get(kind);
    }

    public String toString() {
        return String.format("%s %s", this.getClass().getSimpleName(), this.streamFactoryBuilders);
    }
}

