/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.oauth.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.HttpHeaderFW;
import org.reaktivity.nukleus.oauth.internal.types.ListFW;

public final class HttpEndExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_TRAILERS = 4;
    private final ListFW<HttpHeaderFW> trailersRO = new ListFW<HttpHeaderFW>(new HttpHeaderFW());

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public ListFW<HttpHeaderFW> trailers() {
        return this.trailersRO;
    }

    @Override
    public HttpEndExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.trailersRO.wrap(buffer, offset + 4, maxLimit);
        HttpEndExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public HttpEndExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.trailersRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.trailersRO.limit();
    }

    public String toString() {
        return String.format("HTTP_END_EX [typeId=%d, trailers=%s]", this.typeId(), this.trailers());
    }

    public static final class Builder
    extends Flyweight.Builder<HttpEndExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_TRAILERS = 1;
        private static final int FIELD_COUNT = 2;
        private final ListFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> trailersRW = new ListFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());
        private int lastFieldSet = -1;

        public Builder() {
            super(new HttpEndExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            HttpEndExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder trailers(Consumer<ListFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
            assert (this.lastFieldSet == 0);
            Flyweight.Builder trailersRW = this.trailersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((ListFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>)trailersRW);
            this.limit(((ListFW)((ListFW.Builder)trailersRW).build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder trailersItem(Consumer<HttpHeaderFW.Builder> mutator) {
            assert (this.lastFieldSet >= 0);
            if (this.lastFieldSet < 1) {
                this.trailersRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.trailersRW.item(mutator);
            this.limit(((ListFW)this.trailersRW.build()).limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public HttpEndExFW build() {
            if (this.lastFieldSet < 1) {
                this.trailers(b -> {});
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (HttpEndExFW)super.build();
        }
    }
}

