/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.proxy.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressFamily;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressFamilyFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressMatchInet4FW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressMatchInet6FW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressMatchInetFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressMatchUnixFW;

public final class ProxyAddressMatchFW
extends Flyweight {
    public static final ProxyAddressFamily KIND_INET = ProxyAddressFamily.INET;
    public static final ProxyAddressFamily KIND_INET4 = ProxyAddressFamily.INET4;
    public static final ProxyAddressFamily KIND_INET6 = ProxyAddressFamily.INET6;
    public static final ProxyAddressFamily KIND_UNIX = ProxyAddressFamily.UNIX;
    private final ProxyAddressFamilyFW proxyAddressFamilyRO = new ProxyAddressFamilyFW();
    private ProxyAddressMatchInetFW inetRO;
    private ProxyAddressMatchInet4FW inet4RO;
    private ProxyAddressMatchInet6FW inet6RO;
    private ProxyAddressMatchUnixFW unixRO;

    public ProxyAddressFamily kind() {
        return this.proxyAddressFamilyRO.get();
    }

    public ProxyAddressMatchInetFW inet() {
        if (this.inetRO == null) {
            this.inetRO = new ProxyAddressMatchInetFW();
        }
        return this.inetRO;
    }

    public ProxyAddressMatchInet4FW inet4() {
        if (this.inet4RO == null) {
            this.inet4RO = new ProxyAddressMatchInet4FW();
        }
        return this.inet4RO;
    }

    public ProxyAddressMatchInet6FW inet6() {
        if (this.inet6RO == null) {
            this.inet6RO = new ProxyAddressMatchInet6FW();
        }
        return this.inet6RO;
    }

    public ProxyAddressMatchUnixFW unix() {
        if (this.unixRO == null) {
            this.unixRO = new ProxyAddressMatchUnixFW();
        }
        return this.unixRO;
    }

    @Override
    public ProxyAddressMatchFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        ProxyAddressFamilyFW proxyAddressFamily = this.proxyAddressFamilyRO.tryWrap(buffer, offset, maxLimit);
        if (proxyAddressFamily == null) {
            return null;
        }
        switch (this.kind()) {
            case INET: {
                if (this.inet().tryWrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit) != null) break;
                return null;
            }
            case INET4: {
                if (this.inet4().tryWrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit) != null) break;
                return null;
            }
            case INET6: {
                if (this.inet6().tryWrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit) != null) break;
                return null;
            }
            case UNIX: {
                if (this.unix().tryWrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public ProxyAddressMatchFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        ProxyAddressFamilyFW proxyAddressFamily = this.proxyAddressFamilyRO.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case INET: {
                this.inet().wrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit);
                break;
            }
            case INET4: {
                this.inet4().wrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit);
                break;
            }
            case INET6: {
                this.inet6().wrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit);
                break;
            }
            case UNIX: {
                this.unix().wrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit);
                break;
            }
        }
        ProxyAddressMatchFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case INET: {
                return this.inet().limit();
            }
            case INET4: {
                return this.inet4().limit();
            }
            case INET6: {
                return this.inet6().limit();
            }
            case UNIX: {
                return this.unix().limit();
            }
        }
        return this.offset();
    }

    public String toString() {
        switch (this.kind()) {
            case INET: {
                return String.format("PROXY_ADDRESS_MATCH [inet=%s]", this.inet());
            }
            case INET4: {
                return String.format("PROXY_ADDRESS_MATCH [inet4=%s]", this.inet4());
            }
            case INET6: {
                return String.format("PROXY_ADDRESS_MATCH [inet6=%s]", this.inet6());
            }
            case UNIX: {
                return String.format("PROXY_ADDRESS_MATCH [unix=%s]", this.unix());
            }
        }
        return String.format("PROXY_ADDRESS_MATCH [unknown]", new Object[0]);
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyAddressMatchFW> {
        private final ProxyAddressFamilyFW.Builder proxyAddressFamilyRW = new ProxyAddressFamilyFW.Builder();
        private ProxyAddressMatchInetFW.Builder inetRW;
        private ProxyAddressMatchInet4FW.Builder inet4RW;
        private ProxyAddressMatchInet6FW.Builder inet6RW;
        private ProxyAddressMatchUnixFW.Builder unixRW;

        public Builder() {
            super(new ProxyAddressMatchFW());
        }

        public Builder kind(ProxyAddressFamily value) {
            this.proxyAddressFamilyRW.wrap(this.buffer(), this.offset(), this.maxLimit());
            this.proxyAddressFamilyRW.set(value);
            this.limit(this.proxyAddressFamilyRW.build().limit());
            return this;
        }

        private ProxyAddressMatchInetFW.Builder inet() {
            if (this.inetRW == null) {
                this.inetRW = new ProxyAddressMatchInetFW.Builder();
            }
            return this.inetRW.wrap(this.buffer(), this.offset() + this.proxyAddressFamilyRW.sizeof(), this.maxLimit());
        }

        public Builder inet(Consumer<ProxyAddressMatchInetFW.Builder> mutator) {
            this.kind(KIND_INET);
            ProxyAddressMatchInetFW.Builder inet = this.inet();
            mutator.accept(inet);
            this.limit(inet.build().limit());
            return this;
        }

        public Builder inet(ProxyAddressMatchInetFW field) {
            this.kind(KIND_INET);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private ProxyAddressMatchInet4FW.Builder inet4() {
            if (this.inet4RW == null) {
                this.inet4RW = new ProxyAddressMatchInet4FW.Builder();
            }
            return this.inet4RW.wrap(this.buffer(), this.offset() + this.proxyAddressFamilyRW.sizeof(), this.maxLimit());
        }

        public Builder inet4(Consumer<ProxyAddressMatchInet4FW.Builder> mutator) {
            this.kind(KIND_INET4);
            ProxyAddressMatchInet4FW.Builder inet4 = this.inet4();
            mutator.accept(inet4);
            this.limit(inet4.build().limit());
            return this;
        }

        public Builder inet4(ProxyAddressMatchInet4FW field) {
            this.kind(KIND_INET4);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private ProxyAddressMatchInet6FW.Builder inet6() {
            if (this.inet6RW == null) {
                this.inet6RW = new ProxyAddressMatchInet6FW.Builder();
            }
            return this.inet6RW.wrap(this.buffer(), this.offset() + this.proxyAddressFamilyRW.sizeof(), this.maxLimit());
        }

        public Builder inet6(Consumer<ProxyAddressMatchInet6FW.Builder> mutator) {
            this.kind(KIND_INET6);
            ProxyAddressMatchInet6FW.Builder inet6 = this.inet6();
            mutator.accept(inet6);
            this.limit(inet6.build().limit());
            return this;
        }

        public Builder inet6(ProxyAddressMatchInet6FW field) {
            this.kind(KIND_INET6);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private ProxyAddressMatchUnixFW.Builder unix() {
            if (this.unixRW == null) {
                this.unixRW = new ProxyAddressMatchUnixFW.Builder();
            }
            return this.unixRW.wrap(this.buffer(), this.offset() + this.proxyAddressFamilyRW.sizeof(), this.maxLimit());
        }

        public Builder unix(Consumer<ProxyAddressMatchUnixFW.Builder> mutator) {
            this.kind(KIND_UNIX);
            ProxyAddressMatchUnixFW.Builder unix = this.unix();
            mutator.accept(unix);
            this.limit(unix.build().limit());
            return this;
        }

        public Builder unix(ProxyAddressMatchUnixFW field) {
            this.kind(KIND_UNIX);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

