/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.proxy.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressProtocolFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyAddressRangeInet6FW;
import org.reaktivity.specification.nukleus.proxy.internal.types.ProxyPortRangeFW;

public final class ProxyAddressMatchInet6FW
extends Flyweight {
    public static final int FIELD_OFFSET_PROTOCOL = 0;
    public static final int FIELD_OFFSET_SOURCE = 0;
    public static final int FIELD_OFFSET_DESTINATION = 0;
    public static final int FIELD_OFFSET_SOURCE_PORT = 0;
    public static final int FIELD_OFFSET_DESTINATION_PORT = 0;
    private final ProxyAddressProtocolFW protocolRO = new ProxyAddressProtocolFW();
    private final ProxyAddressRangeInet6FW sourceRO = new ProxyAddressRangeInet6FW();
    private final ProxyAddressRangeInet6FW destinationRO = new ProxyAddressRangeInet6FW();
    private final ProxyPortRangeFW sourcePortRO = new ProxyPortRangeFW();
    private final ProxyPortRangeFW destinationPortRO = new ProxyPortRangeFW();

    public ProxyAddressProtocolFW protocol() {
        return this.protocolRO;
    }

    public ProxyAddressRangeInet6FW source() {
        return this.sourceRO;
    }

    public ProxyAddressRangeInet6FW destination() {
        return this.destinationRO;
    }

    public ProxyPortRangeFW sourcePort() {
        return this.sourcePortRO;
    }

    public ProxyPortRangeFW destinationPort() {
        return this.destinationPortRO;
    }

    @Override
    public ProxyAddressMatchInet6FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.protocolRO.wrap(buffer, offset + 0, maxLimit);
        this.sourceRO.wrap(buffer, this.protocolRO.limit() + 0, maxLimit);
        this.destinationRO.wrap(buffer, this.sourceRO.limit() + 0, maxLimit);
        this.sourcePortRO.wrap(buffer, this.destinationRO.limit() + 0, maxLimit);
        this.destinationPortRO.wrap(buffer, this.sourcePortRO.limit() + 0, maxLimit);
        ProxyAddressMatchInet6FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyAddressMatchInet6FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.protocolRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.sourceRO.tryWrap(buffer, this.protocolRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.destinationRO.tryWrap(buffer, this.sourceRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.sourcePortRO.tryWrap(buffer, this.destinationRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.destinationPortRO.tryWrap(buffer, this.sourcePortRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.destinationPortRO.limit();
    }

    public String toString() {
        return String.format("PROXY_ADDRESS_MATCH_INET6 [protocol=%s, source=%s, destination=%s, sourcePort=%s, destinationPort=%s]", this.protocol(), this.source(), this.destination(), this.sourcePort(), this.destinationPort());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyAddressMatchInet6FW> {
        private static final int INDEX_PROTOCOL = 0;
        private static final int INDEX_SOURCE = 1;
        private static final int INDEX_DESTINATION = 2;
        private static final int INDEX_SOURCE_PORT = 3;
        private static final int INDEX_DESTINATION_PORT = 4;
        private static final int FIELD_COUNT = 5;
        private final ProxyAddressProtocolFW.Builder protocolRW = new ProxyAddressProtocolFW.Builder();
        private final ProxyAddressRangeInet6FW.Builder sourceRW = new ProxyAddressRangeInet6FW.Builder();
        private final ProxyAddressRangeInet6FW.Builder destinationRW = new ProxyAddressRangeInet6FW.Builder();
        private final ProxyPortRangeFW.Builder sourcePortRW = new ProxyPortRangeFW.Builder();
        private final ProxyPortRangeFW.Builder destinationPortRW = new ProxyPortRangeFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyAddressMatchInet6FW());
        }

        public Builder protocol(Consumer<ProxyAddressProtocolFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            ProxyAddressProtocolFW.Builder protocolRW = this.protocolRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(protocolRW);
            this.limit(protocolRW.build().limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder protocol(ProxyAddressProtocolFW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder source(Consumer<ProxyAddressRangeInet6FW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            ProxyAddressRangeInet6FW.Builder sourceRW = this.sourceRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(sourceRW);
            this.limit(sourceRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder source(ProxyAddressRangeInet6FW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder destination(Consumer<ProxyAddressRangeInet6FW.Builder> mutator) {
            if (this.lastFieldSet < 1) {
                this.source((ProxyAddressRangeInet6FW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            ProxyAddressRangeInet6FW.Builder destinationRW = this.destinationRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(destinationRW);
            this.limit(destinationRW.build().limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder destination(ProxyAddressRangeInet6FW field) {
            if (this.lastFieldSet < 1) {
                this.source((ProxyAddressRangeInet6FW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder sourcePort(Consumer<ProxyPortRangeFW.Builder> mutator) {
            if (this.lastFieldSet < 2) {
                this.destination((ProxyAddressRangeInet6FW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 2);
            ProxyPortRangeFW.Builder sourcePortRW = this.sourcePortRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(sourcePortRW);
            this.limit(sourcePortRW.build().limit());
            this.lastFieldSet = 3;
            return this;
        }

        public Builder sourcePort(ProxyPortRangeFW field) {
            if (this.lastFieldSet < 2) {
                this.destination((ProxyAddressRangeInet6FW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 3;
            return this;
        }

        public Builder destinationPort(Consumer<ProxyPortRangeFW.Builder> mutator) {
            if (this.lastFieldSet < 3) {
                this.sourcePort((ProxyPortRangeFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 3);
            ProxyPortRangeFW.Builder destinationPortRW = this.destinationPortRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(destinationPortRW);
            this.limit(destinationPortRW.build().limit());
            this.lastFieldSet = 4;
            return this;
        }

        public Builder destinationPort(ProxyPortRangeFW field) {
            if (this.lastFieldSet < 3) {
                this.sourcePort((ProxyPortRangeFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 4;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyAddressMatchInet6FW build() {
            if (this.lastFieldSet < 4) {
                this.destinationPort((ProxyPortRangeFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 4);
            this.lastFieldSet = -1;
            return (ProxyAddressMatchInet6FW)super.build();
        }
    }
}

