/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.proxy.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.proxy.internal.types.OctetsFW;

public final class ProxyAddressRangeInet6FW
extends Flyweight {
    public static final int FIELD_OFFSET_PREFIX = 0;
    public static final int FIELD_OFFSET_LENGTH = 0;
    private static final int FIELD_SIZE_LENGTH = 1;
    private final OctetsFW prefixRO = new OctetsFW();

    public OctetsFW prefix() {
        return this.prefixRO;
    }

    public int length() {
        return this.buffer().getByte(this.prefixRO.limit() + 0) & 0xFF;
    }

    @Override
    public ProxyAddressRangeInet6FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.prefixRO.wrap(buffer, offset + 0, offset + 0 + 16);
        ProxyAddressRangeInet6FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyAddressRangeInet6FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        int limit = offset + 0 + 16;
        if (limit > maxLimit || null == this.prefixRO.tryWrap(buffer, offset + 0, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.prefixRO.limit() + 0 + 1;
    }

    public String toString() {
        return String.format("PROXY_ADDRESS_RANGE_INET6 [prefix=%s, length=%d]", this.prefix(), this.length());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyAddressRangeInet6FW> {
        private static final int INDEX_PREFIX = 0;
        private static final int INDEX_LENGTH = 1;
        private static final int FIELD_COUNT = 2;
        private final OctetsFW.Builder prefixRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyAddressRangeInet6FW());
        }

        private OctetsFW.Builder prefix() {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 16;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.prefixRW.wrap(this.buffer(), this.limit(), newLimit);
        }

        public Builder prefix(OctetsFW value) {
            OctetsFW.Builder prefixRW = this.prefix();
            prefixRW.set(value);
            int expectedLimit = prefixRW.maxLimit();
            int actualLimit = ((OctetsFW)prefixRW.build()).limit();
            if (actualLimit != expectedLimit) {
                throw new IllegalStateException(String.format("%d instead of %d bytes have been set for field \"prefix\"", actualLimit - this.limit(), expectedLimit - this.limit()));
            }
            this.limit(prefixRW.maxLimit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder prefix(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder prefixRW = this.prefix();
            mutator.accept(prefixRW);
            int expectedLimit = prefixRW.maxLimit();
            int actualLimit = ((OctetsFW)prefixRW.build()).limit();
            if (actualLimit != expectedLimit) {
                throw new IllegalStateException(String.format("%d instead of %d bytes have been set for field \"prefix\"", actualLimit - this.limit(), expectedLimit - this.limit()));
            }
            this.limit(prefixRW.maxLimit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder prefix(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder prefixRW = this.prefix();
            int fieldSize = prefixRW.maxLimit() - this.limit();
            if (length != fieldSize) {
                throw new IllegalArgumentException(String.format("Invalid length %d for field \"prefix\", expected %d", length, fieldSize));
            }
            prefixRW.set(buffer, offset, length);
            this.limit(((OctetsFW)prefixRW.build()).limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder length(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"length\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"length\"", value));
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 1;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyAddressRangeInet6FW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (ProxyAddressRangeInet6FW)super.build();
        }
    }
}

