/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.proxy.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.proxy.internal.types.OctetsFW;

public final class ProxyAddressRangeUnixFW
extends Flyweight {
    public static final int FIELD_OFFSET_LENGTH = 0;
    private static final int FIELD_SIZE_LENGTH = 1;
    public static final int FIELD_OFFSET_PREFIX = 1;
    private final OctetsFW prefixRO = new OctetsFW();

    public int length() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    public OctetsFW prefix() {
        return this.prefixRO;
    }

    @Override
    public ProxyAddressRangeUnixFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.prefixRO.wrap(buffer, offset + 1, offset + 1 + this.length());
        ProxyAddressRangeUnixFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyAddressRangeUnixFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        int limit = offset + 1 + this.length();
        if (limit > maxLimit || null == this.prefixRO.tryWrap(buffer, offset + 1, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.prefixRO.limit();
    }

    public String toString() {
        return String.format("PROXY_ADDRESS_RANGE_UNIX [length=%d, prefix=%s]", this.length(), this.prefix());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyAddressRangeUnixFW> {
        public static final int DEFAULT_LENGTH = 0;
        private static final int INDEX_PREFIX = 0;
        private static final int FIELD_COUNT = 1;
        private int dynamicOffsetLength;
        private final OctetsFW.Builder prefixRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyAddressRangeUnixFW());
        }

        private Builder length(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"length\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"length\"", value));
            }
            int newLimit = this.limit() + 1;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.dynamicOffsetLength = this.limit();
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder prefix() {
            this.length(0);
            assert (this.lastFieldSet == -1);
            return this.prefixRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder prefix(OctetsFW value) {
            OctetsFW.Builder prefixRW = this.prefix();
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null for field \"prefix\" that does not default to null");
            }
            prefixRW.set(value);
            int newLimit = ((OctetsFW)prefixRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder prefix(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder prefixRW = this.prefix();
            mutator.accept(prefixRW);
            int newLimit = ((OctetsFW)prefixRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder prefix(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder prefixRW = this.prefix();
            prefixRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)prefixRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyAddressRangeUnixFW build() {
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (ProxyAddressRangeUnixFW)super.build();
        }
    }
}

