/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.proxy.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.Flyweight;

public final class ProxyPortRangeFW
extends Flyweight {
    public static final int FIELD_OFFSET_LOW = 0;
    private static final int FIELD_SIZE_LOW = 2;
    public static final int FIELD_OFFSET_HIGH = 2;
    private static final int FIELD_SIZE_HIGH = 2;

    public int low() {
        return this.buffer().getShort(this.offset() + 0) & 0xFFFF;
    }

    public int high() {
        return this.buffer().getShort(this.offset() + 2) & 0xFFFF;
    }

    @Override
    public ProxyPortRangeFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        ProxyPortRangeFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyPortRangeFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 2 + 2;
    }

    public String toString() {
        return String.format("PROXY_PORT_RANGE [low=%d, high=%d]", this.low(), this.high());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyPortRangeFW> {
        private static final int INDEX_LOW = 0;
        private static final int INDEX_HIGH = 1;
        private static final int FIELD_COUNT = 2;
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyPortRangeFW());
        }

        public Builder low(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"low\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"low\"", value));
            }
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 2;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF));
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder high(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"high\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"high\"", value));
            }
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 2;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF));
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyPortRangeFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (ProxyPortRangeFW)super.build();
        }
    }
}

