/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.nukleus.proxy.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.specification.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.specification.nukleus.proxy.internal.types.OctetsFW;

public final class SignalFW
extends Flyweight {
    public static final int FIELD_OFFSET_ROUTE_ID = 0;
    private static final int FIELD_SIZE_ROUTE_ID = 8;
    public static final int FIELD_OFFSET_STREAM_ID = 8;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_SEQUENCE = 16;
    private static final int FIELD_SIZE_SEQUENCE = 8;
    public static final int FIELD_OFFSET_ACKNOWLEDGE = 24;
    private static final int FIELD_SIZE_ACKNOWLEDGE = 8;
    public static final int FIELD_OFFSET_MAXIMUM = 32;
    private static final int FIELD_SIZE_MAXIMUM = 4;
    public static final int FIELD_OFFSET_TIMESTAMP = 36;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE_ID = 44;
    private static final int FIELD_SIZE_TRACE_ID = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 52;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int FIELD_OFFSET_CANCEL_ID = 60;
    private static final int FIELD_SIZE_CANCEL_ID = 8;
    public static final int FIELD_OFFSET_SIGNAL_ID = 68;
    private static final int FIELD_SIZE_SIGNAL_ID = 4;
    public static final int FIELD_OFFSET_EXTENSION = 72;
    public static final int TYPE_ID = 0x40000003;
    private final OctetsFW extensionRO = new OctetsFW();

    public long routeId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long streamId() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long sequence() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public long acknowledge() {
        return this.buffer().getLong(this.offset() + 24);
    }

    public int maximum() {
        return this.buffer().getInt(this.offset() + 32);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 36);
    }

    public long traceId() {
        return this.buffer().getLong(this.offset() + 44);
    }

    public long authorization() {
        return this.buffer().getLong(this.offset() + 52);
    }

    public long cancelId() {
        return this.buffer().getLong(this.offset() + 60);
    }

    public int signalId() {
        return this.buffer().getInt(this.offset() + 68);
    }

    public OctetsFW extension() {
        return this.extensionRO;
    }

    public int typeId() {
        return 0x40000003;
    }

    @Override
    public SignalFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.extensionRO.wrap(buffer, offset + 72, maxLimit);
        SignalFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public SignalFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.extensionRO.tryWrap(buffer, offset + 72, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.extensionRO.limit();
    }

    public String toString() {
        return String.format("SIGNAL [routeId=%d, streamId=%d, sequence=%d, acknowledge=%d, maximum=%d, timestamp=%d, traceId=%d, authorization=%d, cancelId=%d, signalId=%d, extension=%s]", this.routeId(), this.streamId(), this.sequence(), this.acknowledge(), this.maximum(), this.timestamp(), this.traceId(), this.authorization(), this.cancelId(), this.signalId(), this.extension());
    }

    public static final class Builder
    extends Flyweight.Builder<SignalFW> {
        private static final int INDEX_ROUTE_ID = 0;
        private static final int INDEX_STREAM_ID = 1;
        private static final int INDEX_SEQUENCE = 2;
        private static final int INDEX_ACKNOWLEDGE = 3;
        private static final int INDEX_MAXIMUM = 4;
        private static final int INDEX_TIMESTAMP = 5;
        public static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE_ID = 6;
        public static final long DEFAULT_TRACE_ID = 0L;
        private static final int INDEX_AUTHORIZATION = 7;
        public static final long DEFAULT_AUTHORIZATION = 0L;
        private static final int INDEX_CANCEL_ID = 8;
        private static final int INDEX_SIGNAL_ID = 9;
        private static final int INDEX_EXTENSION = 10;
        private static final int FIELD_COUNT = 11;
        private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new SignalFW());
        }

        public Builder routeId(long value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder streamId(long value) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 1;
            this.limit(newLimit);
            return this;
        }

        public Builder sequence(long value) {
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 2;
            this.limit(newLimit);
            return this;
        }

        public Builder acknowledge(long value) {
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder maximum(int value) {
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + 4;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 4;
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            assert (this.lastFieldSet == 4);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 5;
            this.limit(newLimit);
            return this;
        }

        public Builder traceId(long value) {
            if (this.lastFieldSet < 5) {
                this.timestamp(0L);
            }
            assert (this.lastFieldSet == 5);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 6;
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            if (this.lastFieldSet < 6) {
                this.traceId(0L);
            }
            assert (this.lastFieldSet == 6);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 7;
            this.limit(newLimit);
            return this;
        }

        public Builder cancelId(long value) {
            if (this.lastFieldSet < 7) {
                this.authorization(0L);
            }
            assert (this.lastFieldSet == 7);
            int newLimit = this.limit() + 8;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.lastFieldSet = 8;
            this.limit(newLimit);
            return this;
        }

        public Builder signalId(int value) {
            assert (this.lastFieldSet == 8);
            int newLimit = this.limit() + 4;
            SignalFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 9;
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder extension() {
            assert (this.lastFieldSet == 9);
            return this.extensionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder extension(OctetsFW value) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(value);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 10;
            return this;
        }

        public Builder extension(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder extensionRW = this.extension();
            mutator.accept(extensionRW);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 10;
            return this;
        }

        public Builder extension(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(buffer, offset, length);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.lastFieldSet = 10;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public SignalFW build() {
            if (this.lastFieldSet < 10) {
                this.extension((OctetsFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 10);
            this.lastFieldSet = -1;
            return (SignalFW)super.build();
        }
    }
}

