/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CompletableFuture;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.Controller;
import org.reaktivity.nukleus.ControllerSpi;
import org.reaktivity.nukleus.proxy.internal.route.ProxyExtension;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.OctetsFW;
import org.reaktivity.nukleus.proxy.internal.types.control.FreezeFW;
import org.reaktivity.nukleus.proxy.internal.types.control.ProxyRouteExFW;
import org.reaktivity.nukleus.proxy.internal.types.control.Role;
import org.reaktivity.nukleus.proxy.internal.types.control.RouteFW;
import org.reaktivity.nukleus.proxy.internal.types.control.UnrouteFW;
import org.reaktivity.nukleus.route.RouteKind;

public final class ProxyController
implements Controller {
    private static final OctetsFW EMPTY_OCTETS = new OctetsFW().wrap((DirectBuffer)new UnsafeBuffer(0L, 0), 0, 0);
    private static final int MAX_SEND_LENGTH = 1024;
    private final RouteFW.Builder routeRW = new RouteFW.Builder();
    private final UnrouteFW.Builder unrouteRW = new UnrouteFW.Builder();
    private final FreezeFW.Builder freezeRW = new FreezeFW.Builder();
    private final ProxyRouteExFW.Builder routeExRW = new ProxyRouteExFW.Builder();
    private final ControllerSpi controllerSpi;
    private final MutableDirectBuffer commandBuffer;
    private final MutableDirectBuffer extensionBuffer;

    public ProxyController(ControllerSpi controllerSpi) {
        this.controllerSpi = controllerSpi;
        this.commandBuffer = new UnsafeBuffer(ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder()));
        this.extensionBuffer = new UnsafeBuffer(ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder()));
    }

    public int process() {
        return this.controllerSpi.doProcess();
    }

    public void close() throws Exception {
        this.controllerSpi.doClose();
    }

    public Class<ProxyController> kind() {
        return ProxyController.class;
    }

    public String name() {
        return "proxy";
    }

    public CompletableFuture<Long> route(RouteKind kind, String localAddress, String remoteAddress) {
        return this.route(kind, localAddress, remoteAddress, null);
    }

    public CompletableFuture<Long> route(RouteKind kind, String localAddress, String remoteAddress, String extension) {
        Flyweight routeEx = EMPTY_OCTETS;
        if (extension != null) {
            try (Jsonb jsonb = JsonbBuilder.create();){
                ProxyExtension proxyEx = (ProxyExtension)jsonb.fromJson(extension, ProxyExtension.class);
                routeEx = this.routeExRW.wrap(this.extensionBuffer, 0, this.extensionBuffer.capacity()).address(proxyEx::buildAddress).infos(proxyEx::buildInfos).build();
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
        return this.doRoute(kind, localAddress, remoteAddress, routeEx);
    }

    public CompletableFuture<Void> unroute(long routeId) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        UnrouteFW unroute = this.unrouteRW.wrap(this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).routeId(routeId).build();
        return this.controllerSpi.doUnroute(unroute.typeId(), unroute.buffer(), unroute.offset(), unroute.sizeof());
    }

    public CompletableFuture<Void> freeze() {
        long correlationId = this.controllerSpi.nextCorrelationId();
        FreezeFW freeze = this.freezeRW.wrap(this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).build();
        return this.controllerSpi.doFreeze(freeze.typeId(), freeze.buffer(), freeze.offset(), freeze.sizeof());
    }

    private CompletableFuture<Long> doRoute(RouteKind kind, String localAddress, String remoteAddress, Flyweight extension) {
        long correlationId = this.controllerSpi.nextCorrelationId();
        Role role = Role.valueOf(kind.ordinal());
        RouteFW route = this.routeRW.wrap(this.commandBuffer, 0, this.commandBuffer.capacity()).correlationId(correlationId).nukleus(this.name()).role(b -> b.set(role)).localAddress(localAddress).remoteAddress(remoteAddress).extension(extension.buffer(), extension.offset(), extension.sizeof()).build();
        return this.controllerSpi.doRoute(route.typeId(), route.buffer(), route.offset(), route.sizeof());
    }
}

