/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.route;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.bind.annotation.JsonbProperty;
import org.agrona.LangUtil;
import org.agrona.Strings;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressFamily;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressMatchFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressProtocol;

public class ProxyAddress {
    private static final Pattern ADDRESS_RANGE_PATTERN = Pattern.compile("(?<prefix>[^/]+)(?:/(?<length>\\d+))?");
    private static final Pattern PORT_RANGE_PATTERN = Pattern.compile("(?<low>[\\d]+)(?:-(?<high>\\d+))?");
    @JsonbProperty
    public ProxyAddressFamily family;
    @JsonbProperty
    public ProxyAddressProtocol protocol;
    @JsonbProperty
    public String source;
    @JsonbProperty
    public String destination;
    @JsonbProperty
    public String sourcePort;
    @JsonbProperty
    public String destinationPort;

    void build(ProxyAddressMatchFW.Builder builder) {
        switch (this.family) {
            case INET: {
                builder.inet(i -> i.protocol(p -> p.set(this.protocol)).source(s -> s.pattern(this.source)).destination(d -> d.pattern(this.destination)).sourcePort(s -> ProxyAddress.buildPortRange(this.sourcePort, (l, h) -> s.low((int)l).high((int)h))).destinationPort(d -> ProxyAddress.buildPortRange(this.destinationPort, (l, h) -> d.low((int)l).high((int)h))));
                break;
            }
            case INET4: {
                builder.inet4(i -> i.protocol(p -> p.set(this.protocol)).source(s -> ProxyAddress.buildAddressRange(this.source, (ip, l) -> s.prefix(p -> p.set((byte[])ip)).length((int)l))).destination(d -> ProxyAddress.buildAddressRange(this.destination, (ip, l) -> d.prefix(p -> p.set((byte[])ip)).length((int)l))).sourcePort(s -> ProxyAddress.buildPortRange(this.sourcePort, (l, h) -> s.low((int)l).high((int)h))).destinationPort(d -> ProxyAddress.buildPortRange(this.destinationPort, (l, h) -> d.low((int)l).high((int)h))));
                break;
            }
            case INET6: {
                builder.inet6(i -> i.protocol(p -> p.set(this.protocol)).source(s -> ProxyAddress.buildAddressRange(this.source, (ip, l) -> s.prefix(p -> p.set((byte[])ip)).length((int)l))).destination(d -> ProxyAddress.buildAddressRange(this.destination, (ip, l) -> d.prefix(p -> p.set((byte[])ip)).length((int)l))).sourcePort(s -> ProxyAddress.buildPortRange(this.sourcePort, (l, h) -> s.low((int)l).high((int)h))).destinationPort(d -> ProxyAddress.buildPortRange(this.destinationPort, (l, h) -> d.low((int)l).high((int)h))));
                break;
            }
            case UNIX: {
                builder.unix(i -> i.protocol(p -> p.set(this.protocol)).source(s -> s.prefix(p -> p.set(this.source.getBytes(StandardCharsets.UTF_8)))).destination(d -> d.prefix(p -> p.set(this.destination.getBytes(StandardCharsets.UTF_8)))));
                break;
            }
        }
    }

    private static void buildAddressRange(String address, BiConsumer<byte[], Integer> setter) {
        Matcher matcher = ADDRESS_RANGE_PATTERN.matcher(address);
        assert (matcher.matches());
        String prefix = matcher.group("prefix");
        int length = Strings.parseIntOrDefault((String)matcher.group("length"), (int)prefix.length());
        InetAddress inet = ProxyAddress.getInetAddressByName(prefix);
        byte[] ip = inet.getAddress();
        setter.accept(ip, length);
    }

    private static void buildPortRange(String port, BiConsumer<Integer, Integer> setter) {
        Matcher matcher = PORT_RANGE_PATTERN.matcher(port);
        assert (matcher.matches());
        int low = Integer.parseInt(matcher.group("low"));
        int high = Strings.parseIntOrDefault((String)matcher.group("high"), (int)low);
        setter.accept(low, high);
    }

    private static InetAddress getInetAddressByName(String host) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return address;
    }
}

