/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.stream;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import java.util.function.ToIntFunction;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.buffer.BufferPool;
import org.reaktivity.nukleus.function.MessageConsumer;
import org.reaktivity.nukleus.proxy.internal.ProxyConfiguration;
import org.reaktivity.nukleus.proxy.internal.stream.ProxyRouter;
import org.reaktivity.nukleus.proxy.internal.types.Array32FW;
import org.reaktivity.nukleus.proxy.internal.types.OctetsFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressFamily;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressInet4FW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressInet6FW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressInetFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressUnixFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyInfoFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyInfoType;
import org.reaktivity.nukleus.proxy.internal.types.ProxySecureInfoFW;
import org.reaktivity.nukleus.proxy.internal.types.codec.ProxyTlvFW;
import org.reaktivity.nukleus.proxy.internal.types.control.RouteFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.AbortFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.BeginFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.ChallengeFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.DataFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.EndFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.FlushFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.ProxyBeginExFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.ResetFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.WindowFW;
import org.reaktivity.nukleus.route.RouteManager;
import org.reaktivity.nukleus.stream.StreamFactory;

public final class ProxyClientFactory
implements StreamFactory {
    private static final InetAddress INET4_ANY_LOCAL_ADDRESS = ProxyClientFactory.getInetAddressByAddress(new byte[4]);
    private static final InetAddress INET6_ANY_LOCAL_ADDRESS = ProxyClientFactory.getInetAddressByAddress(new byte[16]);
    private static final DirectBuffer HEADER_V2 = new UnsafeBuffer("\r\n\r\n\u0000\r\nQUIT\n".getBytes(StandardCharsets.US_ASCII));
    private final BeginFW beginRO = new BeginFW();
    private final DataFW dataRO = new DataFW();
    private final EndFW endRO = new EndFW();
    private final AbortFW abortRO = new AbortFW();
    private final FlushFW flushRO = new FlushFW();
    private final ChallengeFW challengeRO = new ChallengeFW();
    private final BeginFW.Builder beginRW = new BeginFW.Builder();
    private final DataFW.Builder dataRW = new DataFW.Builder();
    private final EndFW.Builder endRW = new EndFW.Builder();
    private final AbortFW.Builder abortRW = new AbortFW.Builder();
    private final FlushFW.Builder flushRW = new FlushFW.Builder();
    private final ChallengeFW.Builder challengeRW = new ChallengeFW.Builder();
    private final WindowFW windowRO = new WindowFW();
    private final ResetFW resetRO = new ResetFW();
    private final ProxyBeginExFW beginExRO = new ProxyBeginExFW();
    private final WindowFW.Builder windowRW = new WindowFW.Builder();
    private final ResetFW.Builder resetRW = new ResetFW.Builder();
    private final OctetsFW payloadRO = new OctetsFW();
    private final ProxyInfoFW infoRO = new ProxyInfoFW();
    private final ProxyTlvFW.Builder tlvRW = new ProxyTlvFW.Builder();
    private final ProxyRouter router;
    private final MutableDirectBuffer writeBuffer;
    private final BufferPool encodePool;
    private final LongUnaryOperator supplyInitialId;
    private final LongUnaryOperator supplyReplyId;
    private final Function<String, InetAddress[]> resolveHost;
    private final Long2ObjectHashMap<MessageConsumer> correlations;

    public ProxyClientFactory(ProxyConfiguration config, RouteManager router, MutableDirectBuffer writeBuffer, BufferPool bufferPool, LongUnaryOperator supplyInitialId, LongUnaryOperator supplyReplyId, ToIntFunction<String> supplyTypeId, Function<String, InetAddress[]> resolveHost) {
        this.router = new ProxyRouter(router, supplyTypeId.applyAsInt("proxy"));
        this.writeBuffer = Objects.requireNonNull(writeBuffer);
        this.encodePool = Objects.requireNonNull(bufferPool);
        this.supplyInitialId = Objects.requireNonNull(supplyInitialId);
        this.supplyReplyId = Objects.requireNonNull(supplyReplyId);
        this.resolveHost = Objects.requireNonNull(resolveHost);
        this.correlations = new Long2ObjectHashMap();
    }

    public MessageConsumer newStream(int msgTypeId, DirectBuffer buffer, int index, int length, MessageConsumer sender) {
        BeginFW begin = this.beginRO.wrap(buffer, index, index + length);
        long streamId = begin.streamId();
        MessageConsumer newStream = null;
        if ((streamId & 1L) != 0L) {
            RouteFW route = this.router.resolveApp(begin);
            if (route != null) {
                long routeId = begin.routeId();
                long initialId = begin.streamId();
                long resolvedId = route.correlationId();
                newStream = (arg_0, arg_1, arg_2, arg_3) -> ProxyClientFactory.lambda$newStream$0(new ProxyAppClient(routeId, initialId, sender, resolvedId), arg_0, arg_1, arg_2, arg_3);
            }
        } else {
            long replyId = begin.streamId();
            newStream = (MessageConsumer)this.correlations.remove(replyId);
        }
        return newStream;
    }

    private void doBegin(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization, long affinity) {
        BeginFW begin = this.beginRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).affinity(affinity).build();
        receiver.accept(begin.typeId(), begin.buffer(), begin.offset(), begin.sizeof());
    }

    void doData(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization, int flags, long budgetId, int reserved, OctetsFW payload) {
        DataFW data = this.dataRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).flags(flags).budgetId(budgetId).reserved(reserved).payload(payload).build();
        receiver.accept(data.typeId(), data.buffer(), data.offset(), data.sizeof());
    }

    private void doReset(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization) {
        ResetFW reset = this.resetRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).build();
        receiver.accept(reset.typeId(), reset.buffer(), reset.offset(), reset.sizeof());
    }

    void doWindow(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization, long budgetId, int padding, int minimum, int capabilities) {
        WindowFW window = this.windowRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).budgetId(budgetId).padding(padding).minimum(minimum).capabilities(capabilities).build();
        receiver.accept(window.typeId(), window.buffer(), window.offset(), window.sizeof());
    }

    private void doChallenge(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization, OctetsFW extension) {
        ChallengeFW challenge = this.challengeRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).extension(extension).build();
        receiver.accept(challenge.typeId(), challenge.buffer(), challenge.offset(), challenge.sizeof());
    }

    void doEnd(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization) {
        EndFW end = this.endRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).build();
        receiver.accept(end.typeId(), end.buffer(), end.offset(), end.sizeof());
    }

    void doAbort(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization) {
        AbortFW abort = this.abortRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).build();
        receiver.accept(abort.typeId(), abort.buffer(), abort.offset(), abort.sizeof());
    }

    private void doFlush(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization, long budgetId, int reserved) {
        FlushFW flush = this.flushRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).budgetId(budgetId).reserved(reserved).build();
        receiver.accept(flush.typeId(), flush.buffer(), flush.offset(), flush.sizeof());
    }

    private static ProxyAddressFamily asProxyAddressFamily(InetAddress address) {
        if (address instanceof Inet4Address) {
            return ProxyAddressFamily.INET4;
        }
        if (address instanceof Inet6Address) {
            return ProxyAddressFamily.INET6;
        }
        return ProxyAddressFamily.INET;
    }

    private static InetAddress getInetAddressByAddress(byte[] addr) {
        InetAddress address = null;
        try {
            address = InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return address;
    }

    private static InetAddress getInetAddressLocal(ProxyAddressFamily family) {
        InetAddress address = null;
        switch (family) {
            case INET4: {
                address = INET4_ANY_LOCAL_ADDRESS;
                break;
            }
            case INET6: {
                address = INET6_ANY_LOCAL_ADDRESS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected family: " + family);
            }
        }
        return address;
    }

    private static /* synthetic */ void lambda$newStream$0(ProxyAppClient rec$, int x$0, DirectBuffer x$1, int x$2, int x$3) {
        rec$.onAppMessage(x$0, x$1, x$2, x$3);
    }

    private final class ProxyAppClient {
        private final MessageConsumer receiver;
        private final long routeId;
        private final long initialId;
        private final long replyId;
        private final ProxyNetClient net;
        private long initialSeq;
        private long initialAck;
        private int initialMax;
        private long replySeq;
        private long replyAck;
        private int replyMax;
        private int replyPad;

        private ProxyAppClient(long routeId, long initialId, MessageConsumer receiver, long resolvedId) {
            this.routeId = routeId;
            this.initialId = initialId;
            this.receiver = receiver;
            this.replyId = ProxyClientFactory.this.supplyReplyId.applyAsLong(initialId);
            this.net = new ProxyNetClient(this, resolvedId);
        }

        private void onAppMessage(int msgTypeId, DirectBuffer buffer, int index, int length) {
            switch (msgTypeId) {
                case 1: {
                    BeginFW begin = ProxyClientFactory.this.beginRO.wrap(buffer, index, index + length);
                    this.onAppBegin(begin);
                    break;
                }
                case 2: {
                    DataFW data = ProxyClientFactory.this.dataRO.wrap(buffer, index, index + length);
                    this.onAppData(data);
                    break;
                }
                case 3: {
                    EndFW end = ProxyClientFactory.this.endRO.wrap(buffer, index, index + length);
                    this.onAppEnd(end);
                    break;
                }
                case 4: {
                    AbortFW abort = ProxyClientFactory.this.abortRO.wrap(buffer, index, index + length);
                    this.onAppAbort(abort);
                    break;
                }
                case 5: {
                    FlushFW flush = ProxyClientFactory.this.flushRO.wrap(buffer, index, index + length);
                    this.onAppFlush(flush);
                    break;
                }
                case 0x40000002: {
                    WindowFW window = ProxyClientFactory.this.windowRO.wrap(buffer, index, index + length);
                    this.onAppWindow(window);
                    break;
                }
                case 0x40000001: {
                    ResetFW reset = ProxyClientFactory.this.resetRO.wrap(buffer, index, index + length);
                    this.onAppReset(reset);
                    break;
                }
                case 0x40000004: {
                    ChallengeFW challenge = ProxyClientFactory.this.challengeRO.wrap(buffer, index, index + length);
                    this.onAppChallenge(challenge);
                    break;
                }
            }
        }

        private void onAppBegin(BeginFW begin) {
            long traceId = begin.traceId();
            long authorization = begin.authorization();
            long affinity = begin.affinity();
            OctetsFW extension = begin.extension();
            ProxyBeginExFW beginEx = extension.get(ProxyClientFactory.this.beginExRO::tryWrap);
            ProxyClientFactory.this.router.setThrottle(this.replyId, this::onAppMessage);
            this.net.doNetBegin(traceId, authorization, affinity, beginEx);
        }

        private void onAppData(DataFW data) {
            long sequence = data.sequence();
            long acknowledge = data.acknowledge();
            long traceId = data.traceId();
            long authorization = data.authorization();
            long budgetId = data.budgetId();
            int flags = data.flags();
            int reserved = data.reserved();
            OctetsFW payload = data.payload();
            assert (acknowledge <= sequence);
            assert (sequence >= this.initialSeq);
            this.initialSeq = sequence + (long)data.reserved();
            assert (this.initialAck <= this.initialSeq);
            if (this.initialSeq > this.initialAck + (long)this.initialMax) {
                this.doAppReset(traceId, authorization);
                this.net.doNetAbort(traceId, authorization);
            } else {
                this.net.doNetData(traceId, authorization, budgetId, flags, reserved, payload);
            }
        }

        private void onAppEnd(EndFW end) {
            long traceId = end.traceId();
            long authorization = end.authorization();
            this.net.doNetEnd(traceId, authorization);
        }

        private void onAppAbort(AbortFW abort) {
            long traceId = abort.traceId();
            long authorization = abort.authorization();
            this.net.doNetAbort(traceId, authorization);
        }

        private void onAppFlush(FlushFW flush) {
            long traceId = flush.traceId();
            long authorization = flush.authorization();
            long budgetId = flush.budgetId();
            int reserved = flush.reserved();
            this.net.doNetFlush(traceId, authorization, budgetId, reserved);
        }

        private void onAppWindow(WindowFW window) {
            long sequence = window.sequence();
            long acknowledge = window.acknowledge();
            int maximum = window.maximum();
            long traceId = window.traceId();
            long authorization = window.authorization();
            long budgetId = window.budgetId();
            int padding = window.padding();
            int minimum = window.minimum();
            int capabilities = window.capabilities();
            assert (acknowledge <= sequence);
            assert (sequence <= this.replySeq);
            assert (acknowledge >= this.replyAck);
            assert (maximum >= this.replyMax);
            this.replyAck = acknowledge;
            this.replyMax = maximum;
            this.replyPad = padding;
            assert (this.replyAck <= this.replySeq);
            int replyWin = this.replyMax - (int)(this.replySeq - this.replyAck);
            if (replyWin > 0) {
                this.net.doNetWindow(traceId, authorization, budgetId, minimum, capabilities, replyWin, this.replyPad, this.replyMax);
            }
        }

        private void onAppReset(ResetFW reset) {
            long traceId = reset.traceId();
            long authorization = reset.authorization();
            this.net.doNetReset(traceId, authorization);
        }

        private void onAppChallenge(ChallengeFW challenge) {
            long traceId = challenge.traceId();
            long authorization = challenge.authorization();
            OctetsFW extension = challenge.extension();
            this.net.doNetChallenge(traceId, authorization, extension);
        }

        private void doAppBegin(long traceId, long authorization, long affinity) {
            ProxyClientFactory.this.doBegin(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization, affinity);
        }

        private void doAppData(long traceId, long authorization, int flags, long budgetId, int reserved, OctetsFW payload) {
            ProxyClientFactory.this.doData(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization, flags, budgetId, reserved, payload);
            this.replySeq += (long)reserved;
            assert (this.replyAck <= this.replySeq);
        }

        private void doAppEnd(long traceId, long authorization) {
            ProxyClientFactory.this.doEnd(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization);
        }

        private void doAppAbort(long traceId, long authorization) {
            ProxyClientFactory.this.doAbort(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization);
        }

        private void doAppFlush(long traceId, long authorization, long budgetId, int reserved) {
            ProxyClientFactory.this.doFlush(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization, budgetId, reserved);
        }

        private void doAppReset(long traceId, long authorization) {
            ProxyClientFactory.this.doReset(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization);
        }

        private void doAppWindow(long traceId, long authorization, long budgetId, int minimum, int capabilities, int minInitialWin, int minInitialPad, int minInitialMax) {
            long newInitialAck = Math.max(this.initialSeq - (long)minInitialWin, this.initialAck);
            if (newInitialAck > this.initialAck || minInitialMax > this.initialMax) {
                this.initialAck = newInitialAck;
                assert (this.initialAck <= this.initialSeq);
                this.initialMax = minInitialMax;
                ProxyClientFactory.this.doWindow(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization, budgetId, minInitialPad, minimum, capabilities);
            }
        }

        private void doAppChallenge(long traceId, long authorization, OctetsFW extension) {
            ProxyClientFactory.this.doChallenge(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization, extension);
        }
    }

    private final class ProxyNetClient {
        private final ProxyAppClient app;
        private final long routeId;
        private final long initialId;
        private final long replyId;
        private final MessageConsumer receiver;
        private int encodeSlot = -1;
        private int encodeSlotOffset;
        private long initialSeq;
        private long initialAck;
        private int initialMax;
        private int initialPad;
        private long replySeq;
        private long replyAck;
        private int replyMax;

        private ProxyNetClient(ProxyAppClient application, long routeId) {
            this.app = application;
            this.routeId = routeId;
            this.initialId = ProxyClientFactory.this.supplyInitialId.applyAsLong(routeId);
            this.replyId = ProxyClientFactory.this.supplyReplyId.applyAsLong(this.initialId);
            this.receiver = ProxyClientFactory.this.router.supplyReceiver(this.initialId);
        }

        private void onNetMessage(int msgTypeId, DirectBuffer buffer, int index, int length) {
            switch (msgTypeId) {
                case 1: {
                    BeginFW begin = ProxyClientFactory.this.beginRO.wrap(buffer, index, index + length);
                    this.onNetBegin(begin);
                    break;
                }
                case 2: {
                    DataFW data = ProxyClientFactory.this.dataRO.wrap(buffer, index, index + length);
                    this.onNetData(data);
                    break;
                }
                case 3: {
                    EndFW end = ProxyClientFactory.this.endRO.wrap(buffer, index, index + length);
                    this.onNetEnd(end);
                    break;
                }
                case 4: {
                    AbortFW abort = ProxyClientFactory.this.abortRO.wrap(buffer, index, index + length);
                    this.onNetAbort(abort);
                    break;
                }
                case 5: {
                    FlushFW flush = ProxyClientFactory.this.flushRO.wrap(buffer, index, index + length);
                    this.onNetFlush(flush);
                    break;
                }
                case 0x40000002: {
                    WindowFW window = ProxyClientFactory.this.windowRO.wrap(buffer, index, index + length);
                    this.onNetWindow(window);
                    break;
                }
                case 0x40000001: {
                    ResetFW reset = ProxyClientFactory.this.resetRO.wrap(buffer, index, index + length);
                    this.onNetReset(reset);
                    break;
                }
                case 0x40000004: {
                    ChallengeFW challenge = ProxyClientFactory.this.challengeRO.wrap(buffer, index, index + length);
                    this.onNetChallenge(challenge);
                    break;
                }
            }
        }

        private void onNetBegin(BeginFW begin) {
            long traceId = begin.traceId();
            long authorization = begin.authorization();
            long affinity = begin.affinity();
            this.app.doAppBegin(traceId, authorization, affinity);
        }

        private void onNetData(DataFW data) {
            long sequence = data.sequence();
            long acknowledge = data.acknowledge();
            long authorization = data.authorization();
            long traceId = data.traceId();
            int flags = data.flags();
            long budgetId = data.budgetId();
            int reserved = data.reserved();
            OctetsFW payload = data.payload();
            assert (acknowledge <= sequence);
            assert (sequence >= this.replySeq);
            this.replySeq = sequence + (long)data.reserved();
            assert (this.replyAck <= this.replySeq);
            if (this.replySeq > this.replyAck + (long)this.replyMax) {
                this.doNetReset(traceId, authorization);
                this.app.doAppAbort(traceId, authorization);
            } else {
                this.app.doAppData(traceId, authorization, flags, budgetId, reserved, payload);
            }
        }

        private void onNetEnd(EndFW end) {
            long traceId = end.traceId();
            long authorization = end.authorization();
            this.app.doAppEnd(traceId, authorization);
        }

        private void onNetAbort(AbortFW abort) {
            long traceId = abort.traceId();
            long authorization = abort.authorization();
            this.app.doAppAbort(traceId, authorization);
        }

        private void onNetFlush(FlushFW flush) {
            long traceId = flush.traceId();
            long authorization = flush.authorization();
            long budgetId = flush.budgetId();
            int reserved = flush.reserved();
            this.app.doAppFlush(traceId, authorization, budgetId, reserved);
        }

        private void onNetWindow(WindowFW window) {
            int initialWin;
            long sequence = window.sequence();
            long acknowledge = window.acknowledge();
            int maximum = window.maximum();
            long traceId = window.traceId();
            long authorization = window.authorization();
            long budgetId = window.budgetId();
            int minimum = window.minimum();
            int capabilities = window.capabilities();
            int padding = window.padding();
            assert (acknowledge <= sequence);
            assert (sequence <= this.initialSeq);
            assert (acknowledge >= this.initialAck);
            assert (maximum >= this.initialMax);
            this.initialAck = acknowledge;
            this.initialMax = maximum;
            this.initialPad = padding;
            assert (this.initialAck <= this.initialSeq);
            if (this.encodeSlot != -1) {
                MutableDirectBuffer encodeBuffer = ProxyClientFactory.this.encodePool.buffer(this.encodeSlot);
                OctetsFW payload = ProxyClientFactory.this.payloadRO.wrap((DirectBuffer)encodeBuffer, 0, this.encodeSlotOffset);
                this.doNetData(traceId, authorization, budgetId, 3, payload.sizeof() + padding, payload);
                ProxyClientFactory.this.encodePool.release(this.encodeSlot);
                this.encodeSlot = -1;
            }
            if ((initialWin = this.initialMax - (int)(this.initialSeq - this.initialAck)) > 0) {
                this.app.doAppWindow(traceId, authorization, budgetId, minimum, capabilities, initialWin, this.initialPad, this.initialMax);
            }
        }

        private void onNetReset(ResetFW reset) {
            long traceId = reset.traceId();
            long authorization = reset.authorization();
            this.app.doAppReset(traceId, authorization);
        }

        private void onNetChallenge(ChallengeFW challenge) {
            long traceId = challenge.traceId();
            long authorization = challenge.authorization();
            OctetsFW extension = challenge.extension();
            this.app.doAppChallenge(traceId, authorization, extension);
        }

        private void doNetBegin(long traceId, long authorization, long affinity, ProxyBeginExFW beginEx) {
            assert (this.encodeSlot == -1);
            this.encodeSlot = ProxyClientFactory.this.encodePool.acquire(this.initialId);
            assert (this.encodeSlot != -1);
            MutableDirectBuffer buffer = ProxyClientFactory.this.encodePool.buffer(this.encodeSlot);
            this.encodeSlotOffset = beginEx != null ? this.encodeProxy(buffer, beginEx) : this.encodeLocal(buffer);
            ProxyClientFactory.this.correlations.put(this.replyId, this::onNetMessage);
            ProxyClientFactory.this.router.setThrottle(this.initialId, this::onNetMessage);
            ProxyClientFactory.this.doBegin(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization, affinity);
        }

        private void doNetData(long traceId, long authorization, long budgetId, int flags, int reserved, OctetsFW payload) {
            ProxyClientFactory.this.doData(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization, flags, budgetId, reserved, payload);
            this.initialSeq += (long)reserved;
            assert (this.initialAck <= this.initialSeq);
        }

        private void doNetEnd(long traceId, long authorization) {
            ProxyClientFactory.this.doEnd(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization);
        }

        private void doNetAbort(long traceId, long authorization) {
            ProxyClientFactory.this.doAbort(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization);
        }

        private void doNetFlush(long traceId, long authorization, long budgetId, int reserved) {
            ProxyClientFactory.this.doFlush(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization, budgetId, reserved);
        }

        private void doNetReset(long traceId, long authorization) {
            ProxyClientFactory.this.correlations.remove(this.replyId);
            ProxyClientFactory.this.doReset(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization);
        }

        private void doNetChallenge(long traceId, long authorization, OctetsFW extension) {
            ProxyClientFactory.this.doChallenge(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization, extension);
        }

        private void doNetWindow(long traceId, long authorization, long budgetId, int minimum, int capabilities, int minReplyWin, int minReplyPad, int minReplyMax) {
            long newReplyAck = Math.max(this.replySeq - (long)minReplyWin, this.replyAck);
            if (newReplyAck > this.replyAck || minReplyMax > this.replyMax) {
                this.replyAck = newReplyAck;
                assert (this.replyAck <= this.replySeq);
                this.replyMax = minReplyMax;
                ProxyClientFactory.this.doWindow(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization, budgetId, minReplyPad, minimum, capabilities);
            }
        }

        private int encodeHeader(MutableDirectBuffer buffer) {
            buffer.putBytes(0, HEADER_V2, 0, HEADER_V2.capacity());
            return HEADER_V2.capacity();
        }

        private int encodeLocal(MutableDirectBuffer buffer) {
            int progress = this.encodeHeader(buffer);
            buffer.putByte(progress++, (byte)32);
            buffer.putByte(progress++, (byte)0);
            buffer.putByte(progress++, (byte)0);
            buffer.putByte(progress++, (byte)0);
            return progress;
        }

        private int encodeProxy(MutableDirectBuffer buffer, ProxyBeginExFW beginEx) {
            ProxyAddressFW address = beginEx.address();
            Array32FW<ProxyInfoFW> infos = beginEx.infos();
            int progress = this.encodeHeader(buffer);
            buffer.putByte(progress++, (byte)33);
            progress = this.encodeProxyAddress(buffer, progress, address);
            progress = this.encodeProxyTlvs(buffer, progress, infos);
            buffer.putShort(14, (short)(progress - 14 - 2), ByteOrder.BIG_ENDIAN);
            return progress;
        }

        private int encodeProxyAddress(MutableDirectBuffer buffer, int progress, ProxyAddressFW address) {
            switch (address.kind()) {
                case INET: {
                    progress = this.encodeProxyAddressInet(buffer, progress, address);
                    break;
                }
                case INET4: {
                    progress = this.encodeProxyAddressInet4(buffer, progress, address);
                    break;
                }
                case INET6: {
                    progress = this.encodeProxyAddressInet6(buffer, progress, address);
                    break;
                }
                case UNIX: {
                    progress = this.encodeProxyAddressUnix(buffer, progress, address);
                    break;
                }
            }
            return progress;
        }

        private int encodeProxyAddressInet(MutableDirectBuffer buffer, int progress, ProxyAddressFW address) {
            ProxyAddressInetFW inet = address.inet();
            String sourceName = inet.source().asString();
            String destinationName = inet.destination().asString();
            InetAddress destinationInet = ((InetAddress[])ProxyClientFactory.this.resolveHost.apply(destinationName))[0];
            byte[] destination = destinationInet.getAddress();
            ProxyAddressFamily family = ProxyClientFactory.asProxyAddressFamily(destinationInet);
            assert (family == ProxyAddressFamily.INET4 || family == ProxyAddressFamily.INET6);
            InetAddress sourceInet = sourceName != null ? ((InetAddress[])ProxyClientFactory.this.resolveHost.apply(sourceName))[0] : ProxyClientFactory.getInetAddressLocal(family);
            byte[] source = sourceInet.getAddress();
            assert (ProxyClientFactory.asProxyAddressFamily(sourceInet) == family);
            buffer.putByte(progress++, (byte)(family.ordinal() << 4 | inet.protocol().get().ordinal() + 1));
            buffer.putBytes(progress += 2, source, 0, source.length);
            buffer.putBytes(progress += source.length, destination, 0, destination.length);
            buffer.putShort(progress += destination.length, (short)inet.sourcePort(), ByteOrder.BIG_ENDIAN);
            buffer.putShort(progress += 2, (short)inet.destinationPort(), ByteOrder.BIG_ENDIAN);
            return progress += 2;
        }

        private int encodeProxyAddressInet4(MutableDirectBuffer buffer, int progress, ProxyAddressFW address) {
            ProxyAddressInet4FW inet4 = address.inet4();
            buffer.putByte(progress++, (byte)(0x10 | inet4.protocol().get().ordinal() + 1));
            buffer.putBytes(progress += 2, inet4.source().value(), 0, inet4.source().sizeof());
            buffer.putBytes(progress += inet4.source().sizeof(), inet4.destination().value(), 0, inet4.destination().sizeof());
            buffer.putShort(progress += inet4.destination().sizeof(), (short)inet4.sourcePort(), ByteOrder.BIG_ENDIAN);
            buffer.putShort(progress += 2, (short)inet4.destinationPort(), ByteOrder.BIG_ENDIAN);
            return progress += 2;
        }

        private int encodeProxyAddressInet6(MutableDirectBuffer buffer, int progress, ProxyAddressFW address) {
            ProxyAddressInet6FW inet6 = address.inet6();
            buffer.putByte(progress++, (byte)(0x20 | inet6.protocol().get().ordinal() + 1));
            buffer.putBytes(progress += 2, inet6.source().value(), 0, inet6.source().sizeof());
            buffer.putBytes(progress += inet6.source().sizeof(), inet6.destination().value(), 0, inet6.destination().sizeof());
            buffer.putShort(progress += inet6.destination().sizeof(), (short)inet6.sourcePort(), ByteOrder.BIG_ENDIAN);
            buffer.putShort(progress += 2, (short)inet6.destinationPort(), ByteOrder.BIG_ENDIAN);
            return progress += 2;
        }

        private int encodeProxyAddressUnix(MutableDirectBuffer buffer, int progress, ProxyAddressFW address) {
            ProxyAddressUnixFW unix = address.unix();
            buffer.putByte(progress++, (byte)(0x30 | unix.protocol().get().ordinal() + 1));
            buffer.putBytes(progress += 2, unix.source().value(), 0, unix.source().sizeof());
            buffer.putBytes(progress += unix.source().sizeof(), unix.destination().value(), 0, unix.destination().sizeof());
            return progress += unix.destination().sizeof();
        }

        private int encodeProxyTlvs(MutableDirectBuffer buffer, int progress, Array32FW<ProxyInfoFW> infos) {
            DirectBuffer items = infos.items();
            int itemOffset = 0;
            block14: while (itemOffset < items.capacity()) {
                ProxyInfoFW info = ProxyClientFactory.this.infoRO.wrap(items, itemOffset, items.capacity());
                switch (info.kind()) {
                    case ALPN: {
                        progress = this.encodeProxyTlvAlpn(buffer, progress, info);
                        itemOffset = info.limit();
                        continue block14;
                    }
                    case AUTHORITY: {
                        progress = this.encodeProxyTlvAuthority(buffer, progress, info);
                        itemOffset = info.limit();
                        continue block14;
                    }
                    case IDENTITY: {
                        progress = this.encodeProxyTlvUniqueId(buffer, progress, info);
                        itemOffset = info.limit();
                        continue block14;
                    }
                    case SECURE: {
                        buffer.putByte(progress++, (byte)32);
                        int secureInfoOffset = progress;
                        buffer.putByte(progress += 2, (byte)7);
                        buffer.putInt(++progress, 0, ByteOrder.BIG_ENDIAN);
                        progress += 4;
                        while (itemOffset < items.capacity() && info.kind() == ProxyInfoType.SECURE) {
                            info = ProxyClientFactory.this.infoRO.wrap(items, itemOffset, items.capacity());
                            ProxySecureInfoFW secureInfo = info.secure();
                            switch (secureInfo.kind()) {
                                case PROTOCOL: {
                                    progress = this.encodeProxyTlvSslVersion(buffer, progress, secureInfo);
                                    break;
                                }
                                case NAME: {
                                    progress = this.encodeProxyTlvSslCommonName(buffer, progress, secureInfo);
                                    break;
                                }
                                case CIPHER: {
                                    progress = this.encodeProxyTlvSslCipher(buffer, progress, secureInfo);
                                    break;
                                }
                                case SIGNATURE: {
                                    progress = this.encodeProxyTlvSslSignature(buffer, progress, secureInfo);
                                    break;
                                }
                                case KEY: {
                                    progress = this.encodeProxyTlvSslKey(buffer, progress, secureInfo);
                                }
                            }
                            itemOffset = info.limit();
                        }
                        buffer.putShort(secureInfoOffset, (short)(progress - secureInfoOffset - 2), ByteOrder.BIG_ENDIAN);
                        continue block14;
                    }
                    case NAMESPACE: {
                        progress = this.encodeProxyTlvNamespace(buffer, progress, info);
                        itemOffset = info.limit();
                        continue block14;
                    }
                }
                itemOffset = info.limit();
            }
            return progress;
        }

        private int encodeProxyTlvAlpn(MutableDirectBuffer buffer, int progress, ProxyInfoFW info) {
            DirectBuffer alpn = info.alpn().value();
            ProxyTlvFW alpnTlv = ProxyClientFactory.this.tlvRW.wrap(buffer, progress, buffer.capacity()).type(1).value(alpn, 0, alpn.capacity()).build();
            return progress += alpnTlv.sizeof();
        }

        private int encodeProxyTlvAuthority(MutableDirectBuffer buffer, int progress, ProxyInfoFW info) {
            DirectBuffer authority = info.authority().value();
            ProxyTlvFW authorityTlv = ProxyClientFactory.this.tlvRW.wrap(buffer, progress, buffer.capacity()).type(2).value(authority, 0, authority.capacity()).build();
            return progress += authorityTlv.sizeof();
        }

        private int encodeProxyTlvUniqueId(MutableDirectBuffer buffer, int progress, ProxyInfoFW info) {
            OctetsFW identity = info.identity().value();
            ProxyTlvFW identityTlv = ProxyClientFactory.this.tlvRW.wrap(buffer, progress, buffer.capacity()).type(5).value(identity).build();
            return progress += identityTlv.sizeof();
        }

        private int encodeProxyTlvSslKey(MutableDirectBuffer buffer, int progress, ProxySecureInfoFW secureInfo) {
            DirectBuffer key = secureInfo.key().value();
            ProxyTlvFW keyTlv = ProxyClientFactory.this.tlvRW.wrap(buffer, progress, buffer.capacity()).type(37).value(key, 0, key.capacity()).build();
            return progress += keyTlv.sizeof();
        }

        private int encodeProxyTlvSslSignature(MutableDirectBuffer buffer, int progress, ProxySecureInfoFW secureInfo) {
            DirectBuffer signature = secureInfo.signature().value();
            ProxyTlvFW signatureTlv = ProxyClientFactory.this.tlvRW.wrap(buffer, progress, buffer.capacity()).type(36).value(signature, 0, signature.capacity()).build();
            return progress += signatureTlv.sizeof();
        }

        private int encodeProxyTlvSslCipher(MutableDirectBuffer buffer, int progress, ProxySecureInfoFW secureInfo) {
            DirectBuffer cipher = secureInfo.cipher().value();
            ProxyTlvFW cipherTlv = ProxyClientFactory.this.tlvRW.wrap(buffer, progress, buffer.capacity()).type(35).value(cipher, 0, cipher.capacity()).build();
            return progress += cipherTlv.sizeof();
        }

        private int encodeProxyTlvSslCommonName(MutableDirectBuffer buffer, int progress, ProxySecureInfoFW secureInfo) {
            DirectBuffer commonName = secureInfo.name().value();
            ProxyTlvFW commonNameTlv = ProxyClientFactory.this.tlvRW.wrap(buffer, progress, buffer.capacity()).type(34).value(commonName, 0, commonName.capacity()).build();
            return progress += commonNameTlv.sizeof();
        }

        private int encodeProxyTlvSslVersion(MutableDirectBuffer buffer, int progress, ProxySecureInfoFW secureInfo) {
            DirectBuffer version = secureInfo.protocol().value();
            ProxyTlvFW versionTlv = ProxyClientFactory.this.tlvRW.wrap(buffer, progress, buffer.capacity()).type(33).value(version, 0, version.capacity()).build();
            return progress += versionTlv.sizeof();
        }

        private int encodeProxyTlvNamespace(MutableDirectBuffer buffer, int progress, ProxyInfoFW info) {
            DirectBuffer namespace = info.namespace().value();
            ProxyTlvFW namespaceTlv = ProxyClientFactory.this.tlvRW.wrap(buffer, progress, buffer.capacity()).type(48).value(namespace, 0, namespace.capacity()).build();
            return progress += namespaceTlv.sizeof();
        }
    }
}

