/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.stream;

import java.util.regex.Pattern;
import org.agrona.DirectBuffer;
import org.agrona.collections.MutableBoolean;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.function.MessageConsumer;
import org.reaktivity.nukleus.proxy.internal.types.Array32FW;
import org.reaktivity.nukleus.proxy.internal.types.OctetsFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressInet4FW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressInet6FW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressInetFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressMatchFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressMatchInet4FW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressMatchInet6FW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressMatchInetFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressMatchUnixFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressProtocolFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressRangeInet4FW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressRangeInet6FW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressRangeInetFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressRangeUnixFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressUnixFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyInfoFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyPortRangeFW;
import org.reaktivity.nukleus.proxy.internal.types.String16FW;
import org.reaktivity.nukleus.proxy.internal.types.control.ProxyRouteExFW;
import org.reaktivity.nukleus.proxy.internal.types.control.RouteFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.BeginFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.ProxyBeginExFW;
import org.reaktivity.nukleus.route.RouteManager;

public final class ProxyRouter {
    private final RouteFW routeRO = new RouteFW();
    private final ProxyBeginExFW beginExRO = new ProxyBeginExFW();
    private final ProxyRouteExFW routeExRO = new ProxyRouteExFW();
    private final DirectBuffer prefixBuf = new UnsafeBuffer();
    private final DirectBuffer addressBuf = new UnsafeBuffer();
    private final MutableBoolean matchInfos = new MutableBoolean();
    private final RouteManager router;
    private final int typeId;
    private ProxyAddressFW address;
    private Array32FW<ProxyInfoFW> infos;

    public ProxyRouter(RouteManager router, int typeId) {
        this.router = router;
        this.typeId = typeId;
    }

    public int typeId() {
        return this.typeId;
    }

    public RouteFW resolveApp(BeginFW begin) {
        long routeId = begin.routeId();
        long authorization = begin.authorization();
        OctetsFW extension = begin.extension();
        ProxyBeginExFW beginEx = extension.get(this.beginExRO::tryWrap);
        return this.resolve(routeId, authorization, beginEx);
    }

    public RouteFW resolveNet(long routeId, long authorization, ProxyBeginExFW beginEx) {
        return this.resolve(routeId, authorization, beginEx);
    }

    public MessageConsumer supplyReceiver(long streamId) {
        return this.router.supplyReceiver(streamId);
    }

    public void setThrottle(long streamId, MessageConsumer throttle) {
        this.router.setThrottle(streamId, throttle);
    }

    private RouteFW resolve(long routeId, long authorization, ProxyBeginExFW beginEx) {
        this.address = beginEx != null && beginEx.typeId() == this.typeId ? beginEx.address() : null;
        this.infos = beginEx != null && beginEx.typeId() == this.typeId ? beginEx.infos() : null;
        return (RouteFW)this.router.resolve(routeId, authorization, this::filter, this::map);
    }

    private RouteFW map(int msgTypeId, DirectBuffer buffer, int index, int length) {
        return this.routeRO.wrap(buffer, index, index + length);
    }

    private boolean filter(int msgTypeId, DirectBuffer buffer, int index, int length) {
        RouteFW route = this.routeRO.wrap(buffer, index, index + length);
        ProxyRouteExFW routeEx = route.extension().get(this.routeExRO::tryWrap);
        if (routeEx == null) {
            return true;
        }
        if (this.address == null) {
            return false;
        }
        return this.matchesAddress(routeEx.address(), this.address) && this.matchesInfos(routeEx.infos(), this.infos);
    }

    private boolean matchesAddress(ProxyAddressMatchFW addressMatch, ProxyAddressFW address) {
        if (addressMatch.kind() == address.kind()) {
            switch (addressMatch.kind()) {
                case INET: {
                    return this.matchesAddressInet(addressMatch.inet(), address.inet());
                }
                case INET4: {
                    return this.matchesAddressInet4(addressMatch.inet4(), address.inet4());
                }
                case INET6: {
                    return this.matchesAddressInet6(addressMatch.inet6(), address.inet6());
                }
                case UNIX: {
                    return this.matchesAddressUnix(addressMatch.unix(), address.unix());
                }
            }
        }
        return false;
    }

    private boolean matchesProtocol(ProxyAddressProtocolFW protocolMatch, ProxyAddressProtocolFW protocol) {
        return protocolMatch.get() == protocol.get();
    }

    boolean matchesAddressRange(OctetsFW address, OctetsFW prefix, int length) {
        this.prefixBuf.wrap(prefix.value(), 0, length);
        this.addressBuf.wrap(address.value(), 0, length);
        return this.prefixBuf.equals(this.addressBuf);
    }

    private boolean matchesPortRange(ProxyPortRangeFW portRange, int port) {
        int low = portRange.low();
        int high = portRange.high();
        return low <= port && port <= high;
    }

    private boolean matchesAddressRangeInet(ProxyAddressRangeInetFW addressRange, String16FW address) {
        String pattern = addressRange.pattern().asString();
        String regex = pattern.replaceAll("\\*", ".*").replaceAll("\\.", "\\.");
        return Pattern.compile(regex).matcher(address.asString()).matches();
    }

    private boolean matchesAddressRangeInet4(ProxyAddressRangeInet4FW addressRange, OctetsFW address) {
        OctetsFW prefix = addressRange.prefix();
        int length = addressRange.length();
        return this.matchesAddressRange(address, prefix, length);
    }

    private boolean matchesAddressRangeInet6(ProxyAddressRangeInet6FW addressRange, OctetsFW address) {
        OctetsFW prefix = addressRange.prefix();
        int length = addressRange.length();
        return this.matchesAddressRange(address, prefix, length);
    }

    private boolean matchesAddressRangeUnix(ProxyAddressRangeUnixFW addressRange, OctetsFW address) {
        OctetsFW prefix = addressRange.prefix();
        int length = addressRange.length();
        return this.matchesAddressRange(address, prefix, length);
    }

    private boolean matchesAddressInet(ProxyAddressMatchInetFW inetMatch, ProxyAddressInetFW inet) {
        return this.matchesProtocol(inetMatch.protocol(), inet.protocol()) && this.matchesAddressRangeInet(inetMatch.source(), inet.source()) && this.matchesAddressRangeInet(inetMatch.destination(), inet.destination()) && this.matchesPortRange(inetMatch.sourcePort(), inet.sourcePort()) && this.matchesPortRange(inetMatch.destinationPort(), inet.destinationPort());
    }

    private boolean matchesAddressInet4(ProxyAddressMatchInet4FW inet4Match, ProxyAddressInet4FW inet4) {
        return this.matchesProtocol(inet4Match.protocol(), inet4.protocol()) && this.matchesAddressRangeInet4(inet4Match.source(), inet4.source()) && this.matchesAddressRangeInet4(inet4Match.destination(), inet4.destination()) && this.matchesPortRange(inet4Match.sourcePort(), inet4.sourcePort()) && this.matchesPortRange(inet4Match.destinationPort(), inet4.destinationPort());
    }

    private boolean matchesAddressInet6(ProxyAddressMatchInet6FW inet6Match, ProxyAddressInet6FW inet6) {
        return this.matchesProtocol(inet6Match.protocol(), inet6.protocol()) && this.matchesAddressRangeInet6(inet6Match.source(), inet6.source()) && this.matchesAddressRangeInet6(inet6Match.destination(), inet6.destination()) && this.matchesPortRange(inet6Match.sourcePort(), inet6.sourcePort()) && this.matchesPortRange(inet6Match.destinationPort(), inet6.destinationPort());
    }

    private boolean matchesAddressUnix(ProxyAddressMatchUnixFW unixMatch, ProxyAddressUnixFW unix) {
        return this.matchesProtocol(unixMatch.protocol(), unix.protocol()) && this.matchesAddressRangeUnix(unixMatch.source(), unix.source()) && this.matchesAddressRangeUnix(unixMatch.destination(), unix.destination());
    }

    private boolean matchesInfos(Array32FW<ProxyInfoFW> infosMatch, Array32FW<ProxyInfoFW> infos) {
        this.matchInfos.value = true;
        infosMatch.forEach(i -> this.matchInfos.value &= infos.anyMatch(i::equals));
        return this.matchInfos.value;
    }
}

