/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.stream;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import java.util.function.ToIntFunction;
import java.util.zip.CRC32C;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.buffer.BufferPool;
import org.reaktivity.nukleus.function.MessageConsumer;
import org.reaktivity.nukleus.proxy.internal.ProxyConfiguration;
import org.reaktivity.nukleus.proxy.internal.stream.ProxyRouter;
import org.reaktivity.nukleus.proxy.internal.stream.ProxyState;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.OctetsFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressProtocol;
import org.reaktivity.nukleus.proxy.internal.types.ProxyInfoFW;
import org.reaktivity.nukleus.proxy.internal.types.String16FW;
import org.reaktivity.nukleus.proxy.internal.types.codec.ProxyAddrFamily;
import org.reaktivity.nukleus.proxy.internal.types.codec.ProxyAddrInet4FW;
import org.reaktivity.nukleus.proxy.internal.types.codec.ProxyAddrInet6FW;
import org.reaktivity.nukleus.proxy.internal.types.codec.ProxyAddrProtocol;
import org.reaktivity.nukleus.proxy.internal.types.codec.ProxyAddrUnixFW;
import org.reaktivity.nukleus.proxy.internal.types.codec.ProxyTlvFW;
import org.reaktivity.nukleus.proxy.internal.types.codec.ProxyTlvSslFW;
import org.reaktivity.nukleus.proxy.internal.types.control.RouteFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.AbortFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.BeginFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.ChallengeFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.DataFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.EndFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.FlushFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.ProxyBeginExFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.ResetFW;
import org.reaktivity.nukleus.proxy.internal.types.stream.WindowFW;
import org.reaktivity.nukleus.route.RouteManager;
import org.reaktivity.nukleus.stream.StreamFactory;

public final class ProxyServerFactory
implements StreamFactory {
    private static final DirectBuffer HEADER_V2 = new UnsafeBuffer("\r\n\r\n\u0000\r\nQUIT\n".getBytes(StandardCharsets.US_ASCII));
    private static final int HEADER_V2_SIZE = HEADER_V2.capacity();
    private static final DirectBuffer EMPTY_BUFFER = new UnsafeBuffer(0L, 0);
    private static final OctetsFW EMPTY_OCTETS = new OctetsFW().wrap(EMPTY_BUFFER, 0, 0);
    private static final int PROXY_ADDRESS_LENGTH_INET4 = 12;
    private static final int PROXY_ADDRESS_LENGTH_INET6 = 36;
    private static final int PROXY_ADDRESS_LENGTH_UNIX = 216;
    private final BeginFW beginRO = new BeginFW();
    private final DataFW dataRO = new DataFW();
    private final EndFW endRO = new EndFW();
    private final AbortFW abortRO = new AbortFW();
    private final FlushFW flushRO = new FlushFW();
    private final ProxyBeginExFW beginExRO = new ProxyBeginExFW();
    private final BeginFW.Builder beginRW = new BeginFW.Builder();
    private final DataFW.Builder dataRW = new DataFW.Builder();
    private final EndFW.Builder endRW = new EndFW.Builder();
    private final AbortFW.Builder abortRW = new AbortFW.Builder();
    private final FlushFW.Builder flushRW = new FlushFW.Builder();
    private final WindowFW windowRO = new WindowFW();
    private final ResetFW resetRO = new ResetFW();
    private final ChallengeFW challengeRO = new ChallengeFW();
    private final WindowFW.Builder windowRW = new WindowFW.Builder();
    private final ResetFW.Builder resetRW = new ResetFW.Builder();
    private final ChallengeFW.Builder challengeRW = new ChallengeFW.Builder();
    private final OctetsFW payloadRO = new OctetsFW();
    private final ProxyAddrInet4FW addressInet4RO = new ProxyAddrInet4FW();
    private final ProxyAddrInet6FW addressInet6RO = new ProxyAddrInet6FW();
    private final ProxyAddrUnixFW addressUnixRO = new ProxyAddrUnixFW();
    private final ProxyTlvFW tlvRO = new ProxyTlvFW();
    private final OctetsFW tlvBoundedRO = new OctetsFW();
    private final String16FW tlvStringRO = new String16FW(ByteOrder.BIG_ENDIAN);
    private final ProxyTlvSslFW tlvSslRO = new ProxyTlvSslFW();
    private final ProxyAddressFW.Builder addressRW = new ProxyAddressFW.Builder();
    private final ProxyInfoFW.Builder infoRW = new ProxyInfoFW.Builder();
    private final ProxyNetServerDecoder decodeHeader = this::decodeHeader;
    private final ProxyNetServerDecoder decodeVersion = this::decodeVersion;
    private final ProxyNetServerDecoder decodeCommand = this::decodeCommand;
    private final ProxyNetServerDecoder decodeLocal = this::decodeLocal;
    private final ProxyNetServerDecoder decodeProxy = this::decodeProxy;
    private final ProxyNetServerDecoder decodeProxyInet4 = this::decodeProxyInet4;
    private final ProxyNetServerDecoder decodeProxyInet6 = this::decodeProxyInet6;
    private final ProxyNetServerDecoder decodeProxyUnix = this::decodeProxyUnix;
    private final ProxyNetServerDecoder decodeProxyTlv = this::decodeProxyTlv;
    private final ProxyNetServerDecoder decodeProxyTlvAlpn = this::decodeProxyTlvAlpn;
    private final ProxyNetServerDecoder decodeProxyTlvAuthority = this::decodeProxyTlvAuthority;
    private final ProxyNetServerDecoder decodeProxyTlvCrc32c = this::decodeProxyTlvCrc32c;
    private final ProxyNetServerDecoder decodeProxyTlvIgnore = this::decodeProxyTlvIgnore;
    private final ProxyNetServerDecoder decodeProxyTlvUniqueId = this::decodeProxyTlvUniqueId;
    private final ProxyNetServerDecoder decodeProxyTlvSsl = this::decodeProxyTlvSsl;
    private final ProxyNetServerDecoder decodeProxyTlvNetns = this::decodeProxyTlvNetns;
    private final ProxyNetServerDecoder decodeProxyTlvSslSubTlv = this::decodeProxyTlvSslSubTlv;
    private final ProxyNetServerDecoder decodeProxyTlvSslSubTlvIgnore = this::decodeProxyTlvSslSubTlvIgnore;
    private final ProxyNetServerDecoder decodeProxyTlvSslVersion = this::decodeProxyTlvSslVersion;
    private final ProxyNetServerDecoder decodeProxyTlvSslCommonName = this::decodeProxyTlvSslCommonName;
    private final ProxyNetServerDecoder decodeProxyTlvSslCipher = this::decodeProxyTlvSslCipher;
    private final ProxyNetServerDecoder decodeProxyTlvSslSignature = this::decodeProxyTlvSslSignature;
    private final ProxyNetServerDecoder decodeProxyTlvSslKey = this::decodeProxyTlvSslKey;
    private final ProxyNetServerDecoder decodeIgnore = this::decodeIgnore;
    private final ProxyNetServerDecoder decodeIgnoreAll = this::decodeIgnoreAll;
    private final ProxyNetServerDecoder decodeData = this::decodeData;
    private final ProxyRouter router;
    private final MutableDirectBuffer writeBuffer;
    private final BufferPool decodePool;
    private final LongUnaryOperator supplyInitialId;
    private final LongUnaryOperator supplyReplyId;
    private final Long2ObjectHashMap<MessageConsumer> correlations;
    private final DirectBuffer headerRO = EMPTY_BUFFER;

    public ProxyServerFactory(ProxyConfiguration config, RouteManager router, MutableDirectBuffer writeBuffer, BufferPool bufferPool, LongUnaryOperator supplyInitialId, LongUnaryOperator supplyReplyId, ToIntFunction<String> supplyTypeId) {
        this.router = new ProxyRouter(router, supplyTypeId.applyAsInt("proxy"));
        this.writeBuffer = Objects.requireNonNull(writeBuffer);
        this.decodePool = Objects.requireNonNull(bufferPool);
        this.supplyInitialId = Objects.requireNonNull(supplyInitialId);
        this.supplyReplyId = Objects.requireNonNull(supplyReplyId);
        this.correlations = new Long2ObjectHashMap();
    }

    public MessageConsumer newStream(int msgTypeId, DirectBuffer buffer, int index, int length, MessageConsumer sender) {
        BeginFW begin = this.beginRO.wrap(buffer, index, index + length);
        long streamId = begin.streamId();
        MessageConsumer newStream = null;
        if ((streamId & 1L) != 0L) {
            long routeId = begin.routeId();
            long initialId = begin.streamId();
            long affinity = begin.affinity();
            newStream = (arg_0, arg_1, arg_2, arg_3) -> ProxyServerFactory.lambda$newStream$0(new ProxyNetServer(routeId, initialId, sender, affinity), arg_0, arg_1, arg_2, arg_3);
        } else {
            long replyId = begin.streamId();
            newStream = (MessageConsumer)this.correlations.remove(replyId);
        }
        return newStream;
    }

    private void doBegin(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization, long affinity, Flyweight extension) {
        BeginFW begin = this.beginRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).affinity(affinity).extension(extension.buffer(), extension.offset(), extension.sizeof()).build();
        receiver.accept(begin.typeId(), begin.buffer(), begin.offset(), begin.sizeof());
    }

    private void doData(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization, int flags, long budgetId, int reserved, OctetsFW payload) {
        DataFW data = this.dataRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).flags(flags).budgetId(budgetId).reserved(reserved).payload(payload).build();
        receiver.accept(data.typeId(), data.buffer(), data.offset(), data.sizeof());
    }

    private void doReset(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization) {
        ResetFW reset = this.resetRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).build();
        receiver.accept(reset.typeId(), reset.buffer(), reset.offset(), reset.sizeof());
    }

    private void doWindow(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization, long budgetId, int padding, int minimum, int capabilities) {
        WindowFW window = this.windowRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).budgetId(budgetId).padding(padding).minimum(minimum).capabilities(capabilities).build();
        receiver.accept(window.typeId(), window.buffer(), window.offset(), window.sizeof());
    }

    private void doChallenge(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization, OctetsFW extension) {
        ChallengeFW challenge = this.challengeRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).extension(extension).build();
        receiver.accept(challenge.typeId(), challenge.buffer(), challenge.offset(), challenge.sizeof());
    }

    private void doEnd(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization) {
        EndFW end = this.endRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).build();
        receiver.accept(end.typeId(), end.buffer(), end.offset(), end.sizeof());
    }

    private void doAbort(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization) {
        AbortFW abort = this.abortRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).build();
        receiver.accept(abort.typeId(), abort.buffer(), abort.offset(), abort.sizeof());
    }

    private void doFlush(MessageConsumer receiver, long routeId, long streamId, long sequence, long acknowledge, int maximum, long traceId, long authorization, long budgetId, int reserved) {
        FlushFW flush = this.flushRW.wrap(this.writeBuffer, 0, this.writeBuffer.capacity()).routeId(routeId).streamId(streamId).sequence(sequence).acknowledge(acknowledge).maximum(maximum).traceId(traceId).authorization(authorization).budgetId(budgetId).reserved(reserved).build();
        receiver.accept(flush.typeId(), flush.buffer(), flush.offset(), flush.sizeof());
    }

    private int decodeHeader(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length >= HEADER_V2_SIZE) {
            DirectBuffer header = this.headerRO;
            header.wrap(buffer, progress, HEADER_V2_SIZE);
            if (!HEADER_V2.equals(header)) {
                net.cleanup(traceId, authorization);
            } else {
                progress += HEADER_V2_SIZE;
                net.decoder = this.decodeVersion;
            }
        }
        return progress;
    }

    private int decodeVersion(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            int version = buffer.getByte(progress) >> 4 & 0xF;
            if (version != 2) {
                net.cleanup(traceId, authorization);
            } else {
                net.decoder = this.decodeCommand;
            }
        }
        return progress;
    }

    private int decodeCommand(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            int command = buffer.getByte(progress) & 0xF;
            switch (command) {
                case 0: {
                    ++progress;
                    net.decoder = this.decodeLocal;
                    break;
                }
                case 1: {
                    ++progress;
                    net.decoder = this.decodeProxy;
                    break;
                }
                default: {
                    net.cleanup(traceId, authorization);
                    break;
                }
            }
        }
        return progress;
    }

    private int decodeLocal(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length >= 3) {
            int anchor = progress;
            int transport = buffer.getByte(progress) & 0xF;
            if (transport > 3) {
                net.cleanup(traceId, authorization);
            } else {
                int remaining = buffer.getShort(++progress, ByteOrder.BIG_ENDIAN) & 0xFFFF;
                ProxyServerFactory.updateCRC32C(net.crc32c, buffer, anchor, (progress += 2) - anchor);
                if (remaining == 0) {
                    net.onNetReady(traceId, authorization);
                    net.decoder = this.decodeData;
                } else {
                    net.doNetWindow(traceId, authorization, budgetId, 0, 0, 0, 0, remaining);
                    net.decodableBytes = remaining;
                    net.decoder = this.decodeIgnore;
                }
            }
        }
        return progress;
    }

    private int decodeIgnore(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0 || net.decodableBytes == 0) {
            int remaining = Math.min(length, net.decodableBytes);
            progress += remaining;
            net.decodableBytes -= remaining;
            if (net.decodableBytes == 0) {
                net.onNetReady(traceId, authorization);
                net.decoder = this.decodeData;
            }
        }
        return progress;
    }

    private int decodeIgnoreAll(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        return limit;
    }

    private int decodeProxy(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length >= 3) {
            int anchor = progress;
            byte protocol = buffer.getByte(progress);
            int family = protocol >> 4 & 0xF;
            int transport = protocol & 0xF;
            if (family == 0 || family > 3 || transport == 0 || transport > 2) {
                net.cleanup(traceId, authorization);
            } else {
                int remaining = buffer.getShort(++progress, ByteOrder.BIG_ENDIAN) & 0xFFFF;
                net.doNetWindow(traceId, authorization, budgetId, 0, 0, 0, 0, remaining);
                net.decodedFamily = ProxyAddrFamily.valueOf(family);
                net.decodedTransport = ProxyAddrProtocol.valueOf(transport);
                net.decodableBytes = remaining;
                ProxyServerFactory.updateCRC32C(net.crc32c, buffer, anchor, (progress += 2) - anchor);
                switch (net.decodedFamily) {
                    case INET4: {
                        if (remaining < 12) {
                            net.cleanup(traceId, authorization);
                            break;
                        }
                        net.decoder = this.decodeProxyInet4;
                        break;
                    }
                    case INET6: {
                        if (remaining < 36) {
                            net.cleanup(traceId, authorization);
                            break;
                        }
                        net.decoder = this.decodeProxyInet6;
                        break;
                    }
                    case UNIX: {
                        if (remaining < 216) {
                            net.cleanup(traceId, authorization);
                            break;
                        }
                        net.decoder = this.decodeProxyUnix;
                    }
                }
            }
        }
        return progress;
    }

    private int decodeProxyInet4(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length >= 12) {
            ProxyAddrInet4FW addressInet4 = this.addressInet4RO.tryWrap(buffer, progress, limit);
            if (addressInet4 == null) {
                net.cleanup(traceId, authorization);
            } else {
                OctetsFW source = addressInet4.source();
                OctetsFW destination = addressInet4.destination();
                int sourcePort = addressInet4.sourcePort();
                int destinationPort = addressInet4.destinationPort();
                if (net.decodeSlot == -1) {
                    net.decodeSlot = this.decodePool.acquire(net.initialId);
                }
                assert (net.decodeSlot != -1);
                MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
                decodeBuf.putInt(net.decodeOffset, this.router.typeId());
                net.decodeOffset += 4;
                net.decodeLimit = net.decodeOffset;
                ProxyAddressFW address = (ProxyAddressFW)this.addressRW.wrap(decodeBuf, net.decodeOffset, decodeBuf.capacity()).inet4(i -> i.protocol(t -> t.set(ProxyAddressProtocol.valueOf(net.decodedTransport.ordinal()))).source(source).destination(destination).sourcePort(sourcePort).destinationPort(destinationPort)).build();
                net.decodableBytes -= addressInet4.sizeof();
                net.decodeOffset += address.sizeof();
                net.decodeLimit = net.decodeOffset;
                progress = addressInet4.limit();
                decodeBuf.putInt(net.decodeOffset, 4);
                net.decodeOffset += 4;
                decodeBuf.putInt(net.decodeOffset, 0);
                net.decodeOffset += 4;
                net.decodeLimit = net.decodeOffset;
                ProxyServerFactory.updateCRC32C(net.crc32c, addressInet4.buffer(), addressInet4.offset(), addressInet4.sizeof());
                net.decoder = this.decodeProxyTlv;
            }
        }
        return progress;
    }

    private int decodeProxyInet6(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length >= 36) {
            ProxyAddrInet6FW addressInet6 = this.addressInet6RO.tryWrap(buffer, progress, limit);
            if (addressInet6 == null) {
                net.cleanup(traceId, authorization);
            } else {
                OctetsFW source = addressInet6.source();
                OctetsFW destination = addressInet6.destination();
                int sourcePort = addressInet6.sourcePort();
                int destinationPort = addressInet6.destinationPort();
                if (net.decodeSlot == -1) {
                    net.decodeSlot = this.decodePool.acquire(net.initialId);
                }
                assert (net.decodeSlot != -1);
                MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
                decodeBuf.putInt(net.decodeOffset, this.router.typeId());
                net.decodeOffset += 4;
                net.decodeLimit = net.decodeOffset;
                ProxyAddressFW address = (ProxyAddressFW)this.addressRW.wrap(decodeBuf, net.decodeOffset, decodeBuf.capacity()).inet6(i -> i.protocol(t -> t.set(ProxyAddressProtocol.valueOf(net.decodedTransport.ordinal()))).source(source).destination(destination).sourcePort(sourcePort).destinationPort(destinationPort)).build();
                net.decodableBytes -= addressInet6.sizeof();
                net.decodeOffset += address.sizeof();
                net.decodeLimit = net.decodeOffset;
                progress = addressInet6.limit();
                decodeBuf.putInt(net.decodeOffset, 4);
                net.decodeOffset += 4;
                decodeBuf.putInt(net.decodeOffset, 0);
                net.decodeOffset += 4;
                net.decodeLimit = net.decodeOffset;
                ProxyServerFactory.updateCRC32C(net.crc32c, addressInet6.buffer(), addressInet6.offset(), addressInet6.sizeof());
                net.decoder = this.decodeProxyTlv;
            }
        }
        return progress;
    }

    private int decodeProxyUnix(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length >= 216) {
            ProxyAddrUnixFW addressUnix = this.addressUnixRO.tryWrap(buffer, progress, limit);
            if (addressUnix == null) {
                net.cleanup(traceId, authorization);
            } else {
                OctetsFW source = addressUnix.source();
                OctetsFW destination = addressUnix.destination();
                if (net.decodeSlot == -1) {
                    net.decodeSlot = this.decodePool.acquire(net.initialId);
                }
                assert (net.decodeSlot != -1);
                MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
                decodeBuf.putInt(net.decodeOffset, this.router.typeId());
                net.decodeOffset += 4;
                net.decodeLimit = net.decodeOffset;
                ProxyAddressFW address = (ProxyAddressFW)this.addressRW.wrap(decodeBuf, net.decodeOffset, decodeBuf.capacity()).unix(i -> i.protocol(t -> t.set(ProxyAddressProtocol.valueOf(net.decodedTransport.ordinal()))).source(source).destination(destination)).build();
                net.decodableBytes -= addressUnix.sizeof();
                net.decodeOffset += address.sizeof();
                net.decodeLimit = net.decodeOffset;
                progress = addressUnix.limit();
                decodeBuf.putInt(net.decodeOffset, 4);
                net.decodeOffset += 4;
                decodeBuf.putInt(net.decodeOffset, 0);
                net.decodeOffset += 4;
                net.decodeLimit = net.decodeOffset;
                ProxyServerFactory.updateCRC32C(net.crc32c, addressUnix.buffer(), addressUnix.offset(), addressUnix.sizeof());
                net.decoder = this.decodeProxyTlv;
            }
        }
        return progress;
    }

    private int decodeProxyTlv(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        ProxyTlvFW tlv;
        int length = limit - progress;
        if (net.decodableBytes == 0) {
            if (net.decodedCrc32c != -1L && net.decodedCrc32c != net.crc32c.getValue()) {
                net.cleanup(traceId, authorization);
            } else {
                net.crc32c = null;
                assert (net.decodeSlot != -1);
                MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
                int size = decodeBuf.getInt(net.decodeOffset - 4 - 4);
                net.decodeOffset += size - 4;
                net.decodeLimit = net.decodeOffset;
                net.onNetReady(traceId, authorization);
                net.decoder = this.decodeData;
            }
        } else if (length > 0 && (tlv = this.tlvRO.tryWrap(buffer, progress, limit)) != null) {
            switch (tlv.type()) {
                case 1: {
                    net.decoder = this.decodeProxyTlvAlpn;
                    break;
                }
                case 2: {
                    net.decoder = this.decodeProxyTlvAuthority;
                    break;
                }
                case 3: {
                    net.decoder = this.decodeProxyTlvCrc32c;
                    break;
                }
                case 4: {
                    net.decoder = this.decodeProxyTlvIgnore;
                    break;
                }
                case 5: {
                    net.decoder = this.decodeProxyTlvUniqueId;
                    break;
                }
                case 32: {
                    net.decoder = this.decodeProxyTlvSsl;
                    break;
                }
                case 48: {
                    net.decoder = this.decodeProxyTlvNetns;
                    break;
                }
                default: {
                    net.decoder = this.decodeProxyTlvIgnore;
                }
            }
        }
        return progress;
    }

    private int decodeProxyTlvAlpn(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            assert (net.decodeSlot != -1);
            MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
            int size = decodeBuf.getInt(net.decodeOffset - 4 - 4);
            int items = decodeBuf.getInt(net.decodeOffset - 4);
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            OctetsFW tlvBounded = this.tlvBoundedRO.wrap(tlv.buffer(), tlv.offset() + 1, tlv.limit());
            String16FW alpn = tlvBounded.get(this.tlvStringRO::wrap);
            ProxyInfoFW info = (ProxyInfoFW)this.infoRW.wrap(decodeBuf, net.decodeOffset + size - 4, this.decodePool.slotCapacity()).alpn(alpn).build();
            decodeBuf.putInt(net.decodeOffset - 4 - 4, size += info.sizeof());
            decodeBuf.putInt(net.decodeOffset - 4, ++items);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlv;
        }
        return progress;
    }

    private int decodeProxyTlvAuthority(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            assert (net.decodeSlot != -1);
            MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
            int size = decodeBuf.getInt(net.decodeOffset - 4 - 4);
            int items = decodeBuf.getInt(net.decodeOffset - 4);
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            OctetsFW tlvBounded = this.tlvBoundedRO.wrap(tlv.buffer(), tlv.offset() + 1, tlv.limit());
            String16FW authority = tlvBounded.get(this.tlvStringRO::wrap);
            ProxyInfoFW info = (ProxyInfoFW)this.infoRW.wrap(decodeBuf, net.decodeOffset + size - 4, this.decodePool.slotCapacity()).authority(authority).build();
            decodeBuf.putInt(net.decodeOffset - 4 - 4, size += info.sizeof());
            decodeBuf.putInt(net.decodeOffset - 4, ++items);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlv;
        }
        return progress;
    }

    private int decodeProxyTlvCrc32c(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, MutableDirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            ProxyTlvFW tlv = this.tlvRO.wrap((DirectBuffer)buffer, progress, limit);
            if (tlv.length() != 4) {
                net.cleanup(traceId, authorization);
            } else {
                net.decodedCrc32c = (long)tlv.value().value().getInt(0, ByteOrder.BIG_ENDIAN) & 0xFFFFFFFFL;
                buffer.putInt(tlv.offset() + 3, 0);
                ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
                net.decodableBytes -= tlv.sizeof();
                progress += tlv.sizeof();
                net.decoder = this.decodeProxyTlv;
            }
        }
        return progress;
    }

    private int decodeProxyTlvIgnore(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlv;
        }
        return progress;
    }

    private int decodeProxyTlvUniqueId(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            assert (net.decodeSlot != -1);
            MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
            int size = decodeBuf.getInt(net.decodeOffset - 4 - 4);
            int items = decodeBuf.getInt(net.decodeOffset - 4);
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            OctetsFW uniqueId = tlv.value();
            ProxyInfoFW info = (ProxyInfoFW)this.infoRW.wrap(decodeBuf, net.decodeOffset + size - 4, this.decodePool.slotCapacity()).identity(i -> i.value(uniqueId)).build();
            decodeBuf.putInt(net.decodeOffset - 4 - 4, size += info.sizeof());
            decodeBuf.putInt(net.decodeOffset - 4, ++items);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlv;
        }
        return progress;
    }

    private int decodeProxyTlvSsl(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            ProxyTlvSslFW ssl = tlv.value().get(this.tlvSslRO::tryWrap);
            if (ssl == null) {
                net.cleanup(traceId, authorization);
            } else {
                ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), ssl.limit() - tlv.offset());
                net.decodableBytes -= ssl.limit() - tlv.offset();
                net.decodableTlvBytes = tlv.length() - ssl.sizeof();
                progress += ssl.limit() - tlv.offset();
                net.decoder = this.decodeProxyTlvSslSubTlv;
            }
        }
        return progress;
    }

    private int decodeProxyTlvSslSubTlv(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        ProxyTlvFW tlv;
        int length = limit - progress;
        if (net.decodableTlvBytes == 0) {
            net.decoder = this.decodeProxyTlv;
        } else if (length > 0 && (tlv = this.tlvRO.tryWrap(buffer, progress, limit)) != null) {
            switch (tlv.type()) {
                case 33: {
                    net.decoder = this.decodeProxyTlvSslVersion;
                    break;
                }
                case 34: {
                    net.decoder = this.decodeProxyTlvSslCommonName;
                    break;
                }
                case 35: {
                    net.decoder = this.decodeProxyTlvSslCipher;
                    break;
                }
                case 36: {
                    net.decoder = this.decodeProxyTlvSslSignature;
                    break;
                }
                case 37: {
                    net.decoder = this.decodeProxyTlvSslKey;
                    break;
                }
                default: {
                    net.decoder = this.decodeProxyTlvSslSubTlvIgnore;
                }
            }
        }
        return progress;
    }

    private int decodeProxyTlvSslVersion(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            assert (net.decodeSlot != -1);
            MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
            int size = decodeBuf.getInt(net.decodeOffset - 4 - 4);
            int items = decodeBuf.getInt(net.decodeOffset - 4);
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            OctetsFW tlvBounded = this.tlvBoundedRO.wrap(tlv.buffer(), tlv.offset() + 1, tlv.limit());
            String16FW version = tlvBounded.get(this.tlvStringRO::wrap);
            ProxyInfoFW info = (ProxyInfoFW)this.infoRW.wrap(decodeBuf, net.decodeOffset + size - 4, this.decodePool.slotCapacity()).secure(s -> s.protocol(version)).build();
            decodeBuf.putInt(net.decodeOffset - 4 - 4, size += info.sizeof());
            decodeBuf.putInt(net.decodeOffset - 4, ++items);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableTlvBytes -= tlv.sizeof();
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlvSslSubTlv;
        }
        return progress;
    }

    private int decodeProxyTlvSslCommonName(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            assert (net.decodeSlot != -1);
            MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
            int size = decodeBuf.getInt(net.decodeOffset - 4 - 4);
            int items = decodeBuf.getInt(net.decodeOffset - 4);
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            OctetsFW tlvBounded = this.tlvBoundedRO.wrap(tlv.buffer(), tlv.offset() + 1, tlv.limit());
            String16FW commonName = tlvBounded.get(this.tlvStringRO::wrap);
            ProxyInfoFW info = (ProxyInfoFW)this.infoRW.wrap(decodeBuf, net.decodeOffset + size - 4, this.decodePool.slotCapacity()).secure(s -> s.name(commonName)).build();
            decodeBuf.putInt(net.decodeOffset - 4 - 4, size += info.sizeof());
            decodeBuf.putInt(net.decodeOffset - 4, ++items);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableTlvBytes -= tlv.sizeof();
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlvSslSubTlv;
        }
        return progress;
    }

    private int decodeProxyTlvSslCipher(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            assert (net.decodeSlot != -1);
            MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
            int size = decodeBuf.getInt(net.decodeOffset - 4 - 4);
            int items = decodeBuf.getInt(net.decodeOffset - 4);
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            OctetsFW tlvBounded = this.tlvBoundedRO.wrap(tlv.buffer(), tlv.offset() + 1, tlv.limit());
            String16FW cipher = tlvBounded.get(this.tlvStringRO::wrap);
            ProxyInfoFW info = (ProxyInfoFW)this.infoRW.wrap(decodeBuf, net.decodeOffset + size - 4, this.decodePool.slotCapacity()).secure(s -> s.cipher(cipher)).build();
            decodeBuf.putInt(net.decodeOffset - 4 - 4, size += info.sizeof());
            decodeBuf.putInt(net.decodeOffset - 4, ++items);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableTlvBytes -= tlv.sizeof();
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlvSslSubTlv;
        }
        return progress;
    }

    private int decodeProxyTlvSslSignature(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            assert (net.decodeSlot != -1);
            MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
            int size = decodeBuf.getInt(net.decodeOffset - 4 - 4);
            int items = decodeBuf.getInt(net.decodeOffset - 4);
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            OctetsFW tlvBounded = this.tlvBoundedRO.wrap(tlv.buffer(), tlv.offset() + 1, tlv.limit());
            String16FW signature = tlvBounded.get(this.tlvStringRO::wrap);
            ProxyInfoFW info = (ProxyInfoFW)this.infoRW.wrap(decodeBuf, net.decodeOffset + size - 4, this.decodePool.slotCapacity()).secure(s -> s.signature(signature)).build();
            decodeBuf.putInt(net.decodeOffset - 4 - 4, size += info.sizeof());
            decodeBuf.putInt(net.decodeOffset - 4, ++items);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableTlvBytes -= tlv.sizeof();
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlvSslSubTlv;
        }
        return progress;
    }

    private int decodeProxyTlvSslKey(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            assert (net.decodeSlot != -1);
            MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
            int size = decodeBuf.getInt(net.decodeOffset - 4 - 4);
            int items = decodeBuf.getInt(net.decodeOffset - 4);
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            OctetsFW tlvBounded = this.tlvBoundedRO.wrap(tlv.buffer(), tlv.offset() + 1, tlv.limit());
            String16FW key = tlvBounded.get(this.tlvStringRO::wrap);
            ProxyInfoFW info = (ProxyInfoFW)this.infoRW.wrap(decodeBuf, net.decodeOffset + size - 4, this.decodePool.slotCapacity()).secure(s -> s.key(key)).build();
            decodeBuf.putInt(net.decodeOffset - 4 - 4, size += info.sizeof());
            decodeBuf.putInt(net.decodeOffset - 4, ++items);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableTlvBytes -= tlv.sizeof();
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlvSslSubTlv;
        }
        return progress;
    }

    private int decodeProxyTlvSslSubTlvIgnore(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableTlvBytes -= tlv.sizeof();
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlvSslSubTlv;
        }
        return progress;
    }

    private int decodeProxyTlvNetns(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            assert (net.decodeSlot != -1);
            MutableDirectBuffer decodeBuf = this.decodePool.buffer(net.decodeSlot);
            int size = decodeBuf.getInt(net.decodeOffset - 4 - 4);
            int items = decodeBuf.getInt(net.decodeOffset - 4);
            ProxyTlvFW tlv = this.tlvRO.wrap(buffer, progress, limit);
            OctetsFW tlvBounded = this.tlvBoundedRO.wrap(tlv.buffer(), tlv.offset() + 1, tlv.limit());
            String16FW namespace = tlvBounded.get(this.tlvStringRO::wrap);
            ProxyInfoFW info = (ProxyInfoFW)this.infoRW.wrap(decodeBuf, net.decodeOffset + size - 4, this.decodePool.slotCapacity()).namespace(namespace).build();
            decodeBuf.putInt(net.decodeOffset - 4 - 4, size += info.sizeof());
            decodeBuf.putInt(net.decodeOffset - 4, ++items);
            ProxyServerFactory.updateCRC32C(net.crc32c, tlv.buffer(), tlv.offset(), tlv.sizeof());
            net.decodableBytes -= tlv.sizeof();
            progress += tlv.sizeof();
            net.decoder = this.decodeProxyTlv;
        }
        return progress;
    }

    private int decodeData(ProxyNetServer net, long traceId, long authorization, int flags, long budgetId, int reserved, DirectBuffer buffer, int offset, int progress, int limit) {
        int length = limit - progress;
        if (length > 0) {
            OctetsFW payload = this.payloadRO.wrap(buffer, progress, limit);
            net.app.doAppData(traceId, authorization, budgetId, flags, reserved, payload);
            progress += length;
        }
        return progress;
    }

    private static void updateCRC32C(CRC32C crc32c, DirectBuffer buffer, int index, int length) {
        ByteBuffer buf = buffer.byteBuffer();
        int position = buf.position();
        int limit = buf.limit();
        buf.clear().position(index).limit(index + length);
        crc32c.update(buf);
        buf.clear().position(position).limit(limit);
    }

    private static /* synthetic */ void lambda$newStream$0(ProxyNetServer rec$, int x$0, DirectBuffer x$1, int x$2, int x$3) {
        rec$.onNetMessage(x$0, x$1, x$2, x$3);
    }

    @FunctionalInterface
    private static interface ProxyNetServerDecoder {
        public int decode(ProxyNetServer var1, long var2, long var4, int var6, long var7, int var9, MutableDirectBuffer var10, int var11, int var12, int var13);
    }

    private final class ProxyNetServer {
        private final MessageConsumer receiver;
        private final long routeId;
        private final long initialId;
        private final long affinity;
        private final long replyId;
        private ProxyNetServerDecoder decoder;
        private int decodeSlot = -1;
        private int decodeOffset;
        private int decodeLimit;
        private int decodeReserved;
        private int decodeFlags;
        private ProxyAddrFamily decodedFamily;
        private ProxyAddrProtocol decodedTransport;
        private long decodedCrc32c = -1L;
        private CRC32C crc32c;
        private int decodableBytes;
        private int decodableTlvBytes;
        private int state;
        private long initialSeq;
        private long initialAck;
        private int initialMax;
        private long replySeq;
        private long replyAck;
        private int replyMax;
        private int replyPad;
        private ProxyAppServer app;

        private ProxyNetServer(long routeId, long initialId, MessageConsumer receiver, long affinity) {
            this.routeId = routeId;
            this.initialId = initialId;
            this.receiver = receiver;
            this.affinity = affinity;
            this.replyId = ProxyServerFactory.this.supplyReplyId.applyAsLong(initialId);
            this.decoder = ProxyServerFactory.this.decodeHeader;
        }

        private void onNetMessage(int msgTypeId, DirectBuffer buffer, int index, int length) {
            switch (msgTypeId) {
                case 1: {
                    BeginFW begin = ProxyServerFactory.this.beginRO.wrap(buffer, index, index + length);
                    this.onNetBegin(begin);
                    break;
                }
                case 2: {
                    DataFW data = ProxyServerFactory.this.dataRO.wrap(buffer, index, index + length);
                    this.onNetData(data);
                    break;
                }
                case 3: {
                    EndFW end = ProxyServerFactory.this.endRO.wrap(buffer, index, index + length);
                    this.onNetEnd(end);
                    break;
                }
                case 4: {
                    AbortFW abort = ProxyServerFactory.this.abortRO.wrap(buffer, index, index + length);
                    this.onNetAbort(abort);
                    break;
                }
                case 5: {
                    FlushFW flush = ProxyServerFactory.this.flushRO.wrap(buffer, index, index + length);
                    this.onNetFlush(flush);
                    break;
                }
                case 0x40000002: {
                    WindowFW window = ProxyServerFactory.this.windowRO.wrap(buffer, index, index + length);
                    this.onNetWindow(window);
                    break;
                }
                case 0x40000001: {
                    ResetFW reset = ProxyServerFactory.this.resetRO.wrap(buffer, index, index + length);
                    this.onNetReset(reset);
                    break;
                }
                case 0x40000004: {
                    ChallengeFW challenge = ProxyServerFactory.this.challengeRO.wrap(buffer, index, index + length);
                    this.onNetChallenge(challenge);
                    break;
                }
            }
        }

        private void onNetBegin(BeginFW begin) {
            long traceId = begin.traceId();
            long authorization = begin.authorization();
            OctetsFW extension = begin.extension();
            ProxyBeginExFW beginEx = extension.get(ProxyServerFactory.this.beginExRO::tryWrap);
            this.state = ProxyState.openedInitial(this.state);
            this.crc32c = new CRC32C();
            ProxyServerFactory.this.router.setThrottle(this.replyId, this::onNetMessage);
            if (beginEx != null) {
                this.decodeSlot = ProxyServerFactory.this.decodePool.acquire(this.initialId);
                assert (this.decodeSlot != -1);
                MutableDirectBuffer decodeBuf = ProxyServerFactory.this.decodePool.buffer(this.decodeSlot);
                decodeBuf.putBytes(0, beginEx.buffer(), beginEx.offset(), beginEx.sizeof());
                this.decodeLimit = this.decodeOffset = beginEx.sizeof();
            }
            this.doNetWindow(traceId, authorization, 0L, 0, 0, 0, 0, 16);
        }

        private void onNetData(DataFW data) {
            long sequence = data.sequence();
            long acknowledge = data.acknowledge();
            long traceId = data.traceId();
            long authorization = data.authorization();
            long budgetId = data.budgetId();
            OctetsFW payload = data.payload();
            assert (acknowledge <= sequence);
            assert (sequence >= this.initialSeq);
            this.initialSeq = sequence + (long)data.reserved();
            assert (this.initialAck <= this.initialSeq);
            if (this.initialSeq > this.initialAck + (long)this.initialMax) {
                this.doNetReset(traceId, authorization);
                if (this.app != null) {
                    this.app.doAppAbort(traceId, authorization);
                }
            } else {
                MutableDirectBuffer buffer = (MutableDirectBuffer)payload.buffer();
                int offset = payload.offset();
                int limit = payload.limit();
                int reserved = data.reserved();
                int flags = data.flags();
                if (this.decodeLimit != this.decodeOffset) {
                    assert (this.decodeSlot != -1);
                    MutableDirectBuffer decodeBuffer = ProxyServerFactory.this.decodePool.buffer(this.decodeSlot);
                    decodeBuffer.putBytes(this.decodeLimit, (DirectBuffer)buffer, offset, limit - offset);
                    this.decodeLimit += limit - offset;
                    this.decodeFlags |= flags;
                    buffer = decodeBuffer;
                    offset = this.decodeOffset;
                    limit = this.decodeLimit;
                    reserved = this.decodeReserved;
                    flags = this.decodeFlags;
                }
                this.decodeNet(traceId, authorization, flags, budgetId, reserved, buffer, offset, limit);
            }
        }

        private void onNetEnd(EndFW end) {
            long traceId = end.traceId();
            long authorization = end.authorization();
            this.state = ProxyState.closedInitial(this.state);
            if (this.app != null) {
                this.app.doAppEnd(traceId, authorization);
            } else {
                this.doNetEnd(traceId, authorization);
            }
        }

        private void onNetAbort(AbortFW abort) {
            long traceId = abort.traceId();
            long authorization = abort.authorization();
            this.state = ProxyState.closedInitial(this.state);
            if (this.app != null) {
                this.app.doAppAbort(traceId, authorization);
            } else {
                this.doNetAbort(traceId, authorization);
            }
        }

        private void onNetFlush(FlushFW flush) {
            if (this.app != null) {
                long traceId = flush.traceId();
                long authorization = flush.authorization();
                long budgetId = flush.budgetId();
                int reserved = flush.reserved();
                this.app.doAppFlush(traceId, authorization, budgetId, reserved);
            }
        }

        private void onNetWindow(WindowFW window) {
            int replyWin;
            long sequence = window.sequence();
            long acknowledge = window.acknowledge();
            int maximum = window.maximum();
            long traceId = window.traceId();
            long authorization = window.authorization();
            long budgetId = window.budgetId();
            int padding = window.padding();
            int minimum = window.minimum();
            int capabilities = window.capabilities();
            this.state = ProxyState.openedReply(this.state);
            assert (acknowledge <= sequence);
            assert (sequence <= this.replySeq);
            assert (acknowledge >= this.replyAck);
            assert (maximum >= this.replyMax);
            this.replyAck = acknowledge;
            this.replyMax = maximum;
            this.replyPad = padding;
            assert (this.replyAck <= this.replySeq);
            if (this.app != null && (replyWin = this.replyMax - (int)(this.replySeq - this.replyAck)) > 0) {
                this.app.doAppWindow(traceId, authorization, budgetId, minimum, capabilities, replyWin, this.replyPad, this.replyMax);
            }
        }

        private void onNetReset(ResetFW reset) {
            long traceId = reset.traceId();
            long authorization = reset.authorization();
            this.state = ProxyState.closedReply(this.state);
            if (this.app != null) {
                this.app.doAppReset(traceId, authorization);
            } else {
                this.doNetReset(traceId, authorization);
            }
        }

        private void onNetChallenge(ChallengeFW challenge) {
            long traceId = challenge.traceId();
            long authorization = challenge.authorization();
            OctetsFW extension = challenge.extension();
            if (this.app != null) {
                this.app.doAppChallenge(traceId, authorization, extension);
            }
        }

        private void doNetBegin(long traceId, long authorization, long affinity) {
            ProxyServerFactory.this.doBegin(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization, affinity, EMPTY_OCTETS);
            this.state = ProxyState.openingReply(this.state);
        }

        private void doNetData(long traceId, long authorization, int flags, long budgetId, int reserved, OctetsFW payload) {
            ProxyServerFactory.this.doData(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization, flags, budgetId, reserved, payload);
            this.replySeq += (long)reserved;
            assert (this.replyAck <= this.replySeq);
        }

        private void doNetEnd(long traceId, long authorization) {
            if (!ProxyState.replyClosed(this.state)) {
                ProxyServerFactory.this.doEnd(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization);
                this.state = ProxyState.closedReply(this.state);
            }
        }

        private void doNetAbort(long traceId, long authorization) {
            if (ProxyState.replyOpening(this.state) && !ProxyState.replyClosed(this.state)) {
                ProxyServerFactory.this.doAbort(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization);
                this.state = ProxyState.closedReply(this.state);
            }
        }

        private void doNetFlush(long traceId, long authorization, long budgetId, int reserved) {
            ProxyServerFactory.this.doFlush(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization, budgetId, reserved);
        }

        private void doNetReset(long traceId, long authorization) {
            if (!ProxyState.initialClosed(this.state)) {
                ProxyServerFactory.this.doReset(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization);
                this.state = ProxyState.closedInitial(this.state);
            }
        }

        private void doNetWindow(long traceId, long authorization, long budgetId, int minimum, int capabilities, int minInitialWin, int minInitialPad, int minInitialMax) {
            long newInitialAck = Math.max(this.initialSeq - (long)minInitialWin, this.initialAck);
            if (newInitialAck > this.initialAck || minInitialMax > this.initialMax) {
                this.initialAck = newInitialAck;
                assert (this.initialAck <= this.initialSeq);
                this.initialMax = minInitialMax;
                ProxyServerFactory.this.doWindow(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization, budgetId, minInitialPad, minimum, capabilities);
            }
        }

        private void doNetChallenge(long traceId, long authorization, OctetsFW extension) {
            ProxyServerFactory.this.doChallenge(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization, extension);
        }

        private void decodeNet(long traceId, long authorization, long budgetId) {
            if (this.decodeSlot != -1) {
                MutableDirectBuffer buffer = ProxyServerFactory.this.decodePool.buffer(this.decodeSlot);
                int offset = this.decodeOffset;
                int limit = this.decodeLimit;
                int reserved = this.decodeReserved;
                int flags = this.decodeFlags;
                this.decodeNet(traceId, authorization, flags, budgetId, reserved, buffer, offset, limit);
            }
        }

        private void decodeNet(long traceId, long authorization, int flags, long budgetId, int reserved, MutableDirectBuffer buffer, int offset, int limit) {
            ProxyNetServerDecoder previous = null;
            int progress = offset;
            while (progress <= limit && previous != this.decoder) {
                previous = this.decoder;
                progress = this.decoder.decode(this, traceId, authorization, flags, budgetId, reserved, buffer, offset, progress, limit);
            }
            if (progress < limit) {
                if (this.decodeSlot == -1) {
                    this.decodeSlot = ProxyServerFactory.this.decodePool.acquire(this.initialId);
                }
                if (this.decodeSlot == -1) {
                    this.cleanup(traceId, authorization);
                } else {
                    MutableDirectBuffer decodeBuffer = ProxyServerFactory.this.decodePool.buffer(this.decodeSlot);
                    decodeBuffer.putBytes(0, (DirectBuffer)buffer, progress, limit - progress);
                    this.decodeLimit = this.decodeOffset + limit - progress;
                    this.decodeReserved = (limit - progress) * reserved / (limit - offset);
                }
            } else {
                this.cleanupDecodeSlot(false);
                if (ProxyState.initialClosing(this.state) && this.app != null) {
                    this.app.doAppEnd(traceId, authorization);
                }
            }
        }

        private void onNetReady(long traceId, long authorization) {
            DirectBuffer decodeBuffer = this.decodeSlot != -1 ? ProxyServerFactory.this.decodePool.buffer(this.decodeSlot) : EMPTY_BUFFER;
            ProxyBeginExFW beginEx = ProxyServerFactory.this.beginExRO.tryWrap(decodeBuffer, 0, this.decodeOffset);
            RouteFW route = ProxyServerFactory.this.router.resolveNet(this.routeId, authorization, beginEx);
            if (route != null) {
                long resolvedId = route.correlationId();
                this.app = new ProxyAppServer(this, resolvedId);
                this.app.doAppBegin(traceId, authorization, this.affinity, beginEx != null ? beginEx : EMPTY_OCTETS);
            } else {
                this.cleanup(traceId, authorization);
            }
        }

        private void cleanupDecodeSlot(boolean force) {
            if (this.decodeSlot != -1 && (this.app != null || force)) {
                ProxyServerFactory.this.decodePool.release(this.decodeSlot);
                this.decodeSlot = -1;
                this.decodeOffset = 0;
                this.decodeLimit = 0;
                this.decodeReserved = 0;
                this.decodeFlags = 0;
            }
        }

        private void cleanup(long traceId, long authorization) {
            this.cleanupDecodeSlot(true);
            this.doNetReset(traceId, authorization);
            this.doNetAbort(traceId, authorization);
            if (this.app != null) {
                this.app.cleanup(traceId, authorization);
            }
            this.decoder = ProxyServerFactory.this.decodeIgnoreAll;
        }
    }

    private final class ProxyAppServer {
        private final ProxyNetServer net;
        private final long routeId;
        private final long initialId;
        private final long replyId;
        private final MessageConsumer receiver;
        private int state;
        private long initialSeq;
        private long initialAck;
        private int initialMax;
        private int initialPad;
        private long replySeq;
        private long replyAck;
        private int replyMax;

        private ProxyAppServer(ProxyNetServer net, long routeId) {
            this.net = net;
            this.routeId = routeId;
            this.initialId = ProxyServerFactory.this.supplyInitialId.applyAsLong(routeId);
            this.replyId = ProxyServerFactory.this.supplyReplyId.applyAsLong(this.initialId);
            this.receiver = ProxyServerFactory.this.router.supplyReceiver(this.initialId);
        }

        private void onAppMessage(int msgTypeId, DirectBuffer buffer, int index, int length) {
            switch (msgTypeId) {
                case 1: {
                    BeginFW begin = ProxyServerFactory.this.beginRO.wrap(buffer, index, index + length);
                    this.onAppBegin(begin);
                    break;
                }
                case 2: {
                    DataFW data = ProxyServerFactory.this.dataRO.wrap(buffer, index, index + length);
                    this.onAppData(data);
                    break;
                }
                case 3: {
                    EndFW end = ProxyServerFactory.this.endRO.wrap(buffer, index, index + length);
                    this.onAppEnd(end);
                    break;
                }
                case 4: {
                    AbortFW abort = ProxyServerFactory.this.abortRO.wrap(buffer, index, index + length);
                    this.onAppAbort(abort);
                    break;
                }
                case 5: {
                    FlushFW flush = ProxyServerFactory.this.flushRO.wrap(buffer, index, index + length);
                    this.onAppFlush(flush);
                    break;
                }
                case 0x40000002: {
                    WindowFW window = ProxyServerFactory.this.windowRO.wrap(buffer, index, index + length);
                    this.onAppWindow(window);
                    break;
                }
                case 0x40000001: {
                    ResetFW reset = ProxyServerFactory.this.resetRO.wrap(buffer, index, index + length);
                    this.onAppReset(reset);
                    break;
                }
                case 0x40000004: {
                    ChallengeFW challenge = ProxyServerFactory.this.challengeRO.wrap(buffer, index, index + length);
                    this.onAppChallenge(challenge);
                    break;
                }
            }
        }

        private void onAppBegin(BeginFW begin) {
            long traceId = begin.traceId();
            long authorization = begin.authorization();
            long affinity = begin.affinity();
            this.state = ProxyState.openedReply(this.state);
            this.net.doNetBegin(traceId, authorization, affinity);
        }

        private void onAppData(DataFW data) {
            long sequence = data.sequence();
            long acknowledge = data.acknowledge();
            long authorization = data.authorization();
            long traceId = data.traceId();
            int flags = data.flags();
            long budgetId = data.budgetId();
            int reserved = data.reserved();
            OctetsFW payload = data.payload();
            assert (acknowledge <= sequence);
            assert (sequence >= this.replySeq);
            this.replySeq = sequence + (long)data.reserved();
            assert (this.replyAck <= this.replySeq);
            if (this.replySeq > this.replyAck + (long)this.replyMax) {
                this.doAppReset(traceId, authorization);
                this.net.doNetAbort(traceId, authorization);
            } else {
                this.net.doNetData(traceId, authorization, flags, budgetId, reserved, payload);
            }
        }

        private void onAppEnd(EndFW end) {
            long traceId = end.traceId();
            long authorization = end.authorization();
            this.state = ProxyState.closedReply(this.state);
            this.net.doNetEnd(traceId, authorization);
        }

        private void onAppAbort(AbortFW abort) {
            long traceId = abort.traceId();
            long authorization = abort.authorization();
            this.state = ProxyState.closedReply(this.state);
            this.net.doNetAbort(traceId, authorization);
        }

        private void onAppFlush(FlushFW flush) {
            long traceId = flush.traceId();
            long authorization = flush.authorization();
            long budgetId = flush.budgetId();
            int reserved = flush.reserved();
            this.net.doNetFlush(traceId, authorization, budgetId, reserved);
        }

        private void onAppWindow(WindowFW window) {
            long sequence = window.sequence();
            long acknowledge = window.acknowledge();
            int maximum = window.maximum();
            long traceId = window.traceId();
            long authorization = window.authorization();
            long budgetId = window.budgetId();
            int padding = window.padding();
            int minimum = window.minimum();
            int capabilities = window.capabilities();
            this.state = ProxyState.openedInitial(this.state);
            assert (acknowledge <= sequence);
            assert (sequence <= this.initialSeq);
            assert (acknowledge >= this.initialAck);
            assert (maximum >= this.initialMax);
            this.initialAck = acknowledge;
            this.initialMax = maximum;
            this.initialPad = padding;
            assert (this.initialAck <= this.initialSeq);
            int initialWin = this.initialMax - (int)(this.initialSeq - this.initialAck);
            if (initialWin > 0) {
                this.net.decodeNet(traceId, authorization, budgetId);
                this.net.doNetWindow(traceId, authorization, budgetId, minimum, capabilities, initialWin, this.initialPad, this.initialMax);
            }
        }

        private void onAppReset(ResetFW reset) {
            long traceId = reset.traceId();
            long authorization = reset.authorization();
            this.state = ProxyState.closedInitial(this.state);
            this.net.doNetReset(traceId, authorization);
        }

        private void onAppChallenge(ChallengeFW challenge) {
            long traceId = challenge.traceId();
            long authorization = challenge.authorization();
            OctetsFW extension = challenge.extension();
            this.net.doNetChallenge(traceId, authorization, extension);
        }

        private void doAppBegin(long traceId, long authorization, long affinity, Flyweight extension) {
            ProxyServerFactory.this.correlations.put(this.replyId, this::onAppMessage);
            ProxyServerFactory.this.router.setThrottle(this.initialId, this::onAppMessage);
            ProxyServerFactory.this.doBegin(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization, affinity, extension);
            this.state = ProxyState.openingInitial(this.state);
        }

        private void doAppData(long traceId, long authorization, long budgetId, int flags, int reserved, OctetsFW payload) {
            ProxyServerFactory.this.doData(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization, flags, budgetId, reserved, payload);
            this.initialSeq += (long)reserved;
            assert (this.initialAck <= this.initialSeq);
        }

        private void doAppEnd(long traceId, long authorization) {
            if (!ProxyState.initialClosed(this.state)) {
                ProxyServerFactory.this.doEnd(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization);
                this.state = ProxyState.closedInitial(this.state);
            }
        }

        private void doAppAbort(long traceId, long authorization) {
            if (!ProxyState.initialClosed(this.state)) {
                ProxyServerFactory.this.doAbort(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization);
                this.state = ProxyState.closedInitial(this.state);
            }
        }

        private void doAppFlush(long traceId, long authorization, long budgetId, int reserved) {
            ProxyServerFactory.this.doFlush(this.receiver, this.routeId, this.initialId, this.initialSeq, this.initialAck, this.initialMax, traceId, authorization, budgetId, reserved);
        }

        private void doAppReset(long traceId, long authorization) {
            if (!ProxyState.replyClosed(this.state)) {
                ProxyServerFactory.this.correlations.remove(this.replyId);
                ProxyServerFactory.this.doReset(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization);
                this.state = ProxyState.closedReply(this.state);
            }
        }

        private void doAppWindow(long traceId, long authorization, long budgetId, int minimum, int capabilities, int minReplyWin, int minReplyPad, int minReplyMax) {
            long newReplyAck = Math.max(this.replySeq - (long)minReplyWin, this.replyAck);
            if (newReplyAck > this.replyAck || minReplyMax > this.replyMax) {
                this.replyAck = newReplyAck;
                assert (this.replyAck <= this.replySeq);
                this.replyMax = minReplyMax;
                ProxyServerFactory.this.doWindow(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization, budgetId, minReplyPad, minimum, capabilities);
            }
        }

        private void doAppChallenge(long traceId, long authorization, OctetsFW extension) {
            ProxyServerFactory.this.doChallenge(this.receiver, this.routeId, this.replyId, this.replySeq, this.replyAck, this.replyMax, traceId, authorization, extension);
        }

        private void cleanup(long traceId, long authorization) {
            this.doAppReset(traceId, authorization);
            this.doAppAbort(traceId, authorization);
        }
    }
}

