/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.stream;

import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.buffer.BufferPool;
import org.reaktivity.nukleus.proxy.internal.ProxyConfiguration;
import org.reaktivity.nukleus.proxy.internal.stream.ProxyServerFactory;
import org.reaktivity.nukleus.route.RouteManager;
import org.reaktivity.nukleus.stream.StreamFactory;
import org.reaktivity.nukleus.stream.StreamFactoryBuilder;

public final class ProxyServerFactoryBuilder
implements StreamFactoryBuilder {
    private final ProxyConfiguration config;
    private RouteManager router;
    private MutableDirectBuffer writeBuffer;
    private LongUnaryOperator supplyInitialId;
    private LongUnaryOperator supplyReplyId;
    private Supplier<BufferPool> supplyBufferPool;
    private ToIntFunction<String> supplyTypeId;

    public ProxyServerFactoryBuilder(ProxyConfiguration config) {
        this.config = config;
    }

    public ProxyServerFactoryBuilder setRouteManager(RouteManager router) {
        this.router = router;
        return this;
    }

    public ProxyServerFactoryBuilder setWriteBuffer(MutableDirectBuffer writeBuffer) {
        this.writeBuffer = writeBuffer;
        return this;
    }

    public ProxyServerFactoryBuilder setInitialIdSupplier(LongUnaryOperator supplyInitialId) {
        this.supplyInitialId = supplyInitialId;
        return this;
    }

    public StreamFactoryBuilder setReplyIdSupplier(LongUnaryOperator supplyReplyId) {
        this.supplyReplyId = supplyReplyId;
        return this;
    }

    public StreamFactoryBuilder setBufferPoolSupplier(Supplier<BufferPool> supplyBufferPool) {
        this.supplyBufferPool = supplyBufferPool;
        return this;
    }

    public StreamFactoryBuilder setTypeIdSupplier(ToIntFunction<String> supplyTypeId) {
        this.supplyTypeId = supplyTypeId;
        return this;
    }

    public StreamFactory build() {
        BufferPool bufferPool = this.supplyBufferPool.get();
        return new ProxyServerFactory(this.config, this.router, this.writeBuffer, bufferPool, this.supplyInitialId, this.supplyReplyId, this.supplyTypeId);
    }
}

