/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.stream;

public final class ProxyState {
    private static final int INITIAL_OPENING = 16;
    private static final int INITIAL_OPENED = 32;
    private static final int INITIAL_CLOSING = 64;
    private static final int INITIAL_CLOSED = 128;
    private static final int REPLY_OPENED = 1;
    private static final int REPLY_OPENING = 2;
    private static final int REPLY_CLOSING = 4;
    private static final int REPLY_CLOSED = 8;

    static int openingInitial(int state) {
        return state | 0x10;
    }

    static int openedInitial(int state) {
        return ProxyState.openingInitial(state) | 0x20;
    }

    static boolean initialOpening(int state) {
        return (state & 0x10) != 0;
    }

    static boolean initialOpened(int state) {
        return (state & 0x20) != 0;
    }

    static int closingInitial(int state) {
        return state | 0x40;
    }

    static int closedInitial(int state) {
        return ProxyState.closingInitial(state) | 0x80;
    }

    static boolean initialClosing(int state) {
        return (state & 0x40) != 0;
    }

    static boolean initialClosed(int state) {
        return (state & 0x80) != 0;
    }

    static int openingReply(int state) {
        return state | 2;
    }

    static int openedReply(int state) {
        return ProxyState.openingReply(state) | 1;
    }

    static boolean replyOpening(int state) {
        return (state & 2) != 0;
    }

    static boolean replyOpened(int state) {
        return (state & 1) != 0;
    }

    static int closingReply(int state) {
        return state | 4;
    }

    static int closedReply(int state) {
        return ProxyState.closingReply(state) | 8;
    }

    static boolean replyClosing(int state) {
        return (state & 4) != 0;
    }

    static boolean replyClosed(int state) {
        return (state & 8) != 0;
    }

    static boolean closed(int state) {
        return ProxyState.initialClosed(state) && ProxyState.replyClosed(state);
    }

    static boolean closing(int state) {
        return ProxyState.initialClosing(state) && ProxyState.replyClosing(state);
    }

    private ProxyState() {
    }
}

