/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.MapFW;

public final class Map8FW<K extends Flyweight, V extends Flyweight>
extends MapFW<K, V> {
    private static final int LENGTH_SIZE = 1;
    private static final int FIELD_COUNT_SIZE = 1;
    private static final int LENGTH_OFFSET = 0;
    private static final int FIELD_COUNT_OFFSET = 1;
    private static final int FIELDS_OFFSET = 2;
    private static final int LENGTH_MAX_VALUE = 255;
    private final K keyRO;
    private final V valueRO;
    private final DirectBuffer entriesRO = new UnsafeBuffer(0L, 0);

    public Map8FW(K keyRO, V valueRO) {
        this.keyRO = keyRO;
        this.valueRO = valueRO;
    }

    @Override
    public int length() {
        return this.buffer().getByte(this.offset() + 0);
    }

    @Override
    public int fieldCount() {
        return this.buffer().getByte(this.offset() + 1);
    }

    @Override
    public DirectBuffer entries() {
        return this.entriesRO;
    }

    @Override
    public void forEach(BiConsumer<K, V> consumer) {
        int offset = this.offset() + 2;
        int fieldCount = this.fieldCount();
        for (int i = 0; i < fieldCount; i += 2) {
            Flyweight key = ((Flyweight)this.keyRO).wrap(this.buffer(), offset, this.limit());
            Flyweight value = ((Flyweight)this.valueRO).wrap(this.buffer(), key.limit(), this.limit());
            consumer.accept(key, value);
            offset = value.limit();
        }
    }

    @Override
    public Map8FW<K, V> tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        int entryOffset = offset + 2;
        int fieldCount = this.fieldCount();
        for (int i = 0; i < fieldCount; i += 2) {
            Flyweight key = ((Flyweight)this.keyRO).tryWrap(buffer, entryOffset, maxLimit);
            if (key == null) {
                return null;
            }
            Flyweight value = ((Flyweight)this.valueRO).tryWrap(buffer, key.limit(), maxLimit);
            if (value == null) {
                return null;
            }
            entryOffset = value.limit();
        }
        int itemsSize = this.length() - 1;
        this.entriesRO.wrap(buffer, offset + 2, itemsSize);
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public Map8FW<K, V> wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        int entryOffset = offset + 2;
        int fieldCount = this.fieldCount();
        for (int i = 0; i < fieldCount; i += 2) {
            Flyweight key = ((Flyweight)this.keyRO).wrap(buffer, entryOffset, maxLimit);
            Flyweight value = ((Flyweight)this.valueRO).wrap(buffer, key.limit(), maxLimit);
            entryOffset = value.limit();
        }
        int itemsSize = this.length() - 1;
        this.entriesRO.wrap(buffer, offset + 2, itemsSize);
        Map8FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 1 + this.length();
    }

    public String toString() {
        return String.format("map8<%d, %d>", this.length(), this.fieldCount());
    }

    public static final class Builder<K extends Flyweight, V extends Flyweight, KB extends Flyweight.Builder<K>, VB extends Flyweight.Builder<V>>
    extends MapFW.Builder<Map8FW<K, V>, K, V, KB, VB> {
        private int fieldCount;
        private final KB keyRW;
        private final VB valueRW;

        public Builder(K keyRO, V valueRO, KB keyRW, VB valueRW) {
            super(new Map8FW<K, V>(keyRO, valueRO));
            this.keyRW = keyRW;
            this.valueRW = valueRW;
        }

        public Builder<K, V, KB, VB> wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            int newLimit = offset + 2;
            Flyweight.checkLimit(newLimit, maxLimit);
            this.limit(newLimit);
            this.fieldCount = 0;
            return this;
        }

        public Builder<K, V, KB, VB> entry(Consumer<KB> key, Consumer<VB> value) {
            ((Flyweight.Builder)this.keyRW).wrap(this.buffer(), this.limit(), this.maxLimit());
            key.accept(this.keyRW);
            Flyweight.checkLimit(((Flyweight.Builder)this.keyRW).limit(), this.maxLimit());
            this.limit(((Flyweight.Builder)this.keyRW).limit());
            ++this.fieldCount;
            ((Flyweight.Builder)this.valueRW).wrap(this.buffer(), this.limit(), this.maxLimit());
            value.accept(this.valueRW);
            Flyweight.checkLimit(((Flyweight.Builder)this.valueRW).limit(), this.maxLimit());
            this.limit(((Flyweight.Builder)this.valueRW).limit());
            ++this.fieldCount;
            return this;
        }

        public Builder<K, V, KB, VB> entries(DirectBuffer buffer, int srcOffset, int length, int fieldCount) {
            this.buffer().putBytes(this.offset() + 2, buffer, srcOffset, length);
            int newLimit = this.offset() + 2 + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.limit(newLimit);
            this.fieldCount = fieldCount;
            return this;
        }

        @Override
        public Map8FW<K, V> build() {
            int length = this.limit() - this.offset() - 1;
            assert (length <= 255) : "Length is too large";
            assert (this.fieldCount <= 255) : "Field count is too large";
            this.buffer().putByte(this.offset() + 0, (byte)length);
            this.buffer().putByte(this.offset() + 1, (byte)this.fieldCount);
            return (Map8FW)super.build();
        }
    }
}

