/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressFamily;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressFamilyFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressInet4FW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressInet6FW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressInetFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressNoneFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressUnixFW;

public final class ProxyAddressFW
extends Flyweight {
    public static final ProxyAddressFamily KIND_INET = ProxyAddressFamily.INET;
    public static final ProxyAddressFamily KIND_INET4 = ProxyAddressFamily.INET4;
    public static final ProxyAddressFamily KIND_INET6 = ProxyAddressFamily.INET6;
    public static final ProxyAddressFamily KIND_UNIX = ProxyAddressFamily.UNIX;
    public static final ProxyAddressFamily KIND_NONE = ProxyAddressFamily.NONE;
    private final ProxyAddressFamilyFW proxyAddressFamilyRO = new ProxyAddressFamilyFW();
    private ProxyAddressInetFW inetRO;
    private ProxyAddressInet4FW inet4RO;
    private ProxyAddressInet6FW inet6RO;
    private ProxyAddressUnixFW unixRO;
    private ProxyAddressNoneFW noneRO;

    public ProxyAddressFamily kind() {
        return this.proxyAddressFamilyRO.get();
    }

    public ProxyAddressInetFW inet() {
        if (this.inetRO == null) {
            this.inetRO = new ProxyAddressInetFW();
        }
        return this.inetRO;
    }

    public ProxyAddressInet4FW inet4() {
        if (this.inet4RO == null) {
            this.inet4RO = new ProxyAddressInet4FW();
        }
        return this.inet4RO;
    }

    public ProxyAddressInet6FW inet6() {
        if (this.inet6RO == null) {
            this.inet6RO = new ProxyAddressInet6FW();
        }
        return this.inet6RO;
    }

    public ProxyAddressUnixFW unix() {
        if (this.unixRO == null) {
            this.unixRO = new ProxyAddressUnixFW();
        }
        return this.unixRO;
    }

    public ProxyAddressNoneFW none() {
        if (this.noneRO == null) {
            this.noneRO = new ProxyAddressNoneFW();
        }
        return this.noneRO;
    }

    @Override
    public ProxyAddressFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        ProxyAddressFamilyFW proxyAddressFamily = this.proxyAddressFamilyRO.tryWrap(buffer, offset, maxLimit);
        if (proxyAddressFamily == null) {
            return null;
        }
        switch (this.kind()) {
            case INET: {
                if (this.inet().tryWrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit) != null) break;
                return null;
            }
            case INET4: {
                if (this.inet4().tryWrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit) != null) break;
                return null;
            }
            case INET6: {
                if (this.inet6().tryWrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit) != null) break;
                return null;
            }
            case UNIX: {
                if (this.unix().tryWrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit) != null) break;
                return null;
            }
            case NONE: {
                if (this.none().tryWrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public ProxyAddressFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        ProxyAddressFamilyFW proxyAddressFamily = this.proxyAddressFamilyRO.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case INET: {
                this.inet().wrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit);
                break;
            }
            case INET4: {
                this.inet4().wrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit);
                break;
            }
            case INET6: {
                this.inet6().wrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit);
                break;
            }
            case UNIX: {
                this.unix().wrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit);
                break;
            }
            case NONE: {
                this.none().wrap(buffer, offset + proxyAddressFamily.sizeof(), maxLimit);
                break;
            }
        }
        ProxyAddressFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case INET: {
                return this.inet().limit();
            }
            case INET4: {
                return this.inet4().limit();
            }
            case INET6: {
                return this.inet6().limit();
            }
            case UNIX: {
                return this.unix().limit();
            }
            case NONE: {
                return this.none().limit();
            }
        }
        return this.offset();
    }

    public String toString() {
        switch (this.kind()) {
            case INET: {
                return String.format("PROXY_ADDRESS [inet=%s]", this.inet());
            }
            case INET4: {
                return String.format("PROXY_ADDRESS [inet4=%s]", this.inet4());
            }
            case INET6: {
                return String.format("PROXY_ADDRESS [inet6=%s]", this.inet6());
            }
            case UNIX: {
                return String.format("PROXY_ADDRESS [unix=%s]", this.unix());
            }
            case NONE: {
                return String.format("PROXY_ADDRESS [none=%s]", this.none());
            }
        }
        return String.format("PROXY_ADDRESS [unknown]", new Object[0]);
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyAddressFW> {
        private final ProxyAddressFamilyFW.Builder proxyAddressFamilyRW = new ProxyAddressFamilyFW.Builder();
        private ProxyAddressInetFW.Builder inetRW;
        private ProxyAddressInet4FW.Builder inet4RW;
        private ProxyAddressInet6FW.Builder inet6RW;
        private ProxyAddressUnixFW.Builder unixRW;
        private ProxyAddressNoneFW.Builder noneRW;

        public Builder() {
            super(new ProxyAddressFW());
        }

        public Builder kind(ProxyAddressFamily value) {
            this.proxyAddressFamilyRW.wrap(this.buffer(), this.offset(), this.maxLimit());
            this.proxyAddressFamilyRW.set(value);
            this.limit(this.proxyAddressFamilyRW.build().limit());
            return this;
        }

        private ProxyAddressInetFW.Builder inet() {
            if (this.inetRW == null) {
                this.inetRW = new ProxyAddressInetFW.Builder();
            }
            return this.inetRW.wrap(this.buffer(), this.offset() + this.proxyAddressFamilyRW.sizeof(), this.maxLimit());
        }

        public Builder inet(Consumer<ProxyAddressInetFW.Builder> mutator) {
            this.kind(KIND_INET);
            ProxyAddressInetFW.Builder inet = this.inet();
            mutator.accept(inet);
            this.limit(inet.build().limit());
            return this;
        }

        public Builder inet(ProxyAddressInetFW field) {
            this.kind(KIND_INET);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private ProxyAddressInet4FW.Builder inet4() {
            if (this.inet4RW == null) {
                this.inet4RW = new ProxyAddressInet4FW.Builder();
            }
            return this.inet4RW.wrap(this.buffer(), this.offset() + this.proxyAddressFamilyRW.sizeof(), this.maxLimit());
        }

        public Builder inet4(Consumer<ProxyAddressInet4FW.Builder> mutator) {
            this.kind(KIND_INET4);
            ProxyAddressInet4FW.Builder inet4 = this.inet4();
            mutator.accept(inet4);
            this.limit(inet4.build().limit());
            return this;
        }

        public Builder inet4(ProxyAddressInet4FW field) {
            this.kind(KIND_INET4);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private ProxyAddressInet6FW.Builder inet6() {
            if (this.inet6RW == null) {
                this.inet6RW = new ProxyAddressInet6FW.Builder();
            }
            return this.inet6RW.wrap(this.buffer(), this.offset() + this.proxyAddressFamilyRW.sizeof(), this.maxLimit());
        }

        public Builder inet6(Consumer<ProxyAddressInet6FW.Builder> mutator) {
            this.kind(KIND_INET6);
            ProxyAddressInet6FW.Builder inet6 = this.inet6();
            mutator.accept(inet6);
            this.limit(inet6.build().limit());
            return this;
        }

        public Builder inet6(ProxyAddressInet6FW field) {
            this.kind(KIND_INET6);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private ProxyAddressUnixFW.Builder unix() {
            if (this.unixRW == null) {
                this.unixRW = new ProxyAddressUnixFW.Builder();
            }
            return this.unixRW.wrap(this.buffer(), this.offset() + this.proxyAddressFamilyRW.sizeof(), this.maxLimit());
        }

        public Builder unix(Consumer<ProxyAddressUnixFW.Builder> mutator) {
            this.kind(KIND_UNIX);
            ProxyAddressUnixFW.Builder unix = this.unix();
            mutator.accept(unix);
            this.limit(unix.build().limit());
            return this;
        }

        public Builder unix(ProxyAddressUnixFW field) {
            this.kind(KIND_UNIX);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        private ProxyAddressNoneFW.Builder none() {
            if (this.noneRW == null) {
                this.noneRW = new ProxyAddressNoneFW.Builder();
            }
            return this.noneRW.wrap(this.buffer(), this.offset() + this.proxyAddressFamilyRW.sizeof(), this.maxLimit());
        }

        public Builder none(Consumer<ProxyAddressNoneFW.Builder> mutator) {
            this.kind(KIND_NONE);
            ProxyAddressNoneFW.Builder none = this.none();
            mutator.accept(none);
            this.limit(none.build().limit());
            return this;
        }

        public Builder none(ProxyAddressNoneFW field) {
            this.kind(KIND_NONE);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

