/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressProtocolFW;
import org.reaktivity.nukleus.proxy.internal.types.String16FW;

public final class ProxyAddressInetFW
extends Flyweight {
    public static final int FIELD_OFFSET_PROTOCOL = 0;
    public static final int FIELD_OFFSET_SOURCE = 0;
    public static final int FIELD_OFFSET_DESTINATION = 0;
    public static final int FIELD_OFFSET_SOURCE_PORT = 0;
    private static final int FIELD_SIZE_SOURCE_PORT = 2;
    public static final int FIELD_OFFSET_DESTINATION_PORT = 2;
    private static final int FIELD_SIZE_DESTINATION_PORT = 2;
    private final ProxyAddressProtocolFW protocolRO = new ProxyAddressProtocolFW();
    private final String16FW sourceRO = new String16FW();
    private final String16FW destinationRO = new String16FW();

    public ProxyAddressProtocolFW protocol() {
        return this.protocolRO;
    }

    public String16FW source() {
        return this.sourceRO;
    }

    public String16FW destination() {
        return this.destinationRO;
    }

    public int sourcePort() {
        return this.buffer().getShort(this.destinationRO.limit() + 0) & 0xFFFF;
    }

    public int destinationPort() {
        return this.buffer().getShort(this.destinationRO.limit() + 2) & 0xFFFF;
    }

    @Override
    public ProxyAddressInetFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.protocolRO.wrap(buffer, offset + 0, maxLimit);
        this.sourceRO.wrap(buffer, this.protocolRO.limit() + 0, maxLimit);
        this.destinationRO.wrap(buffer, this.sourceRO.limit() + 0, maxLimit);
        ProxyAddressInetFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyAddressInetFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.protocolRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.sourceRO.tryWrap(buffer, this.protocolRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.destinationRO.tryWrap(buffer, this.sourceRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.destinationRO.limit() + 2 + 2;
    }

    public String toString() {
        return String.format("PROXY_ADDRESS_INET [protocol=%s, source=%s, destination=%s, sourcePort=%d, destinationPort=%d]", this.protocol(), this.sourceRO.asString(), this.destinationRO.asString(), this.sourcePort(), this.destinationPort());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyAddressInetFW> {
        private static final int INDEX_PROTOCOL = 0;
        private static final int INDEX_SOURCE = 1;
        private static final int INDEX_DESTINATION = 2;
        private static final int INDEX_SOURCE_PORT = 3;
        private static final int INDEX_DESTINATION_PORT = 4;
        private static final int FIELD_COUNT = 5;
        private final ProxyAddressProtocolFW.Builder protocolRW = new ProxyAddressProtocolFW.Builder();
        private final String16FW.Builder sourceRW = new String16FW.Builder();
        private final String16FW.Builder destinationRW = new String16FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyAddressInetFW());
        }

        public Builder protocol(Consumer<ProxyAddressProtocolFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            ProxyAddressProtocolFW.Builder protocolRW = this.protocolRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(protocolRW);
            this.limit(protocolRW.build().limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder protocol(ProxyAddressProtocolFW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        private String16FW.Builder source() {
            assert (this.lastFieldSet == 0);
            return this.sourceRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder source(String value) {
            String16FW.Builder sourceRW = this.source();
            sourceRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(sourceRW.build().limit());
            return this;
        }

        public Builder source(String16FW value) {
            String16FW.Builder sourceRW = this.source();
            sourceRW.set((Flyweight)value);
            this.lastFieldSet = 1;
            this.limit(sourceRW.build().limit());
            return this;
        }

        public Builder source(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder sourceRW = this.source();
            sourceRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(sourceRW.build().limit());
            return this;
        }

        private String16FW.Builder destination() {
            assert (this.lastFieldSet == 1);
            return this.destinationRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder destination(String value) {
            String16FW.Builder destinationRW = this.destination();
            destinationRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 2;
            this.limit(destinationRW.build().limit());
            return this;
        }

        public Builder destination(String16FW value) {
            String16FW.Builder destinationRW = this.destination();
            destinationRW.set((Flyweight)value);
            this.lastFieldSet = 2;
            this.limit(destinationRW.build().limit());
            return this;
        }

        public Builder destination(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder destinationRW = this.destination();
            destinationRW.set(buffer, offset, length);
            this.lastFieldSet = 2;
            this.limit(destinationRW.build().limit());
            return this;
        }

        public Builder sourcePort(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"sourcePort\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"sourcePort\"", value));
            }
            assert (this.lastFieldSet == 2);
            int newLimit = this.limit() + 2;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF));
            this.lastFieldSet = 3;
            this.limit(newLimit);
            return this;
        }

        public Builder destinationPort(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"destinationPort\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"destinationPort\"", value));
            }
            assert (this.lastFieldSet == 3);
            int newLimit = this.limit() + 2;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF));
            this.lastFieldSet = 4;
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyAddressInetFW build() {
            assert (this.lastFieldSet == 4);
            this.lastFieldSet = -1;
            return (ProxyAddressInetFW)super.build();
        }
    }
}

