/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressProtocolFW;
import org.reaktivity.nukleus.proxy.internal.types.ProxyAddressRangeUnixFW;

public final class ProxyAddressMatchUnixFW
extends Flyweight {
    public static final int FIELD_OFFSET_PROTOCOL = 0;
    public static final int FIELD_OFFSET_SOURCE = 0;
    public static final int FIELD_OFFSET_DESTINATION = 0;
    private final ProxyAddressProtocolFW protocolRO = new ProxyAddressProtocolFW();
    private final ProxyAddressRangeUnixFW sourceRO = new ProxyAddressRangeUnixFW();
    private final ProxyAddressRangeUnixFW destinationRO = new ProxyAddressRangeUnixFW();

    public ProxyAddressProtocolFW protocol() {
        return this.protocolRO;
    }

    public ProxyAddressRangeUnixFW source() {
        return this.sourceRO;
    }

    public ProxyAddressRangeUnixFW destination() {
        return this.destinationRO;
    }

    @Override
    public ProxyAddressMatchUnixFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.protocolRO.wrap(buffer, offset + 0, maxLimit);
        this.sourceRO.wrap(buffer, this.protocolRO.limit() + 0, maxLimit);
        this.destinationRO.wrap(buffer, this.sourceRO.limit() + 0, maxLimit);
        ProxyAddressMatchUnixFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyAddressMatchUnixFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.protocolRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.sourceRO.tryWrap(buffer, this.protocolRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (null == this.destinationRO.tryWrap(buffer, this.sourceRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.destinationRO.limit();
    }

    public String toString() {
        return String.format("PROXY_ADDRESS_MATCH_UNIX [protocol=%s, source=%s, destination=%s]", this.protocol(), this.source(), this.destination());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyAddressMatchUnixFW> {
        private static final int INDEX_PROTOCOL = 0;
        private static final int INDEX_SOURCE = 1;
        private static final int INDEX_DESTINATION = 2;
        private static final int FIELD_COUNT = 3;
        private final ProxyAddressProtocolFW.Builder protocolRW = new ProxyAddressProtocolFW.Builder();
        private final ProxyAddressRangeUnixFW.Builder sourceRW = new ProxyAddressRangeUnixFW.Builder();
        private final ProxyAddressRangeUnixFW.Builder destinationRW = new ProxyAddressRangeUnixFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyAddressMatchUnixFW());
        }

        public Builder protocol(Consumer<ProxyAddressProtocolFW.Builder> mutator) {
            assert (this.lastFieldSet == -1);
            ProxyAddressProtocolFW.Builder protocolRW = this.protocolRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(protocolRW);
            this.limit(protocolRW.build().limit());
            this.lastFieldSet = 0;
            return this;
        }

        public Builder protocol(ProxyAddressProtocolFW field) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder source(Consumer<ProxyAddressRangeUnixFW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            ProxyAddressRangeUnixFW.Builder sourceRW = this.sourceRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(sourceRW);
            this.limit(sourceRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder source(ProxyAddressRangeUnixFW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder destination(Consumer<ProxyAddressRangeUnixFW.Builder> mutator) {
            if (this.lastFieldSet < 1) {
                this.source((ProxyAddressRangeUnixFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            ProxyAddressRangeUnixFW.Builder destinationRW = this.destinationRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(destinationRW);
            this.limit(destinationRW.build().limit());
            this.lastFieldSet = 2;
            return this;
        }

        public Builder destination(ProxyAddressRangeUnixFW field) {
            if (this.lastFieldSet < 1) {
                this.source((ProxyAddressRangeUnixFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 1);
            int newLimit = this.limit() + field.sizeof();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 2;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyAddressMatchUnixFW build() {
            if (this.lastFieldSet < 2) {
                this.destination((ProxyAddressRangeUnixFW.Builder b) -> {});
            }
            assert (this.lastFieldSet == 2);
            this.lastFieldSet = -1;
            return (ProxyAddressMatchUnixFW)super.build();
        }
    }
}

