/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus.proxy.internal.types;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.proxy.internal.types.ArrayFW;
import org.reaktivity.nukleus.proxy.internal.types.Flyweight;
import org.reaktivity.nukleus.proxy.internal.types.OctetsFW;

public final class ProxyIdentityFW
extends Flyweight {
    public static final int FIELD_OFFSET_LENGTH = 0;
    private static final int FIELD_SIZE_LENGTH = 2;
    public static final int FIELD_OFFSET_VALUE = 2;
    private final OctetsFW valueRO = new OctetsFW();

    public int length() {
        return this.buffer().getShort(this.offset() + 0) & 0xFFFF;
    }

    public OctetsFW value() {
        return this.valueRO;
    }

    @Override
    public ProxyIdentityFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.valueRO.wrap(buffer, offset + 2, offset + 2 + this.length());
        ProxyIdentityFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public ProxyIdentityFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        int limit = offset + 2 + this.length();
        if (limit > maxLimit || null == this.valueRO.tryWrap(buffer, offset + 2, limit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.valueRO.limit();
    }

    public String toString() {
        return String.format("PROXY_IDENTITY [length=%d, value=%s]", this.length(), this.value());
    }

    public static final class Builder
    extends Flyweight.Builder<ProxyIdentityFW> {
        public static final int DEFAULT_LENGTH = 0;
        private static final int INDEX_VALUE = 0;
        private static final int FIELD_COUNT = 1;
        private int dynamicOffsetLength;
        private final OctetsFW.Builder valueRW = new OctetsFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new ProxyIdentityFW());
        }

        private Builder length(int value) {
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"length\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"length\"", value));
            }
            int newLimit = this.limit() + 2;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF));
            this.dynamicOffsetLength = this.limit();
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder value() {
            this.length(0);
            assert (this.lastFieldSet == -1);
            return this.valueRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder value(OctetsFW value) {
            OctetsFW.Builder valueRW = this.value();
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null for field \"value\" that does not default to null");
            }
            valueRW.set(value);
            int newLimit = ((OctetsFW)valueRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder value(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder valueRW = this.value();
            mutator.accept(valueRW);
            int newLimit = ((OctetsFW)valueRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder value(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder valueRW = this.value();
            valueRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)valueRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.lastFieldSet = 0;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
            super.wrap(array);
            this.dynamicOffsetLength = -1;
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public ProxyIdentityFW build() {
            assert (this.lastFieldSet == 0);
            this.lastFieldSet = -1;
            return (ProxyIdentityFW)super.build();
        }
    }
}

